/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.optimizations.SymbolMapper;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;

public class PushLimitThroughProject
implements Rule<LimitNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.project().matching(projectNode -> !projectNode.isIdentity()).capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        ProjectNode projectNode = (ProjectNode)captures.get(CHILD);
        if (!parent.isWithTies()) {
            return Rule.Result.ofPlanNode(Util.transpose(parent, projectNode));
        }
        SymbolMapper.Builder symbolMapper = SymbolMapper.builder();
        for (Symbol symbol : parent.getTiesResolvingScheme().get().getOrderBy()) {
            Expression expression = projectNode.getAssignments().get(symbol);
            if (!(expression instanceof SymbolReference)) {
                return Rule.Result.empty();
            }
            symbolMapper.put(symbol, Symbol.from(expression));
        }
        LimitNode mappedLimitNode = symbolMapper.build().map(parent, projectNode.getSource());
        return Rule.Result.ofPlanNode(projectNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)mappedLimitNode)));
    }
}

