/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;

public class RemoveUnreferencedScalarSubqueries
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNode input = correlatedJoinNode.getInput();
        PlanNode subquery = correlatedJoinNode.getSubquery();
        if (this.isUnreferencedScalar(input, context.getLookup()) && correlatedJoinNode.getCorrelation().isEmpty() && (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.INNER || correlatedJoinNode.getType() == CorrelatedJoinNode.Type.RIGHT || QueryCardinalityUtil.isAtLeastScalar(subquery, context.getLookup()))) {
            return Rule.Result.ofPlanNode(subquery);
        }
        if (this.isUnreferencedScalar(subquery, context.getLookup())) {
            return Rule.Result.ofPlanNode(input);
        }
        return Rule.Result.empty();
    }

    private boolean isUnreferencedScalar(PlanNode planNode, Lookup lookup) {
        return planNode.getOutputSymbols().isEmpty() && QueryCardinalityUtil.isScalar(planNode, lookup);
    }
}

