/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.cost.CostComparator;
import io.prestosql.cost.CostProvider;
import io.prestosql.cost.PlanCostEstimate;
import io.prestosql.cost.PlanNodeStatsAndCostSummary;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsProvider;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.DeterminismEvaluator;
import io.prestosql.sql.planner.EqualityInference;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.DetermineJoinDistributionType;
import io.prestosql.sql.planner.iterative.rule.PushProjectionThroughJoin;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ReorderJoins
implements Rule<JoinNode> {
    private static final Logger log = Logger.get(ReorderJoins.class);
    private final Pattern<JoinNode> pattern;
    private final Metadata metadata;
    private final CostComparator costComparator;

    public ReorderJoins(Metadata metadata, CostComparator costComparator) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
        this.pattern = Patterns.join().matching(joinNode -> !joinNode.getDistributionType().isPresent() && joinNode.getType() == JoinNode.Type.INNER && DeterminismEvaluator.isDeterministic(joinNode.getFilter().orElse((Expression)BooleanLiteral.TRUE_LITERAL), metadata));
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.getJoinReorderingStrategy(session) == FeaturesConfig.JoinReorderingStrategy.AUTOMATIC;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        MultiJoinNode multiJoinNode = MultiJoinNode.toMultiJoinNode(this.metadata, joinNode, context, true);
        JoinEnumerationResult resultWithProjectionPushdown = this.chooseJoinOrder(multiJoinNode, context);
        if (!resultWithProjectionPushdown.getPlanNode().isPresent()) {
            return Rule.Result.empty();
        }
        if (!multiJoinNode.isPushedProjectionThroughJoin()) {
            return Rule.Result.ofPlanNode(resultWithProjectionPushdown.getPlanNode().get());
        }
        multiJoinNode = MultiJoinNode.toMultiJoinNode(this.metadata, joinNode, context, false);
        JoinEnumerationResult resultWithoutProjectionPushdown = this.chooseJoinOrder(multiJoinNode, context);
        if (!resultWithoutProjectionPushdown.getPlanNode().isPresent() || this.costComparator.compare(context.getSession(), resultWithProjectionPushdown.cost, resultWithoutProjectionPushdown.cost) < 0) {
            return Rule.Result.ofPlanNode(resultWithProjectionPushdown.getPlanNode().get());
        }
        return Rule.Result.ofPlanNode(resultWithoutProjectionPushdown.getPlanNode().get());
    }

    private JoinEnumerationResult chooseJoinOrder(MultiJoinNode multiJoinNode, Rule.Context context) {
        JoinEnumerator joinEnumerator = new JoinEnumerator(this.metadata, this.costComparator, multiJoinNode.getFilter(), context);
        return joinEnumerator.chooseJoinOrder(multiJoinNode.getSources(), multiJoinNode.getOutputSymbols());
    }

    @VisibleForTesting
    static class JoinEnumerationResult {
        static final JoinEnumerationResult UNKNOWN_COST_RESULT = new JoinEnumerationResult(Optional.empty(), PlanCostEstimate.unknown());
        static final JoinEnumerationResult INFINITE_COST_RESULT = new JoinEnumerationResult(Optional.empty(), PlanCostEstimate.infinite());
        private final Optional<PlanNode> planNode;
        private final PlanCostEstimate cost;

        private JoinEnumerationResult(Optional<PlanNode> planNode, PlanCostEstimate cost) {
            this.planNode = Objects.requireNonNull(planNode, "planNode is null");
            this.cost = Objects.requireNonNull(cost, "cost is null");
            Preconditions.checkArgument(((cost.hasUnknownComponents() || cost.equals(PlanCostEstimate.infinite())) && !planNode.isPresent() || (!cost.hasUnknownComponents() || !cost.equals(PlanCostEstimate.infinite())) && planNode.isPresent() ? 1 : 0) != 0, (Object)"planNode should be present if and only if cost is known");
        }

        public Optional<PlanNode> getPlanNode() {
            return this.planNode;
        }

        public PlanCostEstimate getCost() {
            return this.cost;
        }

        static JoinEnumerationResult createJoinEnumerationResult(Optional<PlanNode> planNode, PlanCostEstimate cost) {
            if (cost.hasUnknownComponents()) {
                return UNKNOWN_COST_RESULT;
            }
            if (cost.equals(PlanCostEstimate.infinite())) {
                return INFINITE_COST_RESULT;
            }
            return new JoinEnumerationResult(planNode, cost);
        }
    }

    @VisibleForTesting
    static class MultiJoinNode {
        private final LinkedHashSet<PlanNode> sources;
        private final Expression filter;
        private final List<Symbol> outputSymbols;
        private final boolean pushedProjectionThroughJoin;

        MultiJoinNode(LinkedHashSet<PlanNode> sources, Expression filter, List<Symbol> outputSymbols, boolean pushedProjectionThroughJoin) {
            Objects.requireNonNull(sources, "sources is null");
            Preconditions.checkArgument((sources.size() > 1 ? 1 : 0) != 0, (Object)"sources size is <= 1");
            Objects.requireNonNull(filter, "filter is null");
            Objects.requireNonNull(outputSymbols, "outputSymbols is null");
            this.sources = sources;
            this.filter = filter;
            this.outputSymbols = ImmutableList.copyOf(outputSymbols);
            this.pushedProjectionThroughJoin = pushedProjectionThroughJoin;
            List inputSymbols = (List)sources.stream().flatMap(source -> source.getOutputSymbols().stream()).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((boolean)inputSymbols.containsAll(outputSymbols), (Object)"inputs do not contain all output symbols");
        }

        public Expression getFilter() {
            return this.filter;
        }

        public LinkedHashSet<PlanNode> getSources() {
            return this.sources;
        }

        public List<Symbol> getOutputSymbols() {
            return this.outputSymbols;
        }

        public boolean isPushedProjectionThroughJoin() {
            return this.pushedProjectionThroughJoin;
        }

        public static Builder builder() {
            return new Builder();
        }

        public int hashCode() {
            return Objects.hash(this.sources, ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(this.filter)), this.outputSymbols, this.pushedProjectionThroughJoin);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultiJoinNode)) {
                return false;
            }
            MultiJoinNode other = (MultiJoinNode)obj;
            return this.sources.equals(other.sources) && ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(this.filter)).equals((Object)ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(other.filter))) && this.outputSymbols.equals(other.outputSymbols) && this.pushedProjectionThroughJoin == other.pushedProjectionThroughJoin;
        }

        static MultiJoinNode toMultiJoinNode(Metadata metadata, JoinNode joinNode, Rule.Context context, boolean pushProjectionsThroughJoin) {
            return MultiJoinNode.toMultiJoinNode(metadata, joinNode, context.getLookup(), context.getIdAllocator(), SystemSessionProperties.getMaxReorderedJoins(context.getSession()), pushProjectionsThroughJoin);
        }

        static MultiJoinNode toMultiJoinNode(Metadata metadata, JoinNode joinNode, Lookup lookup, PlanNodeIdAllocator planNodeIdAllocator, int joinLimit, boolean pushProjectionsThroughJoin) {
            return new JoinNodeFlattener(metadata, joinNode, lookup, planNodeIdAllocator, joinLimit + 1, pushProjectionsThroughJoin).toMultiJoinNode();
        }

        static class Builder {
            private List<PlanNode> sources;
            private Expression filter;
            private List<Symbol> outputSymbols;

            Builder() {
            }

            public Builder setSources(PlanNode ... sources) {
                this.sources = ImmutableList.copyOf((Object[])sources);
                return this;
            }

            public Builder setFilter(Expression filter) {
                this.filter = filter;
                return this;
            }

            public Builder setOutputSymbols(Symbol ... outputSymbols) {
                this.outputSymbols = ImmutableList.copyOf((Object[])outputSymbols);
                return this;
            }

            public MultiJoinNode build() {
                return new MultiJoinNode(new LinkedHashSet<PlanNode>(this.sources), this.filter, this.outputSymbols, false);
            }
        }

        private static class JoinNodeFlattener {
            private final Metadata metadata;
            private final Lookup lookup;
            private final PlanNodeIdAllocator planNodeIdAllocator;
            private final LinkedHashSet<PlanNode> sources = new LinkedHashSet();
            private final List<Expression> filters = new ArrayList<Expression>();
            private final List<Symbol> outputSymbols;
            private final boolean pushProjectionsThroughJoin;
            private boolean pushedProjectionThroughJoin;

            JoinNodeFlattener(Metadata metadata, JoinNode node, Lookup lookup, PlanNodeIdAllocator planNodeIdAllocator, int sourceLimit, boolean pushProjectionsThroughJoin) {
                this.metadata = Objects.requireNonNull(metadata, "metadata is null");
                Objects.requireNonNull(node, "node is null");
                Preconditions.checkState((node.getType() == JoinNode.Type.INNER ? 1 : 0) != 0, (Object)"join type must be INNER");
                this.outputSymbols = node.getOutputSymbols();
                this.lookup = Objects.requireNonNull(lookup, "lookup is null");
                this.planNodeIdAllocator = Objects.requireNonNull(planNodeIdAllocator, "planNodeIdAllocator is null");
                this.pushProjectionsThroughJoin = pushProjectionsThroughJoin;
                this.flattenNode(node, sourceLimit);
            }

            private void flattenNode(PlanNode node, int limit) {
                PlanNode resolved = this.lookup.resolve(node);
                if (resolved instanceof ProjectNode) {
                    if (!this.pushProjectionsThroughJoin) {
                        this.sources.add(node);
                        return;
                    }
                    Optional<PlanNode> rewrittenNode = PushProjectionThroughJoin.pushProjectionThroughJoin(this.metadata, (ProjectNode)resolved, this.lookup, this.planNodeIdAllocator);
                    if (!rewrittenNode.isPresent()) {
                        this.sources.add(node);
                        return;
                    }
                    this.pushedProjectionThroughJoin = true;
                    this.flattenNode(rewrittenNode.get(), limit);
                    return;
                }
                if (!(resolved instanceof JoinNode) || this.sources.size() > limit - 2) {
                    this.sources.add(node);
                    return;
                }
                JoinNode joinNode = (JoinNode)resolved;
                if (joinNode.getType() != JoinNode.Type.INNER || !DeterminismEvaluator.isDeterministic(joinNode.getFilter().orElse((Expression)BooleanLiteral.TRUE_LITERAL), this.metadata) || joinNode.getDistributionType().isPresent()) {
                    this.sources.add(node);
                    return;
                }
                this.flattenNode(joinNode.getLeft(), limit - 1);
                this.flattenNode(joinNode.getRight(), limit);
                joinNode.getCriteria().stream().map(JoinNode.EquiJoinClause::toExpression).forEach(this.filters::add);
                joinNode.getFilter().ifPresent(this.filters::add);
            }

            MultiJoinNode toMultiJoinNode() {
                return new MultiJoinNode(this.sources, ExpressionUtils.and(this.filters), this.outputSymbols, this.pushedProjectionThroughJoin);
            }
        }
    }

    @VisibleForTesting
    static class JoinEnumerator {
        private final Metadata metadata;
        private final Session session;
        private final StatsProvider statsProvider;
        private final CostProvider costProvider;
        private final Ordering<JoinEnumerationResult> resultComparator;
        private final PlanNodeIdAllocator idAllocator;
        private final Expression allFilter;
        private final EqualityInference allFilterInference;
        private final Lookup lookup;
        private final Rule.Context context;
        private final Map<Set<PlanNode>, JoinEnumerationResult> memo = new HashMap<Set<PlanNode>, JoinEnumerationResult>();

        @VisibleForTesting
        JoinEnumerator(Metadata metadata, CostComparator costComparator, Expression filter, Rule.Context context) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.context = Objects.requireNonNull(context);
            this.session = Objects.requireNonNull(context.getSession(), "session is null");
            this.statsProvider = Objects.requireNonNull(context.getStatsProvider(), "statsProvider is null");
            this.costProvider = Objects.requireNonNull(context.getCostProvider(), "costProvider is null");
            this.resultComparator = costComparator.forSession(this.session).onResultOf(result -> ((JoinEnumerationResult)result).cost);
            this.idAllocator = Objects.requireNonNull(context.getIdAllocator(), "idAllocator is null");
            this.allFilter = Objects.requireNonNull(filter, "filter is null");
            this.allFilterInference = EqualityInference.newInstance(metadata, filter);
            this.lookup = Objects.requireNonNull(context.getLookup(), "lookup is null");
        }

        private JoinEnumerationResult chooseJoinOrder(LinkedHashSet<PlanNode> sources, List<Symbol> outputSymbols) {
            this.context.checkTimeoutNotExhausted();
            ImmutableSet multiJoinKey = ImmutableSet.copyOf(sources);
            JoinEnumerationResult bestResult = this.memo.get(multiJoinKey);
            if (bestResult == null) {
                Preconditions.checkState((sources.size() > 1 ? 1 : 0) != 0, (Object)"sources size is less than or equal to one");
                ImmutableList.Builder resultBuilder = ImmutableList.builder();
                Set<Set<Integer>> partitions = JoinEnumerator.generatePartitions(sources.size());
                for (Set<Integer> partition : partitions) {
                    JoinEnumerationResult result = this.createJoinAccordingToPartitioning(sources, outputSymbols, partition);
                    if (result.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                        this.memo.put((Set<PlanNode>)multiJoinKey, result);
                        return result;
                    }
                    if (result.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) continue;
                    resultBuilder.add((Object)result);
                }
                ImmutableList results = resultBuilder.build();
                if (results.isEmpty()) {
                    this.memo.put((Set<PlanNode>)multiJoinKey, JoinEnumerationResult.INFINITE_COST_RESULT);
                    return JoinEnumerationResult.INFINITE_COST_RESULT;
                }
                bestResult = (JoinEnumerationResult)this.resultComparator.min((Iterable)results);
                this.memo.put((Set<PlanNode>)multiJoinKey, bestResult);
            }
            bestResult.planNode.ifPresent(planNode -> log.debug("Least cost join was: %s", new Object[]{planNode}));
            return bestResult;
        }

        @VisibleForTesting
        static Set<Set<Integer>> generatePartitions(int totalNodes) {
            Preconditions.checkArgument((totalNodes > 1 ? 1 : 0) != 0, (Object)"totalNodes must be greater than 1");
            Set numbers = (Set)IntStream.range(0, totalNodes).boxed().collect(ImmutableSet.toImmutableSet());
            return (Set)Sets.powerSet((Set)numbers).stream().filter(subSet -> subSet.contains(0)).filter(subSet -> subSet.size() < numbers.size()).collect(ImmutableSet.toImmutableSet());
        }

        @VisibleForTesting
        JoinEnumerationResult createJoinAccordingToPartitioning(LinkedHashSet<PlanNode> sources, List<Symbol> outputSymbols, Set<Integer> partitioning) {
            ImmutableList sourceList = ImmutableList.copyOf(sources);
            LinkedHashSet leftSources = partitioning.stream().map(((List)sourceList)::get).collect(Collectors.toCollection(LinkedHashSet::new));
            LinkedHashSet rightSources = sources.stream().filter(source -> !leftSources.contains(source)).collect(Collectors.toCollection(LinkedHashSet::new));
            return this.createJoin(leftSources, rightSources, outputSymbols);
        }

        private JoinEnumerationResult createJoin(LinkedHashSet<PlanNode> leftSources, LinkedHashSet<PlanNode> rightSources, List<Symbol> outputSymbols) {
            Set rightSymbols;
            Set leftSymbols = (Set)leftSources.stream().flatMap(node -> node.getOutputSymbols().stream()).collect(ImmutableSet.toImmutableSet());
            List<Expression> joinPredicates = this.getJoinPredicates(leftSymbols, rightSymbols = (Set)rightSources.stream().flatMap(node -> node.getOutputSymbols().stream()).collect(ImmutableSet.toImmutableSet()));
            List joinConditions = (List)joinPredicates.stream().filter(JoinEnumerator::isJoinEqualityCondition).map(predicate -> JoinEnumerator.toEquiJoinClause((ComparisonExpression)predicate, leftSymbols)).collect(ImmutableList.toImmutableList());
            if (joinConditions.isEmpty()) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            List joinFilters = (List)joinPredicates.stream().filter(predicate -> !JoinEnumerator.isJoinEqualityCondition(predicate)).collect(ImmutableList.toImmutableList());
            ImmutableSet requiredJoinSymbols = ImmutableSet.builder().addAll(outputSymbols).addAll(SymbolsExtractor.extractUnique(joinPredicates)).build();
            JoinEnumerationResult leftResult = this.getJoinSource(leftSources, (List)requiredJoinSymbols.stream().filter(leftSymbols::contains).collect(ImmutableList.toImmutableList()));
            if (leftResult.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            if (leftResult.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            PlanNode left = (PlanNode)leftResult.planNode.orElseThrow(() -> new VerifyException("Plan node is not present"));
            JoinEnumerationResult rightResult = this.getJoinSource(rightSources, (List)requiredJoinSymbols.stream().filter(rightSymbols::contains).collect(ImmutableList.toImmutableList()));
            if (rightResult.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            if (rightResult.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            PlanNode right = (PlanNode)rightResult.planNode.orElseThrow(() -> new VerifyException("Plan node is not present"));
            List leftOutputSymbols = (List)left.getOutputSymbols().stream().filter(outputSymbols::contains).collect(ImmutableList.toImmutableList());
            List rightOutputSymbols = (List)right.getOutputSymbols().stream().filter(outputSymbols::contains).collect(ImmutableList.toImmutableList());
            return this.setJoinNodeProperties(new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.INNER, left, right, joinConditions, leftOutputSymbols, rightOutputSymbols, joinFilters.isEmpty() ? Optional.empty() : Optional.of(ExpressionUtils.and(joinFilters)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, Symbol>)ImmutableMap.of(), Optional.empty()));
        }

        private List<Expression> getJoinPredicates(Set<Symbol> leftSymbols, Set<Symbol> rightSymbols) {
            ImmutableList.Builder joinPredicatesBuilder = ImmutableList.builder();
            Streams.stream(EqualityInference.nonInferrableConjuncts(this.metadata, this.allFilter)).map(conjunct -> this.allFilterInference.rewrite((Expression)conjunct, (Set<Symbol>)Sets.union((Set)leftSymbols, (Set)rightSymbols))).filter(Objects::nonNull).filter(conjunct -> this.allFilterInference.rewrite((Expression)conjunct, leftSymbols) == null).filter(conjunct -> this.allFilterInference.rewrite((Expression)conjunct, rightSymbols) == null).forEach(arg_0 -> ((ImmutableList.Builder)joinPredicatesBuilder).add(arg_0));
            List<Expression> joinEqualities = this.allFilterInference.generateEqualitiesPartitionedBy((Set<Symbol>)Sets.union(leftSymbols, rightSymbols)).getScopeEqualities();
            EqualityInference joinInference = EqualityInference.newInstance(this.metadata, joinEqualities.toArray(new Expression[0]));
            joinPredicatesBuilder.addAll(joinInference.generateEqualitiesPartitionedBy(leftSymbols).getScopeStraddlingEqualities());
            return joinPredicatesBuilder.build();
        }

        private JoinEnumerationResult getJoinSource(LinkedHashSet<PlanNode> nodes, List<Symbol> outputSymbols) {
            if (nodes.size() == 1) {
                PlanNode planNode = (PlanNode)Iterables.getOnlyElement(nodes);
                ImmutableSet scope = ImmutableSet.copyOf(outputSymbols);
                ImmutableList.Builder predicates = ImmutableList.builder();
                predicates.addAll(this.allFilterInference.generateEqualitiesPartitionedBy((Set<Symbol>)scope).getScopeEqualities());
                Streams.stream(EqualityInference.nonInferrableConjuncts(this.metadata, this.allFilter)).map(arg_0 -> this.lambda$getJoinSource$14((Set)scope, arg_0)).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)predicates).add(arg_0));
                Expression filter = ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)predicates.build());
                if (!BooleanLiteral.TRUE_LITERAL.equals((Object)filter)) {
                    planNode = new FilterNode(this.idAllocator.getNextId(), planNode, filter);
                }
                return this.createJoinEnumerationResult(planNode);
            }
            return this.chooseJoinOrder(nodes, outputSymbols);
        }

        private static boolean isJoinEqualityCondition(Expression expression) {
            return expression instanceof ComparisonExpression && ((ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL && ((ComparisonExpression)expression).getLeft() instanceof SymbolReference && ((ComparisonExpression)expression).getRight() instanceof SymbolReference;
        }

        private static JoinNode.EquiJoinClause toEquiJoinClause(ComparisonExpression equality, Set<Symbol> leftSymbols) {
            Symbol leftSymbol = Symbol.from(equality.getLeft());
            Symbol rightSymbol = Symbol.from(equality.getRight());
            JoinNode.EquiJoinClause equiJoinClause = new JoinNode.EquiJoinClause(leftSymbol, rightSymbol);
            return leftSymbols.contains(leftSymbol) ? equiJoinClause : equiJoinClause.flip();
        }

        private JoinEnumerationResult setJoinNodeProperties(JoinNode joinNode) {
            if (QueryCardinalityUtil.isAtMostScalar(joinNode.getRight(), this.lookup)) {
                return this.createJoinEnumerationResult(joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED));
            }
            if (QueryCardinalityUtil.isAtMostScalar(joinNode.getLeft(), this.lookup)) {
                return this.createJoinEnumerationResult(joinNode.flipChildren().withDistributionType(JoinNode.DistributionType.REPLICATED));
            }
            List<JoinEnumerationResult> possibleJoinNodes = this.getPossibleJoinNodes(joinNode, SystemSessionProperties.getJoinDistributionType(this.session));
            Verify.verify((!possibleJoinNodes.isEmpty() ? 1 : 0) != 0, (String)"possibleJoinNodes is empty", (Object[])new Object[0]);
            if (possibleJoinNodes.stream().anyMatch(JoinEnumerationResult.UNKNOWN_COST_RESULT::equals)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            return (JoinEnumerationResult)this.resultComparator.min(possibleJoinNodes);
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, FeaturesConfig.JoinDistributionType distributionType) {
            Preconditions.checkArgument((joinNode.getType() == JoinNode.Type.INNER ? 1 : 0) != 0, (String)"unexpected join node type: %s", (Object)((Object)joinNode.getType()));
            if (joinNode.isCrossJoin()) {
                return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED);
            }
            switch (distributionType) {
                case PARTITIONED: {
                    return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.PARTITIONED);
                }
                case BROADCAST: {
                    return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED);
                }
                case AUTOMATIC: {
                    ImmutableList.Builder result = ImmutableList.builder();
                    result.addAll(this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.PARTITIONED));
                    result.addAll(this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED, node -> DetermineJoinDistributionType.canReplicate(node, this.context)));
                    return result.build();
                }
            }
            throw new IllegalArgumentException("unexpected join distribution type: " + (Object)((Object)distributionType));
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, JoinNode.DistributionType distributionType) {
            return this.getPossibleJoinNodes(joinNode, distributionType, node -> true);
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, JoinNode.DistributionType distributionType, Predicate<JoinNode> isAllowed) {
            ImmutableList nodes = ImmutableList.of((Object)joinNode.withDistributionType(distributionType), (Object)joinNode.flipChildren().withDistributionType(distributionType));
            return (List)nodes.stream().filter(isAllowed).map(this::createJoinEnumerationResult).collect(ImmutableList.toImmutableList());
        }

        private JoinEnumerationResult createJoinEnumerationResult(JoinNode joinNode) {
            PlanCostEstimate costEstimate = this.costProvider.getCost(joinNode);
            PlanNodeStatsEstimate statsEstimate = this.statsProvider.getStats(joinNode);
            return JoinEnumerationResult.createJoinEnumerationResult(Optional.of(joinNode.withReorderJoinStatsAndCost(new PlanNodeStatsAndCostSummary(statsEstimate.getOutputRowCount(), statsEstimate.getOutputSizeInBytes(joinNode.getOutputSymbols(), this.context.getSymbolAllocator().getTypes()), costEstimate.getCpuCost(), costEstimate.getMaxMemory(), costEstimate.getNetworkCost()))), costEstimate);
        }

        private JoinEnumerationResult createJoinEnumerationResult(PlanNode planNode) {
            return JoinEnumerationResult.createJoinEnumerationResult(Optional.of(planNode), this.costProvider.getCost(planNode));
        }

        private /* synthetic */ Expression lambda$getJoinSource$14(Set scope, Expression conjunct) {
            return this.allFilterInference.rewrite(conjunct, scope);
        }
    }
}

