/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

final class Util {
    private Util() {
    }

    public static Optional<Set<Symbol>> pruneInputs(Collection<Symbol> availableInputs, Collection<Expression> expressions) {
        ImmutableSet availableInputsSet = ImmutableSet.copyOf(availableInputs);
        Set prunedInputs = Sets.filter((Set)availableInputsSet, SymbolsExtractor.extractUnique(expressions)::contains);
        if (prunedInputs.size() == availableInputsSet.size()) {
            return Optional.empty();
        }
        return Optional.of(prunedInputs);
    }

    public static PlanNode transpose(PlanNode parent, PlanNode child) {
        return child.replaceChildren((List<PlanNode>)ImmutableList.of((Object)parent.replaceChildren(child.getSources())));
    }

    public static Optional<PlanNode> restrictOutputs(PlanNodeIdAllocator idAllocator, PlanNode node, Set<Symbol> permittedOutputs) {
        List restrictedOutputs = (List)node.getOutputSymbols().stream().filter(permittedOutputs::contains).collect(ImmutableList.toImmutableList());
        if (restrictedOutputs.size() == node.getOutputSymbols().size()) {
            return Optional.empty();
        }
        return Optional.of(new ProjectNode(idAllocator.getNextId(), node, Assignments.identity(restrictedOutputs)));
    }

    @SafeVarargs
    public static Optional<PlanNode> restrictChildOutputs(PlanNodeIdAllocator idAllocator, PlanNode node, Set<Symbol> ... permittedChildOutputsArgs) {
        ImmutableList permittedChildOutputs = ImmutableList.copyOf((Object[])permittedChildOutputsArgs);
        Preconditions.checkArgument((node.getSources().size() == permittedChildOutputs.size() ? 1 : 0) != 0, (String)"Mismatched child (%d) and permitted outputs (%d) sizes", (int)node.getSources().size(), (int)permittedChildOutputs.size());
        ImmutableList.Builder newChildrenBuilder = ImmutableList.builder();
        boolean rewroteChildren = false;
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode oldChild = node.getSources().get(i);
            Optional<PlanNode> newChild = Util.restrictOutputs(idAllocator, oldChild, (Set)permittedChildOutputs.get(i));
            rewroteChildren |= newChild.isPresent();
            newChildrenBuilder.add((Object)newChild.orElse(oldChild));
        }
        if (!rewroteChildren) {
            return Optional.empty();
        }
        return Optional.of(node.replaceChildren((List<PlanNode>)newChildrenBuilder.build()));
    }
}

