/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexJoinNode
extends PlanNode {
    private final Type type;
    private final PlanNode probeSource;
    private final PlanNode indexSource;
    private final List<EquiJoinClause> criteria;
    private final Optional<Symbol> probeHashSymbol;
    private final Optional<Symbol> indexHashSymbol;

    @JsonCreator
    public IndexJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="probeSource") PlanNode probeSource, @JsonProperty(value="indexSource") PlanNode indexSource, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="probeHashSymbol") Optional<Symbol> probeHashSymbol, @JsonProperty(value="indexHashSymbol") Optional<Symbol> indexHashSymbol) {
        super(id);
        this.type = Objects.requireNonNull(type, "type is null");
        this.probeSource = Objects.requireNonNull(probeSource, "probeSource is null");
        this.indexSource = Objects.requireNonNull(indexSource, "indexSource is null");
        this.criteria = ImmutableList.copyOf((Collection)Objects.requireNonNull(criteria, "criteria is null"));
        this.probeHashSymbol = Objects.requireNonNull(probeHashSymbol, "probeHashSymbol is null");
        this.indexHashSymbol = Objects.requireNonNull(indexHashSymbol, "indexHashSymbol is null");
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="probeSource")
    public PlanNode getProbeSource() {
        return this.probeSource;
    }

    @JsonProperty(value="indexSource")
    public PlanNode getIndexSource() {
        return this.indexSource;
    }

    @JsonProperty(value="criteria")
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty(value="probeHashSymbol")
    public Optional<Symbol> getProbeHashSymbol() {
        return this.probeHashSymbol;
    }

    @JsonProperty(value="indexHashSymbol")
    public Optional<Symbol> getIndexHashSymbol() {
        return this.indexHashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.probeSource, (Object)this.indexSource);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.probeSource.getOutputSymbols()).addAll(this.indexSource.getOutputSymbols()).build();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitIndexJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new IndexJoinNode(this.getId(), this.type, newChildren.get(0), newChildren.get(1), this.criteria, this.probeHashSymbol, this.indexHashSymbol);
    }

    public static class EquiJoinClause {
        private final Symbol probe;
        private final Symbol index;

        @JsonCreator
        public EquiJoinClause(@JsonProperty(value="probe") Symbol probe, @JsonProperty(value="index") Symbol index) {
            this.probe = Objects.requireNonNull(probe, "probe is null");
            this.index = Objects.requireNonNull(index, "index is null");
        }

        @JsonProperty(value="probe")
        public Symbol getProbe() {
            return this.probe;
        }

        @JsonProperty(value="index")
        public Symbol getIndex() {
            return this.index;
        }
    }

    public static enum Type {
        INNER("Inner"),
        SOURCE_OUTER("SourceOuter");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }
    }
}

