/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.planprinter;

import io.airlift.slice.Slice;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.InterpretedFunctionInvoker;
import java.util.Objects;

public final class ValuePrinter {
    private final Metadata metadata;
    private final Session session;

    public ValuePrinter(Metadata metadata, Session session) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public String castToVarchar(Type type, Object value) {
        try {
            return this.castToVarcharOrFail(type, value);
        }
        catch (OperatorNotFoundException e) {
            return "<UNREPRESENTABLE VALUE>";
        }
    }

    public String castToVarcharOrFail(Type type, Object value) throws OperatorNotFoundException {
        if (value == null) {
            return "NULL";
        }
        ResolvedFunction coercion = this.metadata.getCoercion(type, (Type)VarcharType.VARCHAR);
        Slice coerced = (Slice)new InterpretedFunctionInvoker(this.metadata).invoke(coercion, this.session.toConnectorSession(), value);
        return coerced.toStringUtf8();
    }
}

