/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public final class InternalTypeManager
implements TypeManager {
    private final Metadata metadata;

    @Inject
    public InternalTypeManager(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public Type getType(TypeSignature signature) {
        return this.metadata.getType(signature);
    }

    public Type fromSqlType(String type) {
        return this.metadata.fromSqlType(type);
    }

    public Type getType(TypeId id) {
        return this.metadata.getType(id);
    }

    public MethodHandle resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) {
        ResolvedFunction signature = this.metadata.resolveOperator(operatorType, argumentTypes);
        return this.metadata.getScalarFunctionImplementation(signature).getMethodHandle();
    }
}

