/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableLayoutResult;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarColumnMetadata;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarConnectorId;
import org.apache.pulsar.sql.presto.PulsarConnectorUtils;
import org.apache.pulsar.sql.presto.PulsarDispatchingRowDecoderFactory;
import org.apache.pulsar.sql.presto.PulsarHandleResolver;
import org.apache.pulsar.sql.presto.PulsarInternalColumn;
import org.apache.pulsar.sql.presto.PulsarSqlSchemaInfoProvider;
import org.apache.pulsar.sql.presto.PulsarTableHandle;
import org.apache.pulsar.sql.presto.PulsarTableLayoutHandle;

public class PulsarMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final PulsarAdmin pulsarAdmin;
    private final PulsarConnectorConfig pulsarConnectorConfig;
    private final PulsarDispatchingRowDecoderFactory decoderFactory;
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final Logger log = Logger.get(PulsarMetadata.class);
    private final LoadingCache<SchemaTableName, TopicName> tableNameTopicNameCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<SchemaTableName, TopicName>(){

        public TopicName load(SchemaTableName schemaTableName) throws Exception {
            return PulsarMetadata.this.getMatchedPulsarTopic(schemaTableName);
        }
    });

    @Inject
    public PulsarMetadata(PulsarConnectorId connectorId, PulsarConnectorConfig pulsarConnectorConfig, PulsarDispatchingRowDecoderFactory decoderFactory) {
        this.decoderFactory = decoderFactory;
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.pulsarConnectorConfig = pulsarConnectorConfig;
        try {
            this.pulsarAdmin = pulsarConnectorConfig.getPulsarAdmin();
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        LinkedList<String> prestoSchemas = new LinkedList<String>();
        try {
            List tenants = this.pulsarAdmin.tenants().getTenants();
            for (String tenant : tenants) {
                prestoSchemas.addAll(this.pulsarAdmin.namespaces().getNamespaces(tenant).stream().map(namespace -> PulsarConnectorUtils.rewriteNamespaceDelimiterIfNeeded(namespace, this.pulsarConnectorConfig)).collect(Collectors.toList()));
            }
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 401) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "Failed to get schemas from pulsar: Unauthorized");
            }
            throw new RuntimeException("Failed to get schemas from pulsar: " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
        }
        return prestoSchemas;
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        TopicName topicName = this.getMatchedTopicName(tableName);
        return new PulsarTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName(), topicName.getLocalName());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        PulsarTableHandle handle = PulsarHandleResolver.convertTableHandle(table);
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new PulsarTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        SchemaTableName schemaTableName = PulsarHandleResolver.convertTableHandle(table).toSchemaTableName();
        ConnectorTableMetadata connectorTableMetadata = this.getTableMetadata(schemaTableName, true);
        if (connectorTableMetadata == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            connectorTableMetadata = new ConnectorTableMetadata(schemaTableName, (List)builder.build());
        }
        return connectorTableMetadata;
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        String schemaNameOrNull;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (schemaName.isPresent() && !(schemaNameOrNull = schemaName.get()).equals(INFORMATION_SCHEMA)) {
            List pulsarTopicList = null;
            try {
                pulsarTopicList = this.pulsarAdmin.topics().getList(PulsarConnectorUtils.restoreNamespaceDelimiterIfNeeded(schemaNameOrNull, this.pulsarConnectorConfig), TopicDomain.persistent);
            }
            catch (PulsarAdminException e) {
                if (e.getStatusCode() == 404) {
                    log.warn("Schema " + schemaNameOrNull + " does not exsit");
                    return builder.build();
                }
                if (e.getStatusCode() == 401) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to get tables/topics in %s: Unauthorized", schemaNameOrNull));
                }
                throw new RuntimeException("Failed to get tables/topics in " + schemaNameOrNull + ": " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
            }
            if (pulsarTopicList != null) {
                pulsarTopicList.stream().map(topic -> TopicName.get((String)topic).getPartitionedTopicName()).distinct().forEach(topic -> builder.add((Object)new SchemaTableName(schemaNameOrNull, TopicName.get((String)topic).getLocalName())));
            }
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        PulsarTableHandle pulsarTableHandle = PulsarHandleResolver.convertTableHandle(tableHandle);
        ConnectorTableMetadata tableMetaData = this.getTableMetadata(pulsarTableHandle.toSchemaTableName(), false);
        if (tableMetaData == null) {
            return new HashMap<String, ColumnHandle>();
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        tableMetaData.getColumns().forEach(columnMetadata -> {
            PulsarColumnMetadata pulsarColumnMetadata = (PulsarColumnMetadata)((Object)columnMetadata);
            PulsarColumnHandle pulsarColumnHandle = new PulsarColumnHandle(this.connectorId, pulsarColumnMetadata.getNameWithCase(), pulsarColumnMetadata.getType(), pulsarColumnMetadata.isHidden(), pulsarColumnMetadata.isInternal(), pulsarColumnMetadata.getDecoderExtraInfo().getMapping(), pulsarColumnMetadata.getDecoderExtraInfo().getDataFormat(), pulsarColumnMetadata.getDecoderExtraInfo().getFormatHint(), pulsarColumnMetadata.getHandleKeyValueType());
            columnHandles.put((Object)columnMetadata.getName(), (Object)pulsarColumnHandle);
        });
        PulsarInternalColumn.getInternalFields().forEach(pulsarInternalColumn -> {
            PulsarColumnHandle pulsarColumnHandle = pulsarInternalColumn.getColumnHandle(this.connectorId, false);
            columnHandles.put((Object)pulsarColumnHandle.getName(), (Object)pulsarColumnHandle);
        });
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        PulsarHandleResolver.convertTableHandle(tableHandle);
        return PulsarHandleResolver.convertColumnHandle(columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = !prefix.getTable().isPresent() ? this.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)new SchemaTableName((String)prefix.getSchema().get(), (String)prefix.getTable().get()));
        for (SchemaTableName tableName : tableNames) {
            ConnectorTableMetadata connectorTableMetadata = this.getTableMetadata(tableName, true);
            if (connectorTableMetadata == null) continue;
            columns.put((Object)tableName, (Object)connectorTableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName, boolean withInternalColumns) {
        SchemaInfo schemaInfo;
        if (schemaTableName.getSchemaName().equals(INFORMATION_SCHEMA)) {
            return null;
        }
        TopicName topicName = this.getMatchedTopicName(schemaTableName);
        try {
            schemaInfo = this.pulsarAdmin.schemas().getSchemaInfo(topicName.getSchemaName());
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                schemaInfo = PulsarSqlSchemaInfoProvider.defaultSchema();
            }
            if (e.getStatusCode() == 401) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to get pulsar topic schema information for topic %s: Unauthorized", topicName));
            }
            throw new RuntimeException("Failed to get pulsar topic schema information for topic " + topicName + ": " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
        }
        List<ColumnMetadata> handles = this.getPulsarColumns(topicName, schemaInfo, withInternalColumns, PulsarColumnHandle.HandleKeyValueType.NONE);
        return new ConnectorTableMetadata(schemaTableName, handles);
    }

    @VisibleForTesting
    public List<ColumnMetadata> getPulsarColumns(TopicName topicName, SchemaInfo schemaInfo, boolean withInternalColumns, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        SchemaType schemaType = schemaInfo.getType();
        if (schemaType.isStruct() || schemaType.isPrimitive()) {
            return this.getPulsarColumnsFromSchema(topicName, schemaInfo, withInternalColumns, handleKeyValueType);
        }
        if (schemaType.equals((Object)SchemaType.KEY_VALUE)) {
            return this.getPulsarColumnsFromKeyValueSchema(topicName, schemaInfo, withInternalColumns);
        }
        throw new IllegalArgumentException("Unsupported schema : " + schemaInfo);
    }

    List<ColumnMetadata> getPulsarColumnsFromSchema(TopicName topicName, SchemaInfo schemaInfo, boolean withInternalColumns, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.decoderFactory.extractColumnMetadata(topicName, schemaInfo, handleKeyValueType));
        if (withInternalColumns) {
            PulsarInternalColumn.getInternalFields().stream().forEach(pulsarInternalColumn -> builder.add((Object)pulsarInternalColumn.getColumnMetadata(false)));
        }
        return builder.build();
    }

    List<ColumnMetadata> getPulsarColumnsFromKeyValueSchema(TopicName topicName, SchemaInfo schemaInfo, boolean withInternalColumns) {
        ImmutableList.Builder builder = ImmutableList.builder();
        KeyValue kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)schemaInfo);
        SchemaInfo keySchemaInfo = (SchemaInfo)kvSchemaInfo.getKey();
        List<ColumnMetadata> keyColumnMetadataList = this.getPulsarColumns(topicName, keySchemaInfo, false, PulsarColumnHandle.HandleKeyValueType.KEY);
        builder.addAll(keyColumnMetadataList);
        SchemaInfo valueSchemaInfo = (SchemaInfo)kvSchemaInfo.getValue();
        List<ColumnMetadata> valueColumnMetadataList = this.getPulsarColumns(topicName, valueSchemaInfo, false, PulsarColumnHandle.HandleKeyValueType.VALUE);
        builder.addAll(valueColumnMetadataList);
        if (withInternalColumns) {
            PulsarInternalColumn.getInternalFields().forEach(pulsarInternalColumn -> builder.add((Object)pulsarInternalColumn.getColumnMetadata(false)));
        }
        return builder.build();
    }

    private TopicName getMatchedTopicName(SchemaTableName schemaTableName) {
        TopicName topicName;
        try {
            topicName = (TopicName)this.tableNameTopicNameCache.get((Object)schemaTableName);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to get table handler for tableName " + schemaTableName);
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new TableNotFoundException(schemaTableName);
        }
        return topicName;
    }

    private TopicName getMatchedPulsarTopic(SchemaTableName schemaTableName) {
        Set topicsSetWithoutPartition;
        String namespace = PulsarConnectorUtils.restoreNamespaceDelimiterIfNeeded(schemaTableName.getSchemaName(), this.pulsarConnectorConfig);
        try {
            List allTopics = this.pulsarAdmin.topics().getList(namespace, TopicDomain.persistent);
            topicsSetWithoutPartition = allTopics.stream().map(t -> t.split("-partition-")[0]).collect(Collectors.toSet());
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema " + namespace + " does not exist");
            }
            if (e.getStatusCode() == 401) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to get topics in schema %s: Unauthorized", namespace));
            }
            throw new RuntimeException("Failed to get topics in schema " + namespace + ": " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
        }
        List matchedTopics = topicsSetWithoutPartition.stream().filter(t -> TopicName.get((String)t).getLocalName().equalsIgnoreCase(schemaTableName.getTableName())).collect(Collectors.toList());
        if (matchedTopics.size() == 0) {
            log.error("Table %s not found", new Object[]{String.format("%s/%s", namespace, schemaTableName.getTableName())});
            throw new TableNotFoundException(schemaTableName);
        }
        if (matchedTopics.size() != 1) {
            String errMsg = String.format("There are multiple topics %s matched the table name %s", matchedTopics.toString(), String.format("%s/%s", namespace, schemaTableName.getTableName()));
            log.error(errMsg);
            throw new TableNotFoundException(schemaTableName, errMsg);
        }
        log.info("matched topic %s for table %s ", new Object[]{matchedTopics.get(0), schemaTableName});
        return TopicName.get((String)((String)matchedTopics.get(0)));
    }
}

