/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.base.security.AccessControlRules;
import io.prestosql.plugin.base.security.FileBasedAccessControlConfig;
import io.prestosql.plugin.base.security.SchemaAccessControlRule;
import io.prestosql.plugin.base.security.SessionPropertyAccessControlRule;
import io.prestosql.plugin.base.security.TableAccessControlRule;
import io.prestosql.plugin.base.util.JsonUtils;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorSecurityContext;
import io.prestosql.spi.connector.SchemaRoutineName;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;

public class FileBasedAccessControl
implements ConnectorAccessControl {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final List<SchemaAccessControlRule> schemaRules;
    private final List<TableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;

    @Inject
    public FileBasedAccessControl(FileBasedAccessControlConfig config) {
        AccessControlRules rules = JsonUtils.parseJson(Paths.get(config.getConfigFile(), new String[0]), AccessControlRules.class);
        this.schemaRules = rules.getSchemaRules();
        this.tableRules = rules.getTableRules();
        this.sessionPropertyRules = rules.getSessionPropertyRules();
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyCreateSchema((String)schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyDropSchema((String)schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        if (!this.isSchemaOwner(context, schemaName) || !this.isSchemaOwner(context, newSchemaName)) {
            AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, PrestoPrincipal principal) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denySetSchemaAuthorization((String)schemaName, (PrestoPrincipal)principal);
        }
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyShowCreateTable((String)tableName.toString());
        }
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isSchemaOwner(context, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkAnyTablePermission(context, tableName)) {
            AccessDeniedException.denyShowColumns((String)tableName.toString());
        }
    }

    public List<ColumnMetadata> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, List<ColumnMetadata> columns) {
        if (!this.checkAnyTablePermission(context, tableName)) {
            return ImmutableList.of();
        }
        return columns;
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newTableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanSetTableComment(ConnectorSecurityContext identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.INSERT)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.isSchemaOwner(context, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newViewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
        }
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.GRANT_SELECT)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (ConnectorIdentity)context.getIdentity());
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        if (!this.canSetSessionProperty(context, propertyName)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean grantOption) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOption) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<PrestoPrincipal> grantor) {
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role, String catalogName) {
    }

    public void checkCanShowRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
    }

    public Optional<ViewExpression> getRowFilter(ConnectorSecurityContext context, SchemaTableName tableName) {
        return Optional.empty();
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        return Optional.empty();
    }

    private boolean canSetSessionProperty(ConnectorSecurityContext context, String property) {
        ConnectorIdentity identity = context.getIdentity();
        for (SessionPropertyAccessControlRule rule : this.sessionPropertyRules) {
            Optional<Boolean> allowed = rule.match(identity.getUser(), identity.getGroups(), property);
            if (!allowed.isPresent()) continue;
            return allowed.get();
        }
        return false;
    }

    private boolean checkAnyTablePermission(ConnectorSecurityContext context, SchemaTableName tableName) {
        return this.checkTablePermission(context, tableName, (Set<TableAccessControlRule.TablePrivilege> privileges) -> !privileges.isEmpty());
    }

    private boolean checkTablePermission(ConnectorSecurityContext context, SchemaTableName tableName, TableAccessControlRule.TablePrivilege ... requiredPrivileges) {
        return this.checkTablePermission(context, tableName, (Set<TableAccessControlRule.TablePrivilege> privileges) -> privileges.containsAll((Collection<?>)ImmutableSet.copyOf((Object[])requiredPrivileges)));
    }

    private boolean checkTablePermission(ConnectorSecurityContext context, SchemaTableName tableName, Predicate<Set<TableAccessControlRule.TablePrivilege>> checkPrivileges) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        ConnectorIdentity identity = context.getIdentity();
        for (TableAccessControlRule rule : this.tableRules) {
            Optional<Set<TableAccessControlRule.TablePrivilege>> tablePrivileges = rule.match(identity.getUser(), identity.getGroups(), tableName);
            if (!tablePrivileges.isPresent()) continue;
            return checkPrivileges.test(tablePrivileges.get());
        }
        return false;
    }

    private boolean isSchemaOwner(ConnectorSecurityContext context, String schemaName) {
        ConnectorIdentity identity = context.getIdentity();
        for (SchemaAccessControlRule rule : this.schemaRules) {
            Optional<Boolean> owner = rule.match(identity.getUser(), identity.getGroups(), schemaName);
            if (!owner.isPresent()) continue;
            return owner.get();
        }
        return false;
    }
}

