/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.util.Objects;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.util.Slice;

public class LookupResult {
    private final LookupKey key;
    private final Slice value;
    private final boolean deleted;

    public static LookupResult ok(LookupKey key, Slice value) {
        return new LookupResult(key, value, false);
    }

    public static LookupResult deleted(LookupKey key) {
        return new LookupResult(key, null, true);
    }

    private LookupResult(LookupKey key, Slice value, boolean deleted) {
        Objects.requireNonNull(key, "key is null");
        this.key = key;
        this.value = value != null ? value.slice() : null;
        this.deleted = deleted;
    }

    public LookupKey getKey() {
        return this.key;
    }

    public Slice getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value;
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

