/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Insert
extends Statement {
    private final QualifiedName target;
    private final Query query;
    private final Optional<List<Identifier>> columns;

    public Insert(QualifiedName target, Optional<List<Identifier>> columns, Query query) {
        this(Optional.empty(), columns, target, query);
    }

    private Insert(Optional<NodeLocation> location, Optional<List<Identifier>> columns, QualifiedName target, Query query) {
        super(location);
        this.target = Objects.requireNonNull(target, "target is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.query = Objects.requireNonNull(query, "query is null");
    }

    public QualifiedName getTarget() {
        return this.target;
    }

    public Optional<List<Identifier>> getColumns() {
        return this.columns;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsert(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.target, this.columns, this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Insert o = (Insert)obj;
        return Objects.equals(this.target, o.target) && Objects.equals(this.columns, o.columns) && Objects.equals(this.query, o.query);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("columns", this.columns).add("query", (Object)this.query).toString();
    }
}

