/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metastore;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public abstract class MSException
extends Exception {
    private final Code code;

    MSException(Code code, String errMsg) {
        super(code.getDescription() + " : " + errMsg);
        this.code = code;
    }

    MSException(Code code, String errMsg, Throwable cause) {
        super(code.getDescription() + " : " + errMsg, cause);
        this.code = code;
    }

    public Code getCode() {
        return this.code;
    }

    public static MSException create(Code code) {
        return MSException.create(code, "", null);
    }

    public static MSException create(Code code, String errMsg) {
        return MSException.create(code, errMsg, null);
    }

    public static MSException create(Code code, String errMsg, Throwable cause) {
        switch (code) {
            case BadVersion: {
                return new BadVersionException(errMsg, cause);
            }
            case NoKey: {
                return new NoKeyException(errMsg, cause);
            }
            case KeyExists: {
                return new KeyExistsException(errMsg, cause);
            }
            case InterruptedException: {
                return new MSInterruptedException(errMsg, cause);
            }
            case IllegalOp: {
                return new IllegalOpException(errMsg, cause);
            }
            case ServiceDown: {
                return new ServiceDownException(errMsg, cause);
            }
            case OperationFailure: {
                return new OperationFailureException(errMsg, cause);
            }
        }
        throw new IllegalArgumentException("Invalid exception code");
    }

    public static class OperationFailureException
    extends MSException {
        public OperationFailureException(String errMsg) {
            super(Code.OperationFailure, errMsg);
        }

        public OperationFailureException(String errMsg, Throwable cause) {
            super(Code.OperationFailure, errMsg, cause);
        }
    }

    public static class ServiceDownException
    extends MSException {
        public ServiceDownException(String errMsg) {
            super(Code.ServiceDown, errMsg);
        }

        public ServiceDownException(String errMsg, Throwable cause) {
            super(Code.ServiceDown, errMsg, cause);
        }
    }

    public static class IllegalOpException
    extends MSException {
        public IllegalOpException(String errMsg) {
            super(Code.IllegalOp, errMsg);
        }

        public IllegalOpException(String errMsg, Throwable cause) {
            super(Code.IllegalOp, errMsg, cause);
        }
    }

    public static class MSInterruptedException
    extends MSException {
        public MSInterruptedException(String errMsg) {
            super(Code.InterruptedException, errMsg);
        }

        public MSInterruptedException(String errMsg, Throwable cause) {
            super(Code.InterruptedException, errMsg, cause);
        }
    }

    public static class KeyExistsException
    extends MSException {
        public KeyExistsException(String errMsg) {
            super(Code.KeyExists, errMsg);
        }

        public KeyExistsException(String errMsg, Throwable cause) {
            super(Code.KeyExists, errMsg, cause);
        }
    }

    public static class NoEntriesException
    extends MSException {
        public NoEntriesException(String errMsg) {
            super(Code.NoEntries, errMsg);
        }

        public NoEntriesException(String errMsg, Throwable cause) {
            super(Code.NoEntries, errMsg, cause);
        }
    }

    public static class NoKeyException
    extends MSException {
        public NoKeyException(String errMsg) {
            super(Code.NoKey, errMsg);
        }

        public NoKeyException(String errMsg, Throwable cause) {
            super(Code.NoKey, errMsg, cause);
        }
    }

    public static class BadVersionException
    extends MSException {
        public BadVersionException(String errMsg) {
            super(Code.BadVersion, errMsg);
        }

        public BadVersionException(String errMsg, Throwable cause) {
            super(Code.BadVersion, errMsg, cause);
        }
    }

    public static enum Code {
        OK(0, "OK"),
        BadVersion(-1, "Version conflict"),
        NoKey(-2, "Key does not exist"),
        KeyExists(-3, "Key exists"),
        NoEntries(-4, "No entries found"),
        InterruptedException(-100, "Operation interrupted"),
        IllegalOp(-101, "Illegal operation"),
        ServiceDown(-102, "Metadata service is down"),
        OperationFailure(-103, "Operaion failed on metadata storage server side");

        private static final Map<Integer, Code> codes;
        private final int code;
        private final String description;

        private Code(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static Code get(int code) {
            return codes.get(code);
        }

        static {
            codes = new HashMap<Integer, Code>();
            for (Code c : EnumSet.allOf(Code.class)) {
                codes.put(c.code, c);
            }
        }
    }
}

