/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Preconditions;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;

public class BookieStateReadOnlyService
implements HttpEndpointService {
    private final Bookie bookie;

    public BookieStateReadOnlyService(Bookie bookie) {
        this.bookie = (Bookie)Preconditions.checkNotNull((Object)bookie);
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        BookieStateManager stateManager = this.bookie.getStateManager();
        if (HttpServer.Method.PUT.equals((Object)request.getMethod())) {
            ReadOnlyState inState = (ReadOnlyState)JsonUtil.fromJson((String)request.getBody(), ReadOnlyState.class);
            if (stateManager.isReadOnly() && !inState.isReadOnly()) {
                stateManager.transitionToWritableMode().get();
            } else if (!stateManager.isReadOnly() && inState.isReadOnly()) {
                stateManager.transitionToReadOnlyMode().get();
            }
        } else if (!HttpServer.Method.GET.equals((Object)request.getMethod())) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Unsupported method. Should be GET or PUT method");
            return response;
        }
        ReadOnlyState outState = new ReadOnlyState(stateManager.isReadOnly());
        response.setBody(JsonUtil.toJson((Object)outState));
        response.setCode(HttpServer.StatusCode.OK);
        return response;
    }

    public static class ReadOnlyState {
        private boolean readOnly;

        public ReadOnlyState(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public ReadOnlyState() {
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadOnlyState)) {
                return false;
            }
            ReadOnlyState other = (ReadOnlyState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isReadOnly() == other.isReadOnly();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReadOnlyState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isReadOnly() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "BookieStateReadOnlyService.ReadOnlyState(readOnly=" + this.isReadOnly() + ")";
        }
    }
}

