/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.raw;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import org.apache.pulsar.common.api.proto.MessageMetadata;

public class ReferenceCountedMessageMetadata
extends AbstractReferenceCounted {
    private static final Recycler<ReferenceCountedMessageMetadata> RECYCLER = new Recycler<ReferenceCountedMessageMetadata>(){

        protected ReferenceCountedMessageMetadata newObject(Recycler.Handle<ReferenceCountedMessageMetadata> handle) {
            return new ReferenceCountedMessageMetadata(handle);
        }
    };
    private final MessageMetadata metadata = new MessageMetadata();
    private ByteBuf parsedBuf;
    private final Recycler.Handle<ReferenceCountedMessageMetadata> handle;

    private ReferenceCountedMessageMetadata(Recycler.Handle<ReferenceCountedMessageMetadata> handle) {
        this.handle = handle;
    }

    public static ReferenceCountedMessageMetadata get(ByteBuf parsedBuf) {
        ReferenceCountedMessageMetadata ref = (ReferenceCountedMessageMetadata)((Object)RECYCLER.get());
        ref.parsedBuf = parsedBuf;
        ref.parsedBuf.retain();
        ref.setRefCnt(1);
        return ref;
    }

    public MessageMetadata getMetadata() {
        return this.metadata;
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    protected void deallocate() {
        if (this.parsedBuf != null) {
            this.parsedBuf.release();
        }
        this.metadata.clear();
        this.handle.recycle((Object)this);
    }
}

