/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.AbstractInvocationHandler;
import io.airlift.log.Logger;
import io.airlift.parameternames.ParameterNames;
import io.airlift.units.Duration;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LoggingInvocationHandler
extends AbstractInvocationHandler {
    private final Object delegate;
    private final ParameterNamesProvider parameterNames;
    private final Consumer<String> logger;

    public LoggingInvocationHandler(Object delegate, ParameterNamesProvider parameterNames, Consumer<String> logger) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.parameterNames = Objects.requireNonNull(parameterNames, "parameterNames is null");
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        long startNanos = System.nanoTime();
        try {
            result = method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            Duration elapsed = Duration.nanosSince((long)startNanos);
            Throwable t = e.getCause();
            this.logger.accept(String.format("%s took %s and failed with %s", this.invocationDescription(method, args), elapsed, t));
            throw t;
        }
        Duration elapsed = Duration.nanosSince((long)startNanos);
        this.logger.accept(String.format("%s succeeded in %s", this.invocationDescription(method, args), elapsed));
        return result;
    }

    private String invocationDescription(Method method, Object[] args) {
        Optional<List<String>> parameterNames = this.parameterNames.getParameterNames(method);
        return "Invocation of " + method.getName() + IntStream.range(0, args.length).mapToObj(i -> {
            if (parameterNames.isPresent()) {
                return String.format("%s=%s", ((List)parameterNames.get()).get(i), LoggingInvocationHandler.formatArgument(args[i]));
            }
            return LoggingInvocationHandler.formatArgument(args[i]);
        }).collect(Collectors.joining(", ", "(", ")"));
    }

    private static String formatArgument(Object arg) {
        if (arg instanceof String) {
            return "'" + ((String)arg).replace("'", "''") + "'";
        }
        return String.valueOf(arg);
    }

    public static class AirliftParameterNamesProvider
    implements ParameterNamesProvider {
        private static final Logger log = Logger.get(AirliftParameterNamesProvider.class);
        private final Map<Method, List<String>> parameterNames;

        public <I, C extends I> AirliftParameterNamesProvider(Class<I> interfaceClass, Class<C> implementationClass) {
            Objects.requireNonNull(interfaceClass, "interfaceClass is null");
            Objects.requireNonNull(implementationClass, "implementationClass is null");
            ImmutableMap.Builder parameterNames = ImmutableMap.builder();
            for (Method interfaceMethod : interfaceClass.getMethods()) {
                AirliftParameterNamesProvider.tryGetParameterNamesForMethod(interfaceMethod, implementationClass).map(ImmutableList::copyOf).ifPresent(names -> parameterNames.put((Object)interfaceMethod, names));
            }
            this.parameterNames = parameterNames.build();
        }

        private static Optional<List<String>> tryGetParameterNamesForMethod(Method interfaceMethod, Class<?> implementationClass) {
            Method implementationMethod;
            Optional names = ParameterNames.tryGetParameterNames((Executable)interfaceMethod);
            if (names.isPresent()) {
                return names;
            }
            try {
                implementationMethod = implementationClass.getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                log.debug((Throwable)e, "Could not find implementation for %s", new Object[]{interfaceMethod});
                return Optional.empty();
            }
            return ParameterNames.tryGetParameterNames((Executable)implementationMethod);
        }

        @Override
        public Optional<List<String>> getParameterNames(Method method) {
            return Optional.ofNullable(this.parameterNames.get(method));
        }
    }

    public static class ReflectiveParameterNamesProvider
    implements ParameterNamesProvider {
        @Override
        public Optional<List<String>> getParameterNames(Method method) {
            Parameter[] parameters = method.getParameters();
            if (Arrays.stream(parameters).noneMatch(Parameter::isNamePresent)) {
                return Optional.empty();
            }
            return Arrays.stream(parameters).map(Parameter::getName).collect(Collectors.collectingAndThen(ImmutableList.toImmutableList(), Optional::of));
        }
    }

    public static interface ParameterNamesProvider {
        public Optional<List<String>> getParameterNames(Method var1);
    }
}

