/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.matching;

import io.prestosql.matching.Capture;
import java.util.NoSuchElementException;

public class Captures {
    private static final Captures NIL = new Captures(null, null, null);
    private final Capture<?> capture;
    private final Object value;
    private final Captures tail;

    private Captures(Capture<?> capture, Object value, Captures tail) {
        this.capture = capture;
        this.value = value;
        this.tail = tail;
    }

    public static Captures empty() {
        return NIL;
    }

    public static <T> Captures ofNullable(Capture<T> capture, T value) {
        return capture == null ? Captures.empty() : new Captures(capture, value, NIL);
    }

    public Captures addAll(Captures other) {
        if (this == NIL) {
            return other;
        }
        return new Captures(this.capture, this.value, this.tail.addAll(other));
    }

    public <T> T get(Capture<T> capture) {
        if (this.equals(NIL)) {
            throw new NoSuchElementException("Requested value for unknown Capture. Was it registered in the Pattern?");
        }
        if (this.capture.equals(capture)) {
            return (T)this.value;
        }
        return this.tail.get(capture);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Captures captures = (Captures)o;
        if (this.capture != null ? !this.capture.equals(captures.capture) : captures.capture != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(captures.value) : captures.value != null) {
            return false;
        }
        return this.tail != null ? this.tail.equals(captures.tail) : captures.tail == null;
    }

    public int hashCode() {
        int result = this.capture != null ? this.capture.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.tail != null ? this.tail.hashCode() : 0);
        return result;
    }
}

