/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.matching.pattern;

import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Match;
import io.prestosql.matching.Pattern;
import io.prestosql.matching.PatternVisitor;
import java.util.Objects;
import java.util.stream.Stream;

public class CapturePattern<T>
extends Pattern<T> {
    private final Capture<T> capture;

    public CapturePattern(Capture<T> capture, Pattern<T> previous) {
        super(previous);
        this.capture = Objects.requireNonNull(capture, "capture is null");
    }

    public Capture<T> capture() {
        return this.capture;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        Captures newCaptures = captures.addAll(Captures.ofNullable(this.capture, object));
        return Stream.of(Match.of(newCaptures));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitCapture(this);
    }
}

