/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TableView;
import org.apache.pulsar.client.api.TableViewBuilder;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TableViewConfigurationData;
import org.apache.pulsar.client.impl.TableViewImpl;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;

public class TableViewBuilderImpl<T>
implements TableViewBuilder<T> {
    private final PulsarClientImpl client;
    private final Schema<T> schema;
    private TableViewConfigurationData conf;

    TableViewBuilderImpl(PulsarClientImpl client, Schema<T> schema) {
        this.client = client;
        this.schema = schema;
        this.conf = new TableViewConfigurationData();
    }

    public TableViewBuilder<T> loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, TableViewConfigurationData.class);
        return this;
    }

    public TableView<T> create() throws PulsarClientException {
        try {
            return this.createAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<TableView<T>> createAsync() {
        return new TableViewImpl<T>(this.client, this.schema, this.conf).start();
    }

    public TableViewBuilder<T> topic(String topic) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic cannot be blank");
        this.conf.setTopicName(StringUtils.trim((String)topic));
        return this;
    }

    public TableViewBuilder<T> autoUpdatePartitionsInterval(int interval, TimeUnit unit) {
        Preconditions.checkArgument((unit.toSeconds(interval) >= 1L ? 1 : 0) != 0, (Object)"minimum is 1 second");
        this.conf.setAutoUpdatePartitionsSeconds(unit.toSeconds(interval));
        return this;
    }
}

