/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.collect.ImmutableList;
import io.prestosql.cli.AlignedTablePrinter;
import io.prestosql.cli.OutputPrinter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CsvPrinter
implements OutputPrinter {
    private final List<String> fieldNames;
    private final CSVWriter writer;
    private boolean needHeader;

    public CsvPrinter(List<String> fieldNames, Writer writer, CsvOutputFormat csvOutputFormat) {
        Objects.requireNonNull(fieldNames, "fieldNames is null");
        Objects.requireNonNull(writer, "writer is null");
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.writer = csvOutputFormat.isQuoted() ? new CSVWriter(writer) : new CSVWriter(writer, ',', '\u0000');
        this.needHeader = csvOutputFormat.showHeader();
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        if (this.needHeader) {
            this.needHeader = false;
            this.writer.writeNext(CsvPrinter.toStrings(this.fieldNames));
        }
        for (List<?> row : rows) {
            this.writer.writeNext(CsvPrinter.toStrings(row));
            this.checkError();
        }
    }

    @Override
    public void finish() throws IOException {
        this.printRows((List<List<?>>)ImmutableList.of(), true);
        this.writer.flush();
        this.checkError();
    }

    private void checkError() throws IOException {
        if (this.writer.checkError()) {
            throw new IOException("error writing to output");
        }
    }

    private static String[] toStrings(List<?> values) {
        String[] array = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            array[i] = CsvPrinter.formatValue(values.get(i));
        }
        return array;
    }

    static String formatValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Map) {
            return AlignedTablePrinter.formatMap((Map)o);
        }
        if (o instanceof List) {
            return AlignedTablePrinter.formatList((List)o);
        }
        if (o instanceof byte[]) {
            return AlignedTablePrinter.formatHexDump((byte[])o);
        }
        return o.toString();
    }

    public static enum CsvOutputFormat {
        STANDARD(true, true),
        NO_HEADER(false, true),
        NO_QUOTES(true, false),
        NO_HEADER_AND_QUOTES(false, false);

        private boolean header;
        private boolean quote;

        private CsvOutputFormat(boolean header, boolean quote) {
            this.header = header;
            this.quote = quote;
        }

        public boolean showHeader() {
            return this.header;
        }

        public boolean isQuoted() {
            return this.quote;
        }
    }
}

