/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.resolver.internal;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferResource;

public class ConsoleTransferListener
extends AbstractTransferListener {
    private final Logger logger;

    public ConsoleTransferListener() {
        this(LoggerFactory.getLogger(ConsoleTransferListener.class));
    }

    public ConsoleTransferListener(Logger logger) {
        this.logger = logger;
    }

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        this.logger.debug(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
    }

    public void transferProgressed(TransferEvent event) {
    }

    public void transferSucceeded(TransferEvent event) {
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.logger.debug(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
        }
    }

    public void transferFailed(TransferEvent event) {
        this.logger.debug("transfer failed", (Throwable)event.getException());
    }

    public void transferCorrupted(TransferEvent event) {
        this.logger.debug("transfer corrupted", (Throwable)event.getException());
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

