/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import org.apache.pulsar.client.admin.Bookies;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.policies.data.BookiesClusterInfo;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;

public class BookiesImpl
extends BaseResource
implements Bookies {
    private final WebTarget adminBookies;

    public BookiesImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBookies = web.path("/admin/v2/bookies");
    }

    public BookiesRackConfiguration getBookiesRackInfo() throws PulsarAdminException {
        return (BookiesRackConfiguration)this.sync(() -> this.getBookiesRackInfoAsync());
    }

    public CompletableFuture<BookiesClusterInfo> getBookiesAsync() {
        WebTarget path = this.adminBookies.path("all");
        final CompletableFuture<BookiesClusterInfo> future = new CompletableFuture<BookiesClusterInfo>();
        this.asyncGetRequest(path, new InvocationCallback<BookiesClusterInfo>(){

            public void completed(BookiesClusterInfo bookies) {
                future.complete(bookies);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BookiesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public BookiesClusterInfo getBookies() throws PulsarAdminException {
        return (BookiesClusterInfo)this.sync(() -> this.getBookiesAsync());
    }

    public CompletableFuture<BookiesRackConfiguration> getBookiesRackInfoAsync() {
        WebTarget path = this.adminBookies.path("racks-info");
        final CompletableFuture<BookiesRackConfiguration> future = new CompletableFuture<BookiesRackConfiguration>();
        this.asyncGetRequest(path, new InvocationCallback<BookiesRackConfiguration>(){

            public void completed(BookiesRackConfiguration bookiesRackConfiguration) {
                future.complete(bookiesRackConfiguration);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BookiesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public BookieInfo getBookieRackInfo(String bookieAddress) throws PulsarAdminException {
        return (BookieInfo)this.sync(() -> this.getBookieRackInfoAsync(bookieAddress));
    }

    public CompletableFuture<BookieInfo> getBookieRackInfoAsync(String bookieAddress) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress);
        final CompletableFuture<BookieInfo> future = new CompletableFuture<BookieInfo>();
        this.asyncGetRequest(path, new InvocationCallback<BookieInfo>(){

            public void completed(BookieInfo bookieInfo) {
                future.complete(bookieInfo);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BookiesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void deleteBookieRackInfo(String bookieAddress) throws PulsarAdminException {
        this.sync(() -> this.deleteBookieRackInfoAsync(bookieAddress));
    }

    public CompletableFuture<Void> deleteBookieRackInfoAsync(String bookieAddress) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress);
        return this.asyncDeleteRequest(path);
    }

    public void updateBookieRackInfo(String bookieAddress, String group, BookieInfo bookieInfo) throws PulsarAdminException {
        this.sync(() -> this.updateBookieRackInfoAsync(bookieAddress, group, bookieInfo));
    }

    public CompletableFuture<Void> updateBookieRackInfoAsync(String bookieAddress, String group, BookieInfo bookieInfo) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress).queryParam("group", new Object[]{group});
        return this.asyncPostRequest(path, Entity.entity((Object)bookieInfo, (String)"application/json"));
    }
}

