/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.csv;

import au.com.bytecode.opencsv.CSVParser;
import com.google.common.collect.ImmutableMap;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.decoder.csv.CsvColumnDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class CsvRowDecoder
implements RowDecoder {
    public static final String NAME = "csv";
    private final Map<DecoderColumnHandle, CsvColumnDecoder> columnDecoders;
    private final CSVParser parser = new CSVParser();

    public CsvRowDecoder(Set<DecoderColumnHandle> columnHandles) {
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.columnDecoders = (Map)columnHandles.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this::createColumnDecoder));
    }

    private CsvColumnDecoder createColumnDecoder(DecoderColumnHandle columnHandle) {
        return new CsvColumnDecoder(columnHandle);
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data, Map<String, String> dataMap) {
        String[] tokens;
        try {
            String line = new String(data, StandardCharsets.UTF_8);
            tokens = this.parser.parseLine(line);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.of(this.columnDecoders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((CsvColumnDecoder)entry.getValue()).decodeField(tokens))));
    }
}

