/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.CostCalculatorWithEstimatedExchanges;
import io.prestosql.cost.CostProvider;
import io.prestosql.cost.LocalCostEstimate;
import io.prestosql.cost.PlanCostEstimate;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsProvider;
import io.prestosql.cost.TaskCountEstimator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.GroupReference;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.AssignUniqueId;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class CostCalculatorUsingExchanges
implements CostCalculator {
    private final TaskCountEstimator taskCountEstimator;

    @Inject
    public CostCalculatorUsingExchanges(TaskCountEstimator taskCountEstimator) {
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public PlanCostEstimate calculateCost(PlanNode node, StatsProvider stats, CostProvider sourcesCosts, Session session, TypeProvider types) {
        CostEstimator costEstimator = new CostEstimator(stats, sourcesCosts, types, this.taskCountEstimator);
        return node.accept(costEstimator, null);
    }

    private static PlanCostEstimate addParallelSiblingsCost(PlanCostEstimate a, PlanCostEstimate b) {
        return new PlanCostEstimate(a.getCpuCost() + b.getCpuCost(), a.getMaxMemory() + b.getMaxMemory(), a.getMaxMemoryWhenOutputting() + b.getMaxMemoryWhenOutputting(), a.getNetworkCost() + b.getNetworkCost());
    }

    private static class CostEstimator
    extends PlanVisitor<PlanCostEstimate, Void> {
        private final StatsProvider stats;
        private final CostProvider sourcesCosts;
        private final TypeProvider types;
        private final TaskCountEstimator taskCountEstimator;

        CostEstimator(StatsProvider stats, CostProvider sourcesCosts, TypeProvider types, TaskCountEstimator taskCountEstimator) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
            this.sourcesCosts = Objects.requireNonNull(sourcesCosts, "sourcesCosts is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
        }

        @Override
        protected PlanCostEstimate visitPlan(PlanNode node, Void context) {
            return PlanCostEstimate.unknown();
        }

        @Override
        public PlanCostEstimate visitGroupReference(GroupReference node, Void context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PlanCostEstimate visitAssignUniqueId(AssignUniqueId node, Void context) {
            LocalCostEstimate localCost = LocalCostEstimate.ofCpu(this.getStats(node).getOutputSizeInBytes((Collection<Symbol>)ImmutableList.of((Object)node.getIdColumn()), this.types));
            return this.costForStreaming(node, localCost);
        }

        @Override
        public PlanCostEstimate visitRowNumber(RowNumberNode node, Void context) {
            ImmutableList symbols = node.getOutputSymbols();
            if (!node.getMaxRowCountPerPartition().isPresent()) {
                symbols = ImmutableList.builder().addAll(node.getPartitionBy()).add((Object)node.getRowNumberSymbol()).build();
            }
            PlanNodeStatsEstimate stats = this.getStats(node);
            double cpuCost = stats.getOutputSizeInBytes((Collection<Symbol>)symbols, this.types);
            double memoryCost = node.getPartitionBy().isEmpty() ? 0.0 : stats.getOutputSizeInBytes(node.getSource().getOutputSymbols(), this.types);
            LocalCostEstimate localCost = LocalCostEstimate.of(cpuCost, memoryCost, 0.0);
            return this.costForStreaming(node, localCost);
        }

        @Override
        public PlanCostEstimate visitOutput(OutputNode node, Void context) {
            return this.costForStreaming(node, LocalCostEstimate.zero());
        }

        @Override
        public PlanCostEstimate visitTableScan(TableScanNode node, Void context) {
            LocalCostEstimate localCost = LocalCostEstimate.ofCpu(this.getStats(node).getOutputSizeInBytes(node.getOutputSymbols(), this.types));
            return this.costForSource(node, localCost);
        }

        @Override
        public PlanCostEstimate visitFilter(FilterNode node, Void context) {
            LocalCostEstimate localCost = LocalCostEstimate.ofCpu(this.getStats(node.getSource()).getOutputSizeInBytes(node.getOutputSymbols(), this.types));
            return this.costForStreaming(node, localCost);
        }

        @Override
        public PlanCostEstimate visitProject(ProjectNode node, Void context) {
            LocalCostEstimate localCost = LocalCostEstimate.ofCpu(this.getStats(node).getOutputSizeInBytes(node.getOutputSymbols(), this.types));
            return this.costForStreaming(node, localCost);
        }

        @Override
        public PlanCostEstimate visitAggregation(AggregationNode node, Void context) {
            if (node.getStep() != AggregationNode.Step.FINAL && node.getStep() != AggregationNode.Step.SINGLE) {
                return PlanCostEstimate.unknown();
            }
            PlanNodeStatsEstimate aggregationStats = this.getStats(node);
            PlanNodeStatsEstimate sourceStats = this.getStats(node.getSource());
            double cpuCost = sourceStats.getOutputSizeInBytes(node.getSource().getOutputSymbols(), this.types);
            double memoryCost = aggregationStats.getOutputSizeInBytes(node.getOutputSymbols(), this.types);
            LocalCostEstimate localCost = LocalCostEstimate.of(cpuCost, memoryCost, 0.0);
            return this.costForAccumulation(node, localCost);
        }

        @Override
        public PlanCostEstimate visitJoin(JoinNode node, Void context) {
            LocalCostEstimate localCost = this.calculateJoinCost(node, node.getLeft(), node.getRight(), Objects.equals(node.getDistributionType(), Optional.of(JoinNode.DistributionType.REPLICATED)));
            return this.costForLookupJoin(node, localCost);
        }

        private LocalCostEstimate calculateJoinCost(PlanNode join, PlanNode probe, PlanNode build, boolean replicated) {
            LocalCostEstimate joinInputCost = CostCalculatorWithEstimatedExchanges.calculateJoinInputCost(probe, build, this.stats, this.types, replicated, this.taskCountEstimator.estimateSourceDistributedTaskCount());
            LocalCostEstimate joinOutputCost = this.calculateJoinOutputCost(join);
            return LocalCostEstimate.addPartialComponents(joinInputCost, joinOutputCost, new LocalCostEstimate[0]);
        }

        private LocalCostEstimate calculateJoinOutputCost(PlanNode join) {
            PlanNodeStatsEstimate outputStats = this.getStats(join);
            double joinOutputSize = outputStats.getOutputSizeInBytes(join.getOutputSymbols(), this.types);
            return LocalCostEstimate.ofCpu(joinOutputSize);
        }

        @Override
        public PlanCostEstimate visitExchange(ExchangeNode node, Void context) {
            return this.costForStreaming(node, this.calculateExchangeCost(node));
        }

        private LocalCostEstimate calculateExchangeCost(ExchangeNode node) {
            double inputSizeInBytes = this.getStats(node).getOutputSizeInBytes(node.getOutputSymbols(), this.types);
            switch (node.getScope()) {
                case LOCAL: {
                    switch (node.getType()) {
                        case GATHER: {
                            return LocalCostEstimate.zero();
                        }
                        case REPARTITION: {
                            return CostCalculatorWithEstimatedExchanges.calculateLocalRepartitionCost(inputSizeInBytes);
                        }
                        case REPLICATE: {
                            return LocalCostEstimate.zero();
                        }
                    }
                    throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)node.getType()));
                }
                case REMOTE: {
                    switch (node.getType()) {
                        case GATHER: {
                            return CostCalculatorWithEstimatedExchanges.calculateRemoteGatherCost(inputSizeInBytes);
                        }
                        case REPARTITION: {
                            return CostCalculatorWithEstimatedExchanges.calculateRemoteRepartitionCost(inputSizeInBytes);
                        }
                        case REPLICATE: {
                            return CostCalculatorWithEstimatedExchanges.calculateRemoteReplicateCost(inputSizeInBytes, this.taskCountEstimator.estimateSourceDistributedTaskCount());
                        }
                    }
                    throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)node.getType()));
                }
            }
            throw new IllegalArgumentException("Unexpected scope: " + (Object)((Object)node.getScope()));
        }

        @Override
        public PlanCostEstimate visitSemiJoin(SemiJoinNode node, Void context) {
            LocalCostEstimate localCost = this.calculateJoinCost(node, node.getSource(), node.getFilteringSource(), node.getDistributionType().orElse(SemiJoinNode.DistributionType.PARTITIONED) == SemiJoinNode.DistributionType.REPLICATED);
            return this.costForLookupJoin(node, localCost);
        }

        @Override
        public PlanCostEstimate visitSpatialJoin(SpatialJoinNode node, Void context) {
            LocalCostEstimate localCost = this.calculateJoinCost(node, node.getLeft(), node.getRight(), node.getDistributionType() == SpatialJoinNode.DistributionType.REPLICATED);
            return this.costForLookupJoin(node, localCost);
        }

        @Override
        public PlanCostEstimate visitValues(ValuesNode node, Void context) {
            return this.costForSource(node, LocalCostEstimate.zero());
        }

        @Override
        public PlanCostEstimate visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return this.costForAccumulation(node, LocalCostEstimate.zero());
        }

        @Override
        public PlanCostEstimate visitLimit(LimitNode node, Void context) {
            LocalCostEstimate localCost = LocalCostEstimate.ofCpu(this.getStats(node).getOutputSizeInBytes(node.getOutputSymbols(), this.types));
            return this.costForStreaming(node, localCost);
        }

        @Override
        public PlanCostEstimate visitUnion(UnionNode node, Void context) {
            return this.costForStreaming(node, LocalCostEstimate.zero());
        }

        private PlanCostEstimate costForSource(PlanNode node, LocalCostEstimate localCost) {
            Verify.verify((boolean)node.getSources().isEmpty(), (String)"Unexpected sources for %s: %s", (Object)node, node.getSources());
            return new PlanCostEstimate(localCost.getCpuCost(), localCost.getMaxMemory(), localCost.getMaxMemory(), localCost.getNetworkCost(), localCost);
        }

        private PlanCostEstimate costForAccumulation(PlanNode node, LocalCostEstimate localCost) {
            PlanCostEstimate sourcesCost = this.getSourcesEstimations(node).reduce(PlanCostEstimate.zero(), (x$0, x$1) -> CostCalculatorUsingExchanges.addParallelSiblingsCost(x$0, x$1));
            return new PlanCostEstimate(sourcesCost.getCpuCost() + localCost.getCpuCost(), Math.max(sourcesCost.getMaxMemory(), sourcesCost.getMaxMemoryWhenOutputting() + localCost.getMaxMemory()), localCost.getMaxMemory(), sourcesCost.getNetworkCost() + localCost.getNetworkCost(), localCost);
        }

        private PlanCostEstimate costForStreaming(PlanNode node, LocalCostEstimate localCost) {
            PlanCostEstimate sourcesCost = this.getSourcesEstimations(node).reduce(PlanCostEstimate.zero(), (x$0, x$1) -> CostCalculatorUsingExchanges.addParallelSiblingsCost(x$0, x$1));
            return new PlanCostEstimate(sourcesCost.getCpuCost() + localCost.getCpuCost(), Math.max(sourcesCost.getMaxMemory(), sourcesCost.getMaxMemoryWhenOutputting() + localCost.getMaxMemory()), sourcesCost.getMaxMemoryWhenOutputting() + localCost.getMaxMemory(), sourcesCost.getNetworkCost() + localCost.getNetworkCost(), localCost);
        }

        private PlanCostEstimate costForLookupJoin(PlanNode node, LocalCostEstimate localCost) {
            Verify.verify((node.getSources().size() == 2 ? 1 : 0) != 0, (String)"Unexpected number of sources for %s: %s", (Object)node, node.getSources());
            List sourcesCosts = (List)this.getSourcesEstimations(node).collect(ImmutableList.toImmutableList());
            Verify.verify((sourcesCosts.size() == 2 ? 1 : 0) != 0);
            PlanCostEstimate probeCost = (PlanCostEstimate)sourcesCosts.get(0);
            PlanCostEstimate buildCost = (PlanCostEstimate)sourcesCosts.get(1);
            return new PlanCostEstimate(probeCost.getCpuCost() + buildCost.getCpuCost() + localCost.getCpuCost(), Math.max(probeCost.getMaxMemory() + buildCost.getMaxMemory(), probeCost.getMaxMemory() + buildCost.getMaxMemoryWhenOutputting() + localCost.getMaxMemory()), probeCost.getMaxMemoryWhenOutputting() + localCost.getMaxMemory(), probeCost.getNetworkCost() + buildCost.getNetworkCost() + localCost.getNetworkCost(), localCost);
        }

        private PlanNodeStatsEstimate getStats(PlanNode node) {
            return this.stats.getStats(node);
        }

        private Stream<PlanCostEstimate> getSourcesEstimations(PlanNode node) {
            return node.getSources().stream().map(this.sourcesCosts::getCost);
        }
    }
}

