/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.operator.annotations.ScalarImplementationDependency;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class FunctionImplementationDependency
extends ScalarImplementationDependency {
    private final QualifiedName name;
    private final List<TypeSignature> argumentTypes;

    public FunctionImplementationDependency(QualifiedName name, List<TypeSignature> argumentTypes, Optional<InvocationConvention> invocationConvention) {
        super(invocationConvention);
        this.name = Objects.requireNonNull(name, "name is null");
        this.argumentTypes = Objects.requireNonNull(argumentTypes, "argumentTypes is null");
    }

    @Override
    protected ResolvedFunction getResolvedFunction(BoundVariables boundVariables, Metadata metadata) {
        return metadata.resolveFunction(this.name, TypeSignatureProvider.fromTypeSignatures(SignatureBinder.applyBoundVariables(this.argumentTypes, boundVariables)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionImplementationDependency that = (FunctionImplementationDependency)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.argumentTypes);
    }
}

