/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;

public class RemoveRedundantTopN
implements Rule<TopNNode> {
    private static final Pattern<TopNNode> PATTERN = Patterns.topN();

    @Override
    public Pattern<TopNNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TopNNode node, Captures captures, Rule.Context context) {
        if (node.getCount() == 0L) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of()));
        }
        if (QueryCardinalityUtil.isScalar(node.getSource(), context.getLookup())) {
            return Rule.Result.ofPlanNode(node.getSource());
        }
        if (QueryCardinalityUtil.isAtMost(node.getSource(), context.getLookup(), node.getCount())) {
            return Rule.Result.ofPlanNode(new SortNode(context.getIdAllocator().getNextId(), node.getSource(), node.getOrderingScheme(), false));
        }
        return Rule.Result.empty();
    }
}

