/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.connector.ConstantProperty;
import io.prestosql.spi.connector.LocalProperty;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.optimizations.LocalProperties;
import io.prestosql.sql.tree.Expression;
import io.prestosql.util.MoreLists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

public class ActualProperties {
    private final Global global;
    private final List<LocalProperty<Symbol>> localProperties;
    private final Map<Symbol, NullableValue> constants;

    private ActualProperties(Global global, List<? extends LocalProperty<Symbol>> localProperties, Map<Symbol, NullableValue> constants) {
        Objects.requireNonNull(global, "globalProperties is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        Objects.requireNonNull(constants, "constants is null");
        this.global = global;
        Set localConstants = LocalProperties.extractLeadingConstants(localProperties);
        localProperties = LocalProperties.stripLeadingConstants(localProperties);
        ImmutableSet updatedLocalConstants = ImmutableSet.builder().addAll(localConstants).addAll(constants.keySet()).build();
        List updatedLocalProperties = LocalProperties.normalizeAndPrune(ImmutableList.builder().addAll(updatedLocalConstants.stream().map(ConstantProperty::new).iterator()).addAll(localProperties).build());
        this.localProperties = ImmutableList.copyOf(updatedLocalProperties);
        this.constants = ImmutableMap.copyOf(constants);
    }

    public boolean isCoordinatorOnly() {
        return this.global.isCoordinatorOnly();
    }

    public boolean isSingleNode() {
        return this.global.isSingleNode();
    }

    public boolean isNullsAndAnyReplicated() {
        return this.global.isNullsAndAnyReplicated();
    }

    public boolean isStreamPartitionedOn(Collection<Symbol> columns) {
        return this.isStreamPartitionedOn(columns, false);
    }

    public boolean isStreamPartitionedOn(Collection<Symbol> columns, boolean nullsAndAnyReplicated) {
        return this.global.isStreamPartitionedOn(columns, this.constants.keySet(), nullsAndAnyReplicated);
    }

    public boolean isNodePartitionedOn(Collection<Symbol> columns) {
        return this.isNodePartitionedOn(columns, false);
    }

    public boolean isNodePartitionedOn(Collection<Symbol> columns, boolean nullsAndAnyReplicated) {
        return this.global.isNodePartitionedOn(columns, this.constants.keySet(), nullsAndAnyReplicated);
    }

    public boolean isCompatibleTablePartitioningWith(Partitioning partitioning, boolean nullsAndAnyReplicated, Metadata metadata, Session session) {
        return this.global.isCompatibleTablePartitioningWith(partitioning, nullsAndAnyReplicated, metadata, session);
    }

    public boolean isCompatibleTablePartitioningWith(ActualProperties other, Function<Symbol, Set<Symbol>> symbolMappings, Metadata metadata, Session session) {
        return this.global.isCompatibleTablePartitioningWith(other.global, symbolMappings, symbol -> Optional.ofNullable(this.constants.get(symbol)), symbol -> Optional.ofNullable(other.constants.get(symbol)), metadata, session);
    }

    public boolean isEffectivelySingleStream() {
        return this.global.isEffectivelySingleStream(this.constants.keySet());
    }

    public boolean isStreamRepartitionEffective(Collection<Symbol> keys) {
        return this.global.isStreamRepartitionEffective(keys, this.constants.keySet());
    }

    public ActualProperties translate(Function<Symbol, Optional<Symbol>> translator) {
        return ActualProperties.builder().global(this.global.translate(new Partitioning.Translator(translator, symbol -> Optional.ofNullable(this.constants.get(symbol)), expression -> Optional.empty()))).local(LocalProperties.translate(this.localProperties, translator)).constants(this.translateConstants(translator)).build();
    }

    public ActualProperties translate(Function<Symbol, Optional<Symbol>> translator, Function<Expression, Optional<Symbol>> expressionTranslator) {
        return ActualProperties.builder().global(this.global.translate(new Partitioning.Translator(translator, symbol -> Optional.ofNullable(this.constants.get(symbol)), expressionTranslator))).local(LocalProperties.translate(this.localProperties, translator)).constants(this.translateConstants(translator)).build();
    }

    public Optional<Partitioning> getNodePartitioning() {
        return this.global.getNodePartitioning();
    }

    public Map<Symbol, NullableValue> getConstants() {
        return this.constants;
    }

    public List<LocalProperty<Symbol>> getLocalProperties() {
        return this.localProperties;
    }

    public ActualProperties withReplicatedNulls(boolean replicatedNulls) {
        return ActualProperties.builderFrom(this).global(this.global.withReplicatedNulls(replicatedNulls)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(ActualProperties properties) {
        return new Builder(properties.global, properties.localProperties, properties.constants);
    }

    private Map<Symbol, NullableValue> translateConstants(Function<Symbol, Optional<Symbol>> translator) {
        HashMap<Symbol, NullableValue> translatedConstants = new HashMap<Symbol, NullableValue>();
        for (Map.Entry<Symbol, NullableValue> entry : this.constants.entrySet()) {
            Optional<Symbol> translatedKey = translator.apply(entry.getKey());
            if (!translatedKey.isPresent()) continue;
            translatedConstants.put(translatedKey.get(), entry.getValue());
        }
        return translatedConstants;
    }

    public int hashCode() {
        return Objects.hash(this.global, this.localProperties, this.constants.keySet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActualProperties other = (ActualProperties)obj;
        return Objects.equals(this.global, other.global) && Objects.equals(this.localProperties, other.localProperties) && Objects.equals(this.constants.keySet(), other.constants.keySet());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("globalProperties", (Object)this.global).add("localProperties", this.localProperties).add("constants", this.constants).toString();
    }

    @Immutable
    public static final class Global {
        private final Optional<Partitioning> nodePartitioning;
        private final Optional<Partitioning> streamPartitioning;
        private final boolean nullsAndAnyReplicated;

        private Global(Optional<Partitioning> nodePartitioning, Optional<Partitioning> streamPartitioning, boolean nullsAndAnyReplicated) {
            Preconditions.checkArgument((!nodePartitioning.isPresent() || !streamPartitioning.isPresent() || nodePartitioning.get().getColumns().containsAll(streamPartitioning.get().getColumns()) || streamPartitioning.get().getColumns().containsAll(nodePartitioning.get().getColumns()) ? 1 : 0) != 0, (Object)"Global stream partitioning columns should match node partitioning columns");
            this.nodePartitioning = Objects.requireNonNull(nodePartitioning, "nodePartitioning is null");
            this.streamPartitioning = Objects.requireNonNull(streamPartitioning, "streamPartitioning is null");
            this.nullsAndAnyReplicated = nullsAndAnyReplicated;
        }

        public static Global coordinatorSingleStreamPartition() {
            return Global.partitionedOn(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, (List<Symbol>)ImmutableList.of(), Optional.of(ImmutableList.of()));
        }

        public static Global singleStreamPartition() {
            return Global.partitionedOn(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of(), Optional.of(ImmutableList.of()));
        }

        public static Global arbitraryPartition() {
            return new Global(Optional.empty(), Optional.empty(), false);
        }

        public static Global partitionedOn(PartitioningHandle nodePartitioningHandle, List<Symbol> nodePartitioning, Optional<List<Symbol>> streamPartitioning) {
            return new Global(Optional.of(Partitioning.create(nodePartitioningHandle, nodePartitioning)), streamPartitioning.map(columns -> Partitioning.create(SystemPartitioningHandle.SOURCE_DISTRIBUTION, columns)), false);
        }

        public static Global partitionedOn(Partitioning nodePartitioning, Optional<Partitioning> streamPartitioning) {
            return new Global(Optional.of(nodePartitioning), streamPartitioning, false);
        }

        public static Global streamPartitionedOn(List<Symbol> streamPartitioning) {
            return new Global(Optional.empty(), Optional.of(Partitioning.create(SystemPartitioningHandle.SOURCE_DISTRIBUTION, streamPartitioning)), false);
        }

        public Global withReplicatedNulls(boolean replicatedNulls) {
            return new Global(this.nodePartitioning, this.streamPartitioning, replicatedNulls);
        }

        private boolean isNullsAndAnyReplicated() {
            return this.nullsAndAnyReplicated;
        }

        private boolean isSingleNode() {
            if (!this.nodePartitioning.isPresent()) {
                return false;
            }
            return this.nodePartitioning.get().getHandle().isSingleNode();
        }

        private boolean isCoordinatorOnly() {
            if (!this.nodePartitioning.isPresent()) {
                return false;
            }
            return this.nodePartitioning.get().getHandle().isCoordinatorOnly();
        }

        private boolean isNodePartitionedOn(Collection<Symbol> columns, Set<Symbol> constants, boolean nullsAndAnyReplicated) {
            return this.nodePartitioning.isPresent() && this.nodePartitioning.get().isPartitionedOn(columns, constants) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isCompatibleTablePartitioningWith(Partitioning partitioning, boolean nullsAndAnyReplicated, Metadata metadata, Session session) {
            return this.nodePartitioning.isPresent() && this.nodePartitioning.get().isCompatibleWith(partitioning, metadata, session) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isCompatibleTablePartitioningWith(Global other, Function<Symbol, Set<Symbol>> symbolMappings, Function<Symbol, Optional<NullableValue>> leftConstantMapping, Function<Symbol, Optional<NullableValue>> rightConstantMapping, Metadata metadata, Session session) {
            return this.nodePartitioning.isPresent() && other.nodePartitioning.isPresent() && this.nodePartitioning.get().isCompatibleWith(other.nodePartitioning.get(), symbolMappings, leftConstantMapping, rightConstantMapping, metadata, session) && this.nullsAndAnyReplicated == other.nullsAndAnyReplicated;
        }

        private Optional<Partitioning> getNodePartitioning() {
            return this.nodePartitioning;
        }

        private boolean isStreamPartitionedOn(Collection<Symbol> columns, Set<Symbol> constants, boolean nullsAndAnyReplicated) {
            return this.streamPartitioning.isPresent() && this.streamPartitioning.get().isPartitionedOn(columns, constants) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isEffectivelySingleStream(Set<Symbol> constants) {
            return this.streamPartitioning.isPresent() && this.streamPartitioning.get().isEffectivelySinglePartition(constants) && !this.nullsAndAnyReplicated;
        }

        private boolean isStreamRepartitionEffective(Collection<Symbol> keys, Set<Symbol> constants) {
            return (!this.streamPartitioning.isPresent() || this.streamPartitioning.get().isRepartitionEffective(keys, constants)) && !this.nullsAndAnyReplicated;
        }

        private Global translate(Partitioning.Translator translator) {
            return new Global(this.nodePartitioning.flatMap(partitioning -> partitioning.translate(translator)), this.streamPartitioning.flatMap(partitioning -> partitioning.translate(translator)), this.nullsAndAnyReplicated);
        }

        public int hashCode() {
            return Objects.hash(this.nodePartitioning, this.streamPartitioning, this.nullsAndAnyReplicated);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.nodePartitioning, other.nodePartitioning) && Objects.equals(this.streamPartitioning, other.streamPartitioning) && this.nullsAndAnyReplicated == other.nullsAndAnyReplicated;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nodePartitioning", this.nodePartitioning).add("streamPartitioning", this.streamPartitioning).add("nullsAndAnyReplicated", this.nullsAndAnyReplicated).toString();
        }
    }

    public static class Builder {
        private Global global;
        private List<LocalProperty<Symbol>> localProperties;
        private Map<Symbol, NullableValue> constants;
        private boolean unordered;

        public Builder() {
            this(Global.arbitraryPartition(), (List<LocalProperty<Symbol>>)ImmutableList.of(), (Map<Symbol, NullableValue>)ImmutableMap.of());
        }

        public Builder(Global global, List<LocalProperty<Symbol>> localProperties, Map<Symbol, NullableValue> constants) {
            this.global = Objects.requireNonNull(global, "global is null");
            this.localProperties = ImmutableList.copyOf(localProperties);
            this.constants = ImmutableMap.copyOf(constants);
        }

        public Builder global(Global global) {
            this.global = global;
            return this;
        }

        public Builder global(ActualProperties other) {
            this.global = other.global;
            return this;
        }

        public Builder local(List<? extends LocalProperty<Symbol>> localProperties) {
            this.localProperties = ImmutableList.copyOf(localProperties);
            return this;
        }

        public Builder constants(Map<Symbol, NullableValue> constants) {
            this.constants = ImmutableMap.copyOf(constants);
            return this;
        }

        public Builder unordered(boolean unordered) {
            this.unordered = unordered;
            return this;
        }

        public ActualProperties build() {
            List<LocalProperty<Symbol>> localProperties = this.localProperties;
            if (this.unordered) {
                localProperties = MoreLists.filteredCopy(this.localProperties, property -> !property.isOrderSensitive());
            }
            return new ActualProperties(this.global, localProperties, this.constants);
        }
    }
}

