/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.TableWriterNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DeleteNode
extends PlanNode {
    private final PlanNode source;
    private final TableWriterNode.DeleteTarget target;
    private final Symbol rowId;
    private final List<Symbol> outputs;

    @JsonCreator
    public DeleteNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") TableWriterNode.DeleteTarget target, @JsonProperty(value="rowId") Symbol rowId, @JsonProperty(value="outputs") List<Symbol> outputs) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowId = Objects.requireNonNull(rowId, "rowId is null");
        this.outputs = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableWriterNode.DeleteTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getRowId() {
        return this.rowId;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDelete(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new DeleteNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowId, this.outputs);
    }
}

