/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.tree.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnnestNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> replicateSymbols;
    private final Map<Symbol, List<Symbol>> unnestSymbols;
    private final Optional<Symbol> ordinalitySymbol;
    private final JoinNode.Type joinType;
    private final Optional<Expression> filter;

    @JsonCreator
    public UnnestNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="replicateSymbols") List<Symbol> replicateSymbols, @JsonProperty(value="unnestSymbols") Map<Symbol, List<Symbol>> unnestSymbols, @JsonProperty(value="ordinalitySymbol") Optional<Symbol> ordinalitySymbol, @JsonProperty(value="joinType") JoinNode.Type joinType, @JsonProperty(value="filter") Optional<Expression> filter) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.replicateSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateSymbols, "replicateSymbols is null"));
        Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(replicateSymbols), (Object)"Source does not contain all replicateSymbols");
        Objects.requireNonNull(unnestSymbols, "unnestSymbols is null");
        Preconditions.checkArgument((!unnestSymbols.isEmpty() ? 1 : 0) != 0, (Object)"unnestSymbols is empty");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Symbol, List<Symbol>> entry : unnestSymbols.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableList.copyOf((Collection)entry.getValue()));
        }
        this.unnestSymbols = builder.build();
        this.ordinalitySymbol = Objects.requireNonNull(ordinalitySymbol, "ordinalitySymbol is null");
        this.joinType = Objects.requireNonNull(joinType, "type is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder().addAll(this.replicateSymbols).addAll(Iterables.concat(this.unnestSymbols.values()));
        this.ordinalitySymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputSymbolsBuilder).add(arg_0));
        return outputSymbolsBuilder.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getReplicateSymbols() {
        return this.replicateSymbols;
    }

    @JsonProperty
    public Map<Symbol, List<Symbol>> getUnnestSymbols() {
        return this.unnestSymbols;
    }

    @JsonProperty
    public Optional<Symbol> getOrdinalitySymbol() {
        return this.ordinalitySymbol;
    }

    @JsonProperty
    public JoinNode.Type getJoinType() {
        return this.joinType;
    }

    @JsonProperty
    public Optional<Expression> getFilter() {
        return this.filter;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitUnnest(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new UnnestNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.replicateSymbols, this.unnestSymbols, this.ordinalitySymbol, this.joinType, this.filter);
    }
}

