/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.block.MethodHandleUtil;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.ParameterKind;
import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class MapParametricType
implements ParametricType {
    public static final MapParametricType MAP = new MapParametricType();

    public String getName() {
        return "map";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Expected two parameters, got %s", parameters);
        TypeParameter firstParameter = parameters.get(0);
        TypeParameter secondParameter = parameters.get(1);
        Preconditions.checkArgument((firstParameter.getKind() == ParameterKind.TYPE && secondParameter.getKind() == ParameterKind.TYPE ? 1 : 0) != 0, (String)"Expected key and type to be types, got %s", parameters);
        Type keyType = firstParameter.getType();
        Type valueType = secondParameter.getType();
        MethodHandle keyNativeEquals = typeManager.resolveOperator(OperatorType.EQUAL, (List)ImmutableList.of((Object)keyType, (Object)keyType));
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyBlockEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyNativeHashCode = typeManager.resolveOperator(OperatorType.HASH_CODE, (List)ImmutableList.of((Object)keyType));
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        return new MapType(keyType, valueType, keyBlockNativeEquals, keyBlockEquals, keyNativeHashCode, keyBlockHashCode);
    }
}

