/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.pulsar.common.api.proto.LightProtoCodec;

public final class KeyLongValue {
    private String key;
    private int _keyBufferIdx = -1;
    private int _keyBufferLen = -1;
    private static final int _KEY_FIELD_NUMBER = 1;
    private static final int _KEY_TAG = 10;
    private static final int _KEY_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _KEY_MASK = 1;
    private long value;
    private static final int _VALUE_FIELD_NUMBER = 2;
    private static final int _VALUE_TAG = 16;
    private static final int _VALUE_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _VALUE_MASK = 2;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 3;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasKey() {
        return (this._bitField0 & 1) != 0;
    }

    public String getKey() {
        if (!this.hasKey()) {
            throw new IllegalStateException("Field 'key' is not set");
        }
        if (this.key == null) {
            this.key = LightProtoCodec.readString(this._parsedBuffer, this._keyBufferIdx, this._keyBufferLen);
        }
        return this.key;
    }

    public KeyLongValue setKey(String key) {
        this.key = key;
        this._bitField0 |= 1;
        this._keyBufferIdx = -1;
        this._keyBufferLen = LightProtoCodec.computeStringUTF8Size(key);
        this._cachedSize = -1;
        return this;
    }

    public KeyLongValue clearKey() {
        this._bitField0 &= 0xFFFFFFFE;
        this.key = null;
        this._keyBufferIdx = -1;
        this._keyBufferLen = -1;
        return this;
    }

    public boolean hasValue() {
        return (this._bitField0 & 2) != 0;
    }

    public long getValue() {
        if (!this.hasValue()) {
            throw new IllegalStateException("Field 'value' is not set");
        }
        return this.value;
    }

    public KeyLongValue setValue(long value) {
        this.value = value;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public KeyLongValue clearValue() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._keyBufferLen);
        if (this._keyBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.key, this._keyBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._keyBufferIdx, _b, this._keyBufferLen);
        }
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.value);
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _KEY_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._keyBufferLen);
        _size += this._keyBufferLen;
        _size += _VALUE_TAG_SIZE;
        this._cachedSize = _size += LightProtoCodec.computeVarInt64Size(this.value);
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block4: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._keyBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._keyBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._keyBufferLen);
                    continue block4;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.value = LightProtoCodec.readVarInt64(_buffer);
                    continue block4;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 3) != 3) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public KeyLongValue clear() {
        this.key = null;
        this._keyBufferIdx = -1;
        this._keyBufferLen = -1;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public KeyLongValue copyFrom(KeyLongValue _other) {
        this._cachedSize = -1;
        if (_other.hasKey()) {
            this.setKey(_other.getKey());
        }
        if (_other.hasValue()) {
            this.setValue(_other.value);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

