/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ConsolePrinter {
    public static final boolean REAL_TERMINAL = ConsolePrinter.detectRealTerminal();
    private static final String ERASE_SCREEN_FORWARD = "\u001b[0J";
    private static final String ERASE_LINE_ALL = "\u001b[2K";
    private final PrintStream out;
    private int lines;

    public ConsolePrinter(PrintStream out) {
        this.out = Objects.requireNonNull(out, "out is null");
    }

    public void reprintLine(String line) {
        if (this.isRealTerminal()) {
            this.out.print(ERASE_LINE_ALL + line + "\n");
        } else {
            this.out.print('\r' + line);
        }
        this.out.flush();
        ++this.lines;
    }

    public void repositionCursor() {
        if (this.lines > 0) {
            if (this.isRealTerminal()) {
                this.out.print(ConsolePrinter.cursorUp(this.lines));
            } else {
                this.out.print('\r');
            }
            this.out.flush();
            this.lines = 0;
        }
    }

    public void resetScreen() {
        if (this.lines > 0) {
            if (this.isRealTerminal()) {
                this.out.print(ConsolePrinter.cursorUp(this.lines) + ERASE_SCREEN_FORWARD);
            } else {
                this.out.print('\r');
            }
            this.out.flush();
            this.lines = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getWidth() {
        try (Terminal terminal = TerminalBuilder.terminal();){
            int n = terminal.getWidth();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isRealTerminal() {
        return REAL_TERMINAL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean detectRealTerminal() {
        try (Terminal terminal = TerminalBuilder.terminal();){
            boolean bl = !"dumb".equals(terminal.getType()) && !"dumb-color".equals(terminal.getType());
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String cursorUp(int lines) {
        return "\u001b[" + lines + "A";
    }
}

