/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaRoutineName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemSecurityContext;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingSystemAccessControl
implements SystemAccessControl {
    public static SystemAccessControl of(final Supplier<SystemAccessControl> systemAccessControlSupplier) {
        Objects.requireNonNull(systemAccessControlSupplier, "systemAccessControlSupplier is null");
        return new ForwardingSystemAccessControl(){

            @Override
            protected SystemAccessControl delegate() {
                return (SystemAccessControl)systemAccessControlSupplier.get();
            }
        };
    }

    protected abstract SystemAccessControl delegate();

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        this.delegate().checkCanImpersonateUser(context, userName);
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        this.delegate().checkCanSetUser(principal, userName);
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
        this.delegate().checkCanExecuteQuery(context);
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        this.delegate().checkCanViewQueryOwnedBy(context, queryOwner);
    }

    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        return this.delegate().filterViewQueryOwnedBy(context, queryOwners);
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        this.delegate().checkCanKillQueryOwnedBy(context, queryOwner);
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        this.delegate().checkCanSetSystemSessionProperty(context, propertyName);
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        this.delegate().checkCanAccessCatalog(context, catalogName);
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return this.delegate().filterCatalogs(context, catalogs);
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanCreateSchema(context, schema);
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanDropSchema(context, schema);
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        this.delegate().checkCanRenameSchema(context, schema, newSchemaName);
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, PrestoPrincipal principal) {
        this.delegate().checkCanSetSchemaAuthorization(context, schema, principal);
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        this.delegate().checkCanShowSchemas(context, catalogName);
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return this.delegate().filterSchemas(context, catalogName, schemaNames);
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanShowCreateTable(context, table);
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanCreateTable(context, table);
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDropTable(context, table);
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        this.delegate().checkCanRenameTable(context, table, newTable);
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanSetTableComment(context, table);
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanShowTables(context, schema);
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(context, catalogName, tableNames);
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        this.delegate().checkCanShowColumns(context, tableName);
    }

    public List<ColumnMetadata> filterColumns(SystemSecurityContext context, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
        return this.delegate().filterColumns(context, tableName, columns);
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanAddColumn(context, table);
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDropColumn(context, table);
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanRenameColumn(context, table);
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanSelectFromColumns(context, table, columns);
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanInsertIntoTable(context, table);
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDeleteFromTable(context, table);
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.delegate().checkCanCreateView(context, view);
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        this.delegate().checkCanRenameView(context, view, newView);
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.delegate().checkCanDropView(context, view);
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(context, table, columns);
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, PrestoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption);
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantTablePrivilege(context, privilege, table, grantee, grantOption);
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeTablePrivilege(context, privilege, table, revokee, grantOption);
    }

    public void checkCanShowRoles(SystemSecurityContext context, String catalogName) {
        this.delegate().checkCanShowRoles(context, catalogName);
    }

    public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
        this.delegate().checkCanExecuteProcedure(systemSecurityContext, procedure);
    }

    public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
        this.delegate().checkCanExecuteFunction(systemSecurityContext, functionName);
    }

    public Optional<ViewExpression> getRowFilter(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        return this.delegate().getRowFilter(context, tableName);
    }

    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        return this.delegate().getColumnMask(context, tableName, columnName, type);
    }
}

