/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.classloader;

import io.prestosql.plugin.base.classloader.ForClassLoaderSafe;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Objects;
import javax.inject.Inject;

public class ClassLoaderSafeSystemTable
implements SystemTable {
    private final SystemTable delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeSystemTable(@ForClassLoaderSafe SystemTable delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public SystemTable.Distribution getDistribution() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            SystemTable.Distribution distribution = this.delegate.getDistribution();
            return distribution;
        }
    }

    public ConnectorTableMetadata getTableMetadata() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableMetadata connectorTableMetadata = this.delegate.getTableMetadata();
            return connectorTableMetadata;
        }
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordCursor recordCursor = this.delegate.cursor(transactionHandle, session, constraint);
            return recordCursor;
        }
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorPageSource connectorPageSource = this.delegate.pageSource(transactionHandle, session, constraint);
            return connectorPageSource;
        }
    }
}

