/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.DecoderErrorCode;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.json.AbstractDateTimeJsonValueProvider;
import io.prestosql.decoder.json.JsonFieldDecoder;
import io.prestosql.decoder.json.JsonRowDecoderFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import java.util.Set;

public class SecondsSinceEpochJsonFieldDecoder
implements JsonFieldDecoder {
    private static final Set<Type> SUPPORTED_TYPES = ImmutableSet.of((Object)TimeType.TIME, (Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, (Object)TimestampType.TIMESTAMP, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
    private final DecoderColumnHandle columnHandle;

    public SecondsSinceEpochJsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!SUPPORTED_TYPES.contains(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType(columnHandle);
        }
    }

    @Override
    public FieldValueProvider decode(JsonNode value) {
        return new SecondsSinceEpochJsonValueProvider(value, this.columnHandle);
    }

    public static class SecondsSinceEpochJsonValueProvider
    extends AbstractDateTimeJsonValueProvider {
        public SecondsSinceEpochJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        protected long getMillis() {
            try {
                if (this.value.isIntegralNumber() && !this.value.isBigInteger()) {
                    return Math.multiplyExact(this.value.longValue(), 1000);
                }
                if (this.value.isValueNode()) {
                    return Math.multiplyExact(Long.parseLong(this.value.asText()), 1000);
                }
                throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", this.columnHandle.getType(), this.columnHandle.getName()));
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
            }
        }
    }
}

