/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.util;

import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pulsar.sql.presto.util.CacheSizeAllocator;

public class NoStrictCacheSizeAllocator
implements CacheSizeAllocator {
    private final long maxCacheSize;
    private final LongAdder availableCacheSize;
    private final ReentrantLock lock;

    public NoStrictCacheSizeAllocator(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.availableCacheSize = new LongAdder();
        this.availableCacheSize.add(maxCacheSize);
        this.lock = new ReentrantLock();
    }

    @Override
    public long getAvailableCacheSize() {
        if (this.availableCacheSize.longValue() < 0L) {
            return 0L;
        }
        return this.availableCacheSize.longValue();
    }

    @Override
    public void allocate(long size) {
        this.lock.lock();
        try {
            this.availableCacheSize.add(-size);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void release(long size) {
        this.lock.lock();
        try {
            this.availableCacheSize.add(size);
            if (this.availableCacheSize.longValue() > this.maxCacheSize) {
                this.availableCacheSize.reset();
                this.availableCacheSize.add(this.maxCacheSize);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

