/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.BasicStageStats;
import io.prestosql.execution.LocationFactory;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.RemoteTask;
import io.prestosql.execution.RemoteTaskFactory;
import io.prestosql.execution.SqlStageExecution;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.StageState;
import io.prestosql.execution.TaskStatus;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.scheduler.BroadcastOutputBufferManager;
import io.prestosql.execution.scheduler.BucketNodeMap;
import io.prestosql.execution.scheduler.DynamicSplitPlacementPolicy;
import io.prestosql.execution.scheduler.ExecutionPolicy;
import io.prestosql.execution.scheduler.ExecutionSchedule;
import io.prestosql.execution.scheduler.FixedCountScheduler;
import io.prestosql.execution.scheduler.FixedSourcePartitionedScheduler;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.NodeSelector;
import io.prestosql.execution.scheduler.OutputBufferManager;
import io.prestosql.execution.scheduler.PartitionedOutputBufferManager;
import io.prestosql.execution.scheduler.ScaledOutputBufferManager;
import io.prestosql.execution.scheduler.ScaledWriterScheduler;
import io.prestosql.execution.scheduler.ScheduleResult;
import io.prestosql.execution.scheduler.SourcePartitionedScheduler;
import io.prestosql.execution.scheduler.SplitSchedulerStats;
import io.prestosql.execution.scheduler.StageScheduler;
import io.prestosql.failuredetector.FailureDetector;
import io.prestosql.metadata.InternalNode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.split.SplitSource;
import io.prestosql.sql.planner.NodePartitionMap;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.StageExecutionPlan;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.util.Failures;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SqlQueryScheduler {
    private final QueryStateMachine queryStateMachine;
    private final ExecutionPolicy executionPolicy;
    private final Map<StageId, SqlStageExecution> stages;
    private final ExecutorService executor;
    private final StageId rootStageId;
    private final Map<StageId, StageScheduler> stageSchedulers;
    private final Map<StageId, StageLinkage> stageLinkages;
    private final SplitSchedulerStats schedulerStats;
    private final boolean summarizeTaskInfo;
    private final AtomicBoolean started = new AtomicBoolean();

    public static SqlQueryScheduler createSqlQueryScheduler(QueryStateMachine queryStateMachine, LocationFactory locationFactory, StageExecutionPlan plan, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, boolean summarizeTaskInfo, int splitBatchSize, ExecutorService queryExecutor, ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, OutputBuffers rootOutputBuffers, NodeTaskMap nodeTaskMap, ExecutionPolicy executionPolicy, SplitSchedulerStats schedulerStats) {
        SqlQueryScheduler sqlQueryScheduler = new SqlQueryScheduler(queryStateMachine, locationFactory, plan, nodePartitioningManager, nodeScheduler, remoteTaskFactory, session, summarizeTaskInfo, splitBatchSize, queryExecutor, schedulerExecutor, failureDetector, rootOutputBuffers, nodeTaskMap, executionPolicy, schedulerStats);
        sqlQueryScheduler.initialize();
        return sqlQueryScheduler;
    }

    private SqlQueryScheduler(QueryStateMachine queryStateMachine, LocationFactory locationFactory, StageExecutionPlan plan, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, boolean summarizeTaskInfo, int splitBatchSize, ExecutorService queryExecutor, ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, OutputBuffers rootOutputBuffers, NodeTaskMap nodeTaskMap, ExecutionPolicy executionPolicy, SplitSchedulerStats schedulerStats) {
        this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
        this.executionPolicy = Objects.requireNonNull(executionPolicy, "schedulerPolicyFactory is null");
        this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        this.summarizeTaskInfo = summarizeTaskInfo;
        ImmutableMap.Builder stageSchedulers = ImmutableMap.builder();
        ImmutableMap.Builder stageLinkages = ImmutableMap.builder();
        HashMap partitioningCache = new HashMap();
        OutputBuffers.OutputBufferId rootBufferId = (OutputBuffers.OutputBufferId)Iterables.getOnlyElement(rootOutputBuffers.getBuffers().keySet());
        List<SqlStageExecution> stages = this.createStages((fragmentId, tasks, noMoreExchangeLocations) -> SqlQueryScheduler.updateQueryOutputLocations(queryStateMachine, rootBufferId, tasks, noMoreExchangeLocations), new AtomicInteger(), plan.withBucketToPartition(Optional.of(new int[1])), nodeScheduler, remoteTaskFactory, session, splitBatchSize, partitioningHandle -> partitioningCache.computeIfAbsent(partitioningHandle, handle -> nodePartitioningManager.getNodePartitioningMap(session, (PartitioningHandle)handle)), nodePartitioningManager, queryExecutor, schedulerExecutor, failureDetector, nodeTaskMap, (ImmutableMap.Builder<StageId, StageScheduler>)stageSchedulers, (ImmutableMap.Builder<StageId, StageLinkage>)stageLinkages);
        SqlStageExecution rootStage = stages.get(0);
        rootStage.setOutputBuffers(rootOutputBuffers);
        this.rootStageId = rootStage.getStageId();
        this.stages = (Map)stages.stream().collect(ImmutableMap.toImmutableMap(SqlStageExecution::getStageId, Function.identity()));
        this.stageSchedulers = stageSchedulers.build();
        this.stageLinkages = stageLinkages.build();
        this.executor = queryExecutor;
    }

    private void initialize() {
        SqlStageExecution rootStage = this.stages.get(this.rootStageId);
        rootStage.addStateChangeListener(state -> {
            if (state == StageState.FINISHED) {
                this.queryStateMachine.transitionToFinishing();
            } else if (state == StageState.CANCELED) {
                this.queryStateMachine.transitionToCanceled();
            }
        });
        for (SqlStageExecution stage : this.stages.values()) {
            stage.addStateChangeListener(state -> {
                if (this.queryStateMachine.isDone()) {
                    return;
                }
                if (state == StageState.FAILED) {
                    this.queryStateMachine.transitionToFailed(stage.getStageInfo().getFailureCause().toException());
                } else if (state == StageState.ABORTED) {
                    this.queryStateMachine.transitionToFailed(new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query stage was aborted"));
                } else if (this.queryStateMachine.getQueryState() == QueryState.STARTING && stage.hasTasks()) {
                    this.queryStateMachine.transitionToRunning();
                }
            });
        }
        this.queryStateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                this.queryStateMachine.updateQueryInfo(Optional.ofNullable(this.getStageInfo()));
            }
        });
        for (SqlStageExecution stage : this.stages.values()) {
            stage.addFinalStageInfoListener(status -> this.queryStateMachine.updateQueryInfo(Optional.ofNullable(this.getStageInfo())));
        }
    }

    private static void updateQueryOutputLocations(QueryStateMachine queryStateMachine, OutputBuffers.OutputBufferId rootBufferId, Set<RemoteTask> tasks, boolean noMoreExchangeLocations) {
        Set bufferLocations = (Set)tasks.stream().map(task -> task.getTaskStatus().getSelf()).map(location -> HttpUriBuilder.uriBuilderFrom((URI)location).appendPath("results").appendPath(rootBufferId.toString()).build()).collect(ImmutableSet.toImmutableSet());
        queryStateMachine.updateOutputLocations(bufferLocations, noMoreExchangeLocations);
    }

    private List<SqlStageExecution> createStages(ExchangeLocationsConsumer parent, AtomicInteger nextStageId, StageExecutionPlan plan, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, int splitBatchSize, Function<PartitioningHandle, NodePartitionMap> partitioningCache, NodePartitioningManager nodePartitioningManager, ExecutorService queryExecutor, ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, ImmutableMap.Builder<StageId, StageScheduler> stageSchedulers, ImmutableMap.Builder<StageId, StageLinkage> stageLinkages) {
        Optional<Object> bucketToPartition;
        ImmutableList.Builder stages = ImmutableList.builder();
        StageId stageId = new StageId(this.queryStateMachine.getQueryId(), nextStageId.getAndIncrement());
        SqlStageExecution stage = SqlStageExecution.createSqlStageExecution(stageId, plan.getFragment(), plan.getTables(), remoteTaskFactory, session, this.summarizeTaskInfo, nodeTaskMap, queryExecutor, failureDetector, this.schedulerStats);
        stages.add((Object)stage);
        PartitioningHandle partitioningHandle = plan.getFragment().getPartitioning();
        if (partitioningHandle.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(plan.getSplitSources().entrySet());
            PlanNodeId planNodeId = (PlanNodeId)entry.getKey();
            SplitSource splitSource = (SplitSource)entry.getValue();
            Optional<CatalogName> catalogName = Optional.of(splitSource.getCatalogName()).filter(catalog -> !CatalogName.isInternalSystemConnector(catalog));
            NodeSelector nodeSelector = nodeScheduler.createNodeSelector(catalogName);
            DynamicSplitPlacementPolicy placementPolicy = new DynamicSplitPlacementPolicy(nodeSelector, stage::getAllTasks);
            Preconditions.checkArgument((!plan.getFragment().getStageExecutionDescriptor().isStageGroupedExecution() ? 1 : 0) != 0);
            stageSchedulers.put((Object)stageId, (Object)SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler(stage, planNodeId, splitSource, placementPolicy, splitBatchSize));
            bucketToPartition = Optional.of(new int[1]);
        } else if (partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
            bucketToPartition = Optional.of(new int[1]);
        } else {
            Map<PlanNodeId, SplitSource> splitSources = plan.getSplitSources();
            if (!splitSources.isEmpty()) {
                List<InternalNode> stageNodeList;
                BucketNodeMap bucketNodeMap;
                Object connectorPartitionHandles;
                List<PlanNodeId> schedulingOrder = plan.getFragment().getPartitionedSources();
                Optional<CatalogName> catalogName = partitioningHandle.getConnectorId();
                catalogName.orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
                boolean groupedExecutionForStage = plan.getFragment().getStageExecutionDescriptor().isStageGroupedExecution();
                if (groupedExecutionForStage) {
                    connectorPartitionHandles = nodePartitioningManager.listPartitionHandles(session, partitioningHandle);
                    Preconditions.checkState((!ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED).equals(connectorPartitionHandles) ? 1 : 0) != 0);
                } else {
                    connectorPartitionHandles = ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED);
                }
                if (plan.getFragment().getRemoteSourceNodes().stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE)) {
                    boolean dynamicLifespanSchedule = plan.getFragment().getStageExecutionDescriptor().isDynamicLifespanSchedule();
                    bucketNodeMap = nodePartitioningManager.getBucketNodeMap(session, partitioningHandle, dynamicLifespanSchedule);
                    Verify.verify((bucketNodeMap.isDynamic() == dynamicLifespanSchedule ? 1 : 0) != 0);
                    stageNodeList = new ArrayList<InternalNode>(nodeScheduler.createNodeSelector(catalogName).allNodes());
                    Collections.shuffle(stageNodeList);
                    bucketToPartition = Optional.empty();
                } else {
                    Verify.verify((!plan.getFragment().getStageExecutionDescriptor().isDynamicLifespanSchedule() ? 1 : 0) != 0);
                    NodePartitionMap nodePartitionMap = partitioningCache.apply(plan.getFragment().getPartitioning());
                    if (groupedExecutionForStage) {
                        Preconditions.checkState((connectorPartitionHandles.size() == nodePartitionMap.getBucketToPartition().length ? 1 : 0) != 0);
                    }
                    stageNodeList = nodePartitionMap.getPartitionToNode();
                    bucketNodeMap = nodePartitionMap.asBucketNodeMap();
                    bucketToPartition = Optional.of(nodePartitionMap.getBucketToPartition());
                }
                stageSchedulers.put((Object)stageId, (Object)new FixedSourcePartitionedScheduler(stage, splitSources, plan.getFragment().getStageExecutionDescriptor(), schedulingOrder, stageNodeList, bucketNodeMap, splitBatchSize, SystemSessionProperties.getConcurrentLifespansPerNode(session), nodeScheduler.createNodeSelector(catalogName), (List<ConnectorPartitionHandle>)connectorPartitionHandles));
            } else {
                NodePartitionMap nodePartitionMap = partitioningCache.apply(plan.getFragment().getPartitioning());
                List<InternalNode> partitionToNode = nodePartitionMap.getPartitionToNode();
                Failures.checkCondition(!partitionToNode.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
                stageSchedulers.put((Object)stageId, (Object)new FixedCountScheduler(stage, partitionToNode));
                bucketToPartition = Optional.of(nodePartitionMap.getBucketToPartition());
            }
        }
        ImmutableSet.Builder childStagesBuilder = ImmutableSet.builder();
        for (StageExecutionPlan subStagePlan : plan.getSubStages()) {
            List<SqlStageExecution> subTree = this.createStages(stage::addExchangeLocations, nextStageId, subStagePlan.withBucketToPartition(bucketToPartition), nodeScheduler, remoteTaskFactory, session, splitBatchSize, partitioningCache, nodePartitioningManager, queryExecutor, schedulerExecutor, failureDetector, nodeTaskMap, stageSchedulers, stageLinkages);
            stages.addAll(subTree);
            SqlStageExecution childStage = subTree.get(0);
            childStagesBuilder.add((Object)childStage);
        }
        ImmutableSet childStages = childStagesBuilder.build();
        stage.addStateChangeListener(arg_0 -> SqlQueryScheduler.lambda$createStages$12((Set)childStages, arg_0));
        stageLinkages.put((Object)stageId, (Object)new StageLinkage(plan.getFragment().getId(), parent, (Set<SqlStageExecution>)childStages));
        if (partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
            Supplier<Collection<TaskStatus>> sourceTasksProvider = () -> SqlQueryScheduler.lambda$createStages$13((Set)childStages);
            Supplier<Collection<TaskStatus>> writerTasksProvider = () -> stage.getAllTasks().stream().map(RemoteTask::getTaskStatus).collect(Collectors.toList());
            ScaledWriterScheduler scheduler = new ScaledWriterScheduler(stage, sourceTasksProvider, writerTasksProvider, nodeScheduler.createNodeSelector(Optional.empty()), schedulerExecutor, SystemSessionProperties.getWriterMinSize(session));
            SqlQueryScheduler.whenAllStages((Collection<SqlStageExecution>)childStages, StageState::isDone).addListener(scheduler::finish, MoreExecutors.directExecutor());
            stageSchedulers.put((Object)stageId, (Object)scheduler);
        }
        return stages.build();
    }

    public BasicStageStats getBasicStageStats() {
        List stageStats = (List)this.stages.values().stream().map(SqlStageExecution::getBasicStageStats).collect(ImmutableList.toImmutableList());
        return BasicStageStats.aggregateBasicStageStats(stageStats);
    }

    public StageInfo getStageInfo() {
        Map stageInfos = (Map)this.stages.values().stream().map(SqlStageExecution::getStageInfo).collect(ImmutableMap.toImmutableMap(StageInfo::getStageId, Function.identity()));
        return this.buildStageInfo(this.rootStageId, stageInfos);
    }

    private StageInfo buildStageInfo(StageId stageId, Map<StageId, StageInfo> stageInfos) {
        StageInfo parent = stageInfos.get(stageId);
        Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (String)"No stageInfo for %s", (Object)parent);
        List childStages = (List)this.stageLinkages.get(stageId).getChildStageIds().stream().map(childStageId -> this.buildStageInfo((StageId)childStageId, stageInfos)).collect(ImmutableList.toImmutableList());
        if (childStages.isEmpty()) {
            return parent;
        }
        return new StageInfo(parent.getStageId(), parent.getState(), parent.getPlan(), parent.getTypes(), parent.getStageStats(), parent.getTasks(), childStages, parent.getTables(), parent.getFailureCause());
    }

    public long getUserMemoryReservation() {
        return this.stages.values().stream().mapToLong(SqlStageExecution::getUserMemoryReservation).sum();
    }

    public long getTotalMemoryReservation() {
        return this.stages.values().stream().mapToLong(SqlStageExecution::getTotalMemoryReservation).sum();
    }

    public Duration getTotalCpuTime() {
        long millis = this.stages.values().stream().mapToLong(stage -> stage.getTotalCpuTime().toMillis()).sum();
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.executor.submit(this::schedule);
        }
    }

    private void schedule() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            HashSet<StageId> completedStages = new HashSet<StageId>();
            ExecutionSchedule executionSchedule = this.executionPolicy.createExecutionSchedule(this.stages.values());
            while (!executionSchedule.isFinished()) {
                ArrayList blockedStages = new ArrayList();
                block26: for (SqlStageExecution stage : executionSchedule.getStagesToSchedule()) {
                    stage.beginScheduling();
                    ScheduleResult result = this.stageSchedulers.get(stage.getStageId()).schedule();
                    if (result.isFinished()) {
                        stage.schedulingComplete();
                    } else if (!result.getBlocked().isDone()) {
                        blockedStages.add(result.getBlocked());
                    }
                    this.stageLinkages.get(stage.getStageId()).processScheduleResults(stage.getState(), result.getNewTasks());
                    this.schedulerStats.getSplitsScheduledPerIteration().add((long)result.getSplitsScheduled());
                    if (!result.getBlockedReason().isPresent()) continue;
                    switch (result.getBlockedReason().get()) {
                        case WRITER_SCALING: {
                            continue block26;
                        }
                        case WAITING_FOR_SOURCE: {
                            this.schedulerStats.getWaitingForSource().update(1L);
                            continue block26;
                        }
                        case SPLIT_QUEUES_FULL: {
                            this.schedulerStats.getSplitQueuesFull().update(1L);
                            continue block26;
                        }
                        case MIXED_SPLIT_QUEUES_FULL_AND_WAITING_FOR_SOURCE: 
                        case NO_ACTIVE_DRIVER_GROUP: {
                            continue block26;
                        }
                    }
                    throw new UnsupportedOperationException("Unknown blocked reason: " + (Object)((Object)result.getBlockedReason().get()));
                }
                for (SqlStageExecution stage : this.stages.values()) {
                    if (completedStages.contains(stage.getStageId()) || !stage.getState().isDone()) continue;
                    this.stageLinkages.get(stage.getStageId()).processScheduleResults(stage.getState(), (Set<RemoteTask>)ImmutableSet.of());
                    completedStages.add(stage.getStageId());
                }
                if (blockedStages.isEmpty()) continue;
                try (Object timer = this.schedulerStats.getSleepTime().time();){
                    MoreFutures.tryGetFutureValue((Future)MoreFutures.whenAnyComplete((Iterable)blockedStages), (int)1, (TimeUnit)TimeUnit.SECONDS);
                }
                timer = blockedStages.iterator();
                while (timer.hasNext()) {
                    ListenableFuture blockedStage = (ListenableFuture)timer.next();
                    blockedStage.cancel(true);
                }
            }
            for (SqlStageExecution stage : this.stages.values()) {
                StageState state = stage.getState();
                if (state == StageState.SCHEDULED || state == StageState.RUNNING || state.isDone()) continue;
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Scheduling is complete, but stage %s is in state %s", new Object[]{stage.getStageId(), state}));
            }
        }
        catch (Throwable t) {
            this.queryStateMachine.transitionToFailed(t);
            throw t;
        }
        finally {
            RuntimeException closeError = new RuntimeException();
            for (StageScheduler scheduler : this.stageSchedulers.values()) {
                try {
                    scheduler.close();
                }
                catch (Throwable t) {
                    this.queryStateMachine.transitionToFailed(t);
                    if (closeError == t) continue;
                    closeError.addSuppressed(t);
                }
            }
            if (closeError.getSuppressed().length > 0) {
                throw closeError;
            }
        }
    }

    public void cancelStage(StageId stageId) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            SqlStageExecution sqlStageExecution = this.stages.get(stageId);
            SqlStageExecution stage = Objects.requireNonNull(sqlStageExecution, () -> String.format("Stage '%s' does not exist", stageId));
            stage.cancel();
        }
    }

    public void abort() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            this.stages.values().forEach(SqlStageExecution::abort);
        }
    }

    private static ListenableFuture<?> whenAllStages(Collection<SqlStageExecution> stages, Predicate<StageState> predicate) {
        Preconditions.checkArgument((!stages.isEmpty() ? 1 : 0) != 0, (Object)"stages is empty");
        Set stageIds = Sets.newConcurrentHashSet((Iterable)stages.stream().map(SqlStageExecution::getStageId).collect(Collectors.toSet()));
        SettableFuture future = SettableFuture.create();
        for (SqlStageExecution stage : stages) {
            stage.addStateChangeListener(state -> {
                if (predicate.test((StageState)((Object)state)) && stageIds.remove(stage.getStageId()) && stageIds.isEmpty()) {
                    future.set(null);
                }
            });
        }
        return future;
    }

    private static /* synthetic */ Collection lambda$createStages$13(Set childStages) {
        return childStages.stream().map(SqlStageExecution::getAllTasks).flatMap(Collection::stream).map(RemoteTask::getTaskStatus).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$createStages$12(Set childStages, StageState newState) {
        if (newState.isDone()) {
            childStages.forEach(SqlStageExecution::cancel);
        }
    }

    private static class StageLinkage {
        private final PlanFragmentId currentStageFragmentId;
        private final ExchangeLocationsConsumer parent;
        private final Set<OutputBufferManager> childOutputBufferManagers;
        private final Set<StageId> childStageIds;

        public StageLinkage(PlanFragmentId fragmentId, ExchangeLocationsConsumer parent, Set<SqlStageExecution> children) {
            this.currentStageFragmentId = fragmentId;
            this.parent = parent;
            this.childOutputBufferManagers = (Set)children.stream().map(childStage -> {
                PartitioningHandle partitioningHandle = childStage.getFragment().getPartitioningScheme().getPartitioning().getHandle();
                if (partitioningHandle.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
                    return new BroadcastOutputBufferManager(childStage::setOutputBuffers);
                }
                if (partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
                    return new ScaledOutputBufferManager(childStage::setOutputBuffers);
                }
                int partitionCount = Ints.max((int[])childStage.getFragment().getPartitioningScheme().getBucketToPartition().get()) + 1;
                return new PartitionedOutputBufferManager(partitioningHandle, partitionCount, childStage::setOutputBuffers);
            }).collect(ImmutableSet.toImmutableSet());
            this.childStageIds = (Set)children.stream().map(SqlStageExecution::getStageId).collect(ImmutableSet.toImmutableSet());
        }

        public Set<StageId> getChildStageIds() {
            return this.childStageIds;
        }

        public void processScheduleResults(StageState newState, Set<RemoteTask> newTasks) {
            boolean noMoreTasks = false;
            switch (newState) {
                case PLANNED: 
                case SCHEDULING: {
                    break;
                }
                case SCHEDULING_SPLITS: 
                case SCHEDULED: 
                case RUNNING: 
                case FINISHED: 
                case CANCELED: {
                    noMoreTasks = true;
                }
            }
            this.parent.addExchangeLocations(this.currentStageFragmentId, newTasks, noMoreTasks);
            if (!this.childOutputBufferManagers.isEmpty()) {
                List newOutputBuffers = (List)newTasks.stream().map(task -> new OutputBuffers.OutputBufferId(task.getTaskId().getId())).collect(ImmutableList.toImmutableList());
                for (OutputBufferManager child : this.childOutputBufferManagers) {
                    child.addOutputBuffers(newOutputBuffers, noMoreTasks);
                }
            }
        }
    }

    private static interface ExchangeLocationsConsumer {
        public void addExchangeLocations(PlanFragmentId var1, Set<RemoteTask> var2, boolean var3);
    }
}

