/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.type.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BoundVariables {
    private final Map<String, Type> typeVariables;
    private final Map<String, Long> longVariables;

    @JsonCreator
    public BoundVariables(@JsonProperty(value="typeVariables") Map<String, Type> typeVariables, @JsonProperty(value="longVariables") Map<String, Long> longVariables) {
        Objects.requireNonNull(typeVariables, "typeVariableBindings is null");
        Objects.requireNonNull(longVariables, "longVariableBindings is null");
        this.typeVariables = ImmutableMap.copyOf(typeVariables);
        this.longVariables = ImmutableMap.copyOf(longVariables);
    }

    public Type getTypeVariable(String variableName) {
        return BoundVariables.getValue(this.typeVariables, variableName);
    }

    public boolean containsTypeVariable(String variableName) {
        return BoundVariables.containsValue(this.typeVariables, variableName);
    }

    @JsonProperty
    public Map<String, Type> getTypeVariables() {
        return this.typeVariables;
    }

    public Long getLongVariable(String variableName) {
        return BoundVariables.getValue(this.longVariables, variableName);
    }

    public boolean containsLongVariable(String variableName) {
        return BoundVariables.containsValue(this.longVariables, variableName);
    }

    @JsonProperty
    public Map<String, Long> getLongVariables() {
        return this.longVariables;
    }

    private static <T> T getValue(Map<String, T> map, String variableName) {
        Preconditions.checkState((variableName != null ? 1 : 0) != 0, (Object)"variableName is null");
        T value = map.get(variableName);
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"value for variable '%s' is null", (Object)variableName);
        return value;
    }

    private static boolean containsValue(Map<String, ?> map, String variableName) {
        Preconditions.checkState((variableName != null ? 1 : 0) != 0, (Object)"variableName is null");
        return map.containsKey(variableName);
    }

    private static <T> void setValue(Map<String, T> map, String variableName, T value) {
        Preconditions.checkState((variableName != null ? 1 : 0) != 0, (Object)"variableName is null");
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"value for variable '%s' is null", (Object)variableName);
        map.put(variableName, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundVariables that = (BoundVariables)o;
        return Objects.equals(this.typeVariables, that.typeVariables) && Objects.equals(this.longVariables, that.longVariables);
    }

    public int hashCode() {
        return Objects.hash(this.typeVariables, this.longVariables);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("typeVariables", this.typeVariables).add("longVariables", this.longVariables).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Type> typeVariables = new HashMap<String, Type>();
        private final Map<String, Long> longVariables = new HashMap<String, Long>();

        public Type getTypeVariable(String variableName) {
            return BoundVariables.getValue(this.typeVariables, variableName);
        }

        public Builder setTypeVariable(String variableName, Type variableValue) {
            BoundVariables.setValue(this.typeVariables, variableName, variableValue);
            return this;
        }

        public boolean containsTypeVariable(String variableName) {
            return BoundVariables.containsValue(this.typeVariables, variableName);
        }

        public Map<String, Type> getTypeVariables() {
            return this.typeVariables;
        }

        public Long getLongVariable(String variableName) {
            return BoundVariables.getValue(this.longVariables, variableName);
        }

        public Builder setLongVariable(String variableName, Long variableValue) {
            BoundVariables.setValue(this.longVariables, variableName, variableValue);
            return this;
        }

        public boolean containsLongVariable(String variableName) {
            return BoundVariables.containsValue(this.longVariables, variableName);
        }

        public Map<String, Long> getLongVariables() {
            return this.longVariables;
        }

        public BoundVariables build() {
            return new BoundVariables(this.typeVariables, this.longVariables);
        }
    }
}

