/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.execution.Lifespan;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.metadata.Split;
import io.prestosql.operator.BlockedReason;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperationTimer;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.OperatorInfo;
import io.prestosql.operator.OperatorStats;
import io.prestosql.operator.PageUtils;
import io.prestosql.operator.ProcessorContext;
import io.prestosql.operator.SourceOperator;
import io.prestosql.operator.SourceOperatorFactory;
import io.prestosql.operator.SplitOperatorInfo;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.WorkProcessorOperatorFactory;
import io.prestosql.operator.WorkProcessorSourceOperator;
import io.prestosql.operator.WorkProcessorSourceOperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class WorkProcessorPipelineSourceOperator
implements SourceOperator {
    private static final Logger log = Logger.get(WorkProcessorPipelineSourceOperator.class);
    private static final Duration ZERO_DURATION = new Duration(0.0, TimeUnit.NANOSECONDS);
    private final int stageId;
    private final int pipelineId;
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final WorkProcessor<Page> pages;
    private final OperationTimer timer;
    private final List<WorkProcessorOperatorContext> workProcessorOperatorContexts = new ArrayList<WorkProcessorOperatorContext>();
    private final List<Split> pendingSplits = new ArrayList<Split>();
    private ListenableFuture<?> blockedFuture;
    private WorkProcessorSourceOperator sourceOperator;
    private SettableFuture<?> blockedOnSplits = SettableFuture.create();
    private boolean operatorFinishing;

    public static List<OperatorFactory> convertOperators(int operatorId, List<OperatorFactory> operatorFactories) {
        int operatorIndex;
        if (operatorFactories.isEmpty() || !(operatorFactories.get(0) instanceof WorkProcessorSourceOperatorFactory)) {
            return operatorFactories;
        }
        WorkProcessorSourceOperatorFactory sourceOperatorFactory = (WorkProcessorSourceOperatorFactory)((Object)operatorFactories.get(0));
        ImmutableList.Builder workProcessorOperatorFactoriesBuilder = ImmutableList.builder();
        for (operatorIndex = 1; operatorIndex < operatorFactories.size() && operatorFactories.get(operatorIndex) instanceof WorkProcessorOperatorFactory; ++operatorIndex) {
            workProcessorOperatorFactoriesBuilder.add((Object)((WorkProcessorOperatorFactory)((Object)operatorFactories.get(operatorIndex))));
        }
        ImmutableList workProcessorOperatorFactories = workProcessorOperatorFactoriesBuilder.build();
        if (workProcessorOperatorFactories.isEmpty()) {
            return operatorFactories;
        }
        return ImmutableList.builder().add((Object)new WorkProcessorPipelineSourceOperatorFactory(operatorId, sourceOperatorFactory, (List<WorkProcessorOperatorFactory>)workProcessorOperatorFactories)).addAll(operatorFactories.subList(operatorIndex, operatorFactories.size())).build();
    }

    private WorkProcessorPipelineSourceOperator(int operatorId, DriverContext driverContext, WorkProcessorSourceOperatorFactory sourceOperatorFactory, List<WorkProcessorOperatorFactory> operatorFactories) {
        Objects.requireNonNull(driverContext, "driverContext is null");
        Objects.requireNonNull(sourceOperatorFactory, "sourceOperatorFactory is null");
        Objects.requireNonNull(operatorFactories, "operatorFactories is null");
        this.stageId = driverContext.getTaskId().getStageId().getId();
        this.pipelineId = driverContext.getPipelineContext().getPipelineId();
        this.sourceId = Objects.requireNonNull(sourceOperatorFactory.getSourceId(), "sourceId is null");
        this.operatorContext = driverContext.addOperatorContext(operatorId, this.sourceId, WorkProcessorPipelineSourceOperator.class.getSimpleName());
        this.timer = new OperationTimer(this.operatorContext.getDriverContext().isCpuTimerEnabled(), this.operatorContext.getDriverContext().isCpuTimerEnabled() && this.operatorContext.getDriverContext().isPerOperatorCpuTimerEnabled());
        MemoryTrackingContext sourceOperatorMemoryTrackingContext = this.createMemoryTrackingContext(this.operatorContext, 0);
        sourceOperatorMemoryTrackingContext.initializeLocalMemoryContexts(sourceOperatorFactory.getOperatorType());
        WorkProcessor<Split> splits = WorkProcessor.create(new Splits());
        this.sourceOperator = sourceOperatorFactory.create(this.operatorContext.getSession(), sourceOperatorMemoryTrackingContext, this.operatorContext.getDriverContext().getYieldSignal(), splits);
        this.workProcessorOperatorContexts.add(new WorkProcessorOperatorContext(this.sourceOperator, sourceOperatorFactory.getOperatorId(), sourceOperatorFactory.getPlanNodeId(), sourceOperatorFactory.getOperatorType(), sourceOperatorMemoryTrackingContext));
        WorkProcessor<Page> pages = this.sourceOperator.getOutputPages();
        pages = pages.yielding(() -> this.operatorContext.getDriverContext().getYieldSignal().isSet()).withProcessEntryMonitor(() -> this.workProcessorOperatorEntryMonitor(0)).withProcessStateMonitor(state -> this.workProcessorOperatorStateMonitor((WorkProcessor.ProcessState<Page>)state, 0)).map(page -> this.recordProcessedOutput((Page)page, 0));
        for (int i = 0; i < operatorFactories.size(); ++i) {
            int operatorIndex = i + 1;
            WorkProcessorOperatorFactory operatorFactory = operatorFactories.get(i);
            MemoryTrackingContext operatorMemoryTrackingContext = this.createMemoryTrackingContext(this.operatorContext, operatorIndex);
            operatorMemoryTrackingContext.initializeLocalMemoryContexts(operatorFactory.getOperatorType());
            WorkProcessorOperator operator = operatorFactory.create(new ProcessorContext(this.operatorContext.getSession(), operatorMemoryTrackingContext, this.operatorContext), pages);
            this.workProcessorOperatorContexts.add(new WorkProcessorOperatorContext(operator, operatorFactory.getOperatorId(), operatorFactory.getPlanNodeId(), operatorFactory.getOperatorType(), operatorMemoryTrackingContext));
            pages = operator.getOutputPages();
            pages = pages.yielding(() -> this.operatorContext.getDriverContext().getYieldSignal().isSet()).withProcessEntryMonitor(() -> this.workProcessorOperatorEntryMonitor(operatorIndex)).withProcessStateMonitor(state -> this.workProcessorOperatorStateMonitor((WorkProcessor.ProcessState<Page>)state, operatorIndex));
            pages = pages.map(page -> this.recordProcessedOutput((Page)page, operatorIndex));
        }
        pages = pages.map(Page::getLoadedPage);
        this.pages = pages.finishWhen(() -> this.operatorFinishing);
        this.operatorContext.setNestedOperatorStatsSupplier(this::getNestedOperatorStats);
    }

    private void workProcessorOperatorEntryMonitor(int operatorIndex) {
        if (this.isLastOperator(operatorIndex)) {
            this.timer.resetInterval();
        } else {
            this.timer.recordOperationComplete(this.workProcessorOperatorContexts.get((int)(operatorIndex + 1)).operatorTiming);
        }
    }

    private void workProcessorOperatorStateMonitor(WorkProcessor.ProcessState<Page> state, int operatorIndex) {
        WorkProcessorOperatorContext context = this.workProcessorOperatorContexts.get(operatorIndex);
        this.timer.recordOperationComplete(context.operatorTiming);
        if (operatorIndex == 0) {
            WorkProcessorSourceOperator sourceOperator = (WorkProcessorSourceOperator)context.operator;
            long deltaPhysicalInputDataSize = WorkProcessorPipelineSourceOperator.deltaAndSet(context.physicalInputDataSize, sourceOperator.getPhysicalInputDataSize().toBytes());
            long deltaPhysicalInputPositions = WorkProcessorPipelineSourceOperator.deltaAndSet(context.physicalInputPositions, sourceOperator.getPhysicalInputPositions());
            long deltaInternalNetworkInputDataSize = WorkProcessorPipelineSourceOperator.deltaAndSet(context.internalNetworkInputDataSize, sourceOperator.getInternalNetworkInputDataSize().toBytes());
            long deltaInternalNetworkInputPositions = WorkProcessorPipelineSourceOperator.deltaAndSet(context.internalNetworkInputPositions, sourceOperator.getInternalNetworkPositions());
            long deltaInputDataSize = WorkProcessorPipelineSourceOperator.deltaAndSet(context.inputDataSize, sourceOperator.getInputDataSize().toBytes());
            long deltaInputPositions = WorkProcessorPipelineSourceOperator.deltaAndSet(context.inputPositions, sourceOperator.getInputPositions());
            long deltaReadTimeNanos = WorkProcessorPipelineSourceOperator.deltaAndSet(context.readTimeNanos, sourceOperator.getReadTime().roundTo(TimeUnit.NANOSECONDS));
            long deltaDynamicFilterSplitsProcessed = WorkProcessorPipelineSourceOperator.deltaAndSet(context.dynamicFilterSplitsProcessed, sourceOperator.getDynamicFilterSplitsProcessed());
            this.operatorContext.recordPhysicalInputWithTiming(deltaPhysicalInputDataSize, deltaPhysicalInputPositions, deltaReadTimeNanos);
            this.operatorContext.recordNetworkInput(deltaInternalNetworkInputDataSize, deltaInternalNetworkInputPositions);
            this.operatorContext.recordProcessedInput(deltaInputDataSize, deltaInputPositions);
            this.operatorContext.recordDynamicFilterSplitProcessed(deltaDynamicFilterSplitsProcessed);
        }
        if (state.getType() == WorkProcessor.ProcessState.Type.FINISHED) {
            this.closeOperators(operatorIndex);
        } else if (state.getType() == WorkProcessor.ProcessState.Type.BLOCKED && this.blockedFuture != state.getBlocked()) {
            this.blockedFuture = state.getBlocked();
            long start = System.nanoTime();
            this.blockedFuture.addListener(() -> context.blockedWallNanos.getAndAdd(System.nanoTime() - start), MoreExecutors.directExecutor());
        }
    }

    private static long deltaAndSet(AtomicLong currentValue, long newValue) {
        return newValue - currentValue.getAndSet(newValue);
    }

    private Page recordProcessedOutput(Page page, int operatorIndex) {
        WorkProcessorOperatorContext downstreamOperatorContext;
        WorkProcessorOperatorContext operatorContext = this.workProcessorOperatorContexts.get(operatorIndex);
        operatorContext.outputPositions.getAndAdd(page.getPositionCount());
        if (!this.isLastOperator(operatorIndex)) {
            downstreamOperatorContext = this.workProcessorOperatorContexts.get(operatorIndex + 1);
            downstreamOperatorContext.inputPositions.getAndAdd(page.getPositionCount());
        } else {
            downstreamOperatorContext = null;
        }
        PageUtils.recordMaterializedBytes(page, sizeInBytes -> {
            operatorContext.outputDataSize.getAndAdd(sizeInBytes);
            if (downstreamOperatorContext != null) {
                downstreamOperatorContext.inputDataSize.getAndAdd(sizeInBytes);
            }
        });
        return page;
    }

    private boolean isLastOperator(int operatorIndex) {
        return operatorIndex + 1 == this.workProcessorOperatorContexts.size();
    }

    private MemoryTrackingContext createMemoryTrackingContext(OperatorContext operatorContext, int operatorIndex) {
        return new MemoryTrackingContext((AggregatedMemoryContext)new InternalAggregatedMemoryContext(operatorContext.newAggregateUserMemoryContext(), () -> this.updatePeakMemoryReservations(operatorIndex)), (AggregatedMemoryContext)new InternalAggregatedMemoryContext(operatorContext.newAggregateRevocableMemoryContext(), () -> this.updatePeakMemoryReservations(operatorIndex)), (AggregatedMemoryContext)new InternalAggregatedMemoryContext(operatorContext.newAggregateSystemMemoryContext(), () -> this.updatePeakMemoryReservations(operatorIndex)));
    }

    private void updatePeakMemoryReservations(int operatorIndex) {
        this.workProcessorOperatorContexts.get(operatorIndex).updatePeakMemoryReservations();
    }

    private List<OperatorStats> getNestedOperatorStats() {
        return (List)this.workProcessorOperatorContexts.stream().map(context -> new OperatorStats(this.stageId, this.pipelineId, context.operatorId, context.planNodeId, context.operatorType, 1L, 0L, new Duration((double)context.readTimeNanos.get(), TimeUnit.NANOSECONDS), ZERO_DURATION, DataSize.succinctBytes((long)context.physicalInputDataSize.get()), context.physicalInputPositions.get(), DataSize.succinctBytes((long)context.internalNetworkInputDataSize.get()), context.internalNetworkInputPositions.get(), DataSize.succinctBytes((long)(context.physicalInputDataSize.get() + context.internalNetworkInputDataSize.get())), DataSize.succinctBytes((long)context.inputDataSize.get()), context.inputPositions.get(), context.inputPositions.get() * context.inputPositions.get(), context.operatorTiming.getCalls(), new Duration((double)context.operatorTiming.getWallNanos(), TimeUnit.NANOSECONDS), new Duration((double)context.operatorTiming.getCpuNanos(), TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)context.outputDataSize.get()), context.outputPositions.get(), context.dynamicFilterSplitsProcessed.get(), DataSize.ofBytes((long)0L), new Duration((double)context.blockedWallNanos.get(), TimeUnit.NANOSECONDS), 0L, ZERO_DURATION, ZERO_DURATION, DataSize.succinctBytes((long)context.memoryTrackingContext.getUserMemory()), DataSize.succinctBytes((long)context.memoryTrackingContext.getRevocableMemory()), DataSize.succinctBytes((long)context.memoryTrackingContext.getSystemMemory()), DataSize.succinctBytes((long)context.peakUserMemoryReservation.get()), DataSize.succinctBytes((long)context.peakSystemMemoryReservation.get()), DataSize.succinctBytes((long)context.peakRevocableMemoryReservation.get()), DataSize.succinctBytes((long)context.peakTotalMemoryReservation.get()), DataSize.ofBytes((long)0L), this.operatorContext.isWaitingForMemory().isDone() ? Optional.empty() : Optional.of(BlockedReason.WAITING_FOR_MEMORY), this.getOperatorInfo((WorkProcessorOperatorContext)context))).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private OperatorInfo getOperatorInfo(WorkProcessorOperatorContext context) {
        WorkProcessorOperator operator = context.operator;
        if (operator != null) {
            return operator.getOperatorInfo().orElse(null);
        }
        return context.finalOperatorInfo;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        if (this.sourceOperator == null) {
            return Optional::empty;
        }
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier(() -> new SplitOperatorInfo(splitInfo));
        }
        this.pendingSplits.add(split);
        this.blockedOnSplits.set(null);
        return this.sourceOperator.getUpdatablePageSourceSupplier();
    }

    @Override
    public void noMoreSplits() {
        this.blockedOnSplits.set(null);
        this.sourceOperator = null;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.pages.process()) {
            return null;
        }
        if (this.pages.isFinished()) {
            return null;
        }
        return this.pages.getResult();
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishMemoryRevoke() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finish() {
        this.operatorFinishing = true;
        this.noMoreSplits();
        this.closeOperators(this.workProcessorOperatorContexts.size() - 1);
    }

    @Override
    public boolean isFinished() {
        return this.pages.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.pages.isBlocked()) {
            return NOT_BLOCKED;
        }
        return this.pages.getBlockedFuture();
    }

    @Override
    public void close() {
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOperators(int lastOperatorIndex) {
        boolean wasInterrupted = Thread.interrupted();
        Throwable inFlightException = null;
        try {
            for (int i = 0; i <= lastOperatorIndex; ++i) {
                WorkProcessorOperatorContext workProcessorOperatorContext = this.workProcessorOperatorContexts.get(i);
                WorkProcessorOperator operator = workProcessorOperatorContext.operator;
                if (operator == null) continue;
                try {
                    operator.close();
                    continue;
                }
                catch (InterruptedException t) {
                    wasInterrupted = true;
                    continue;
                }
                catch (Throwable t) {
                    inFlightException = WorkProcessorPipelineSourceOperator.handleOperatorCloseError(inFlightException, t, "Error closing WorkProcessor operator %s for task %s", workProcessorOperatorContext.operatorId, this.operatorContext.getDriverContext().getTaskId());
                    continue;
                }
                finally {
                    workProcessorOperatorContext.memoryTrackingContext.close();
                    workProcessorOperatorContext.finalOperatorInfo = operator.getOperatorInfo().orElse(null);
                    workProcessorOperatorContext.operator = null;
                }
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (inFlightException != null) {
            Throwables.throwIfUnchecked(inFlightException);
            throw new RuntimeException(inFlightException);
        }
    }

    private static Throwable handleOperatorCloseError(Throwable inFlightException, Throwable newException, String message, Object ... args) {
        if (newException instanceof Error) {
            if (inFlightException == null) {
                inFlightException = newException;
            } else if (inFlightException != newException) {
                inFlightException.addSuppressed(newException);
            }
        } else {
            log.error(newException, message, args);
        }
        return inFlightException;
    }

    public static class WorkProcessorPipelineSourceOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final WorkProcessorSourceOperatorFactory sourceOperatorFactory;
        private final List<WorkProcessorOperatorFactory> operatorFactories;
        private boolean closed;

        private WorkProcessorPipelineSourceOperatorFactory(int operatorId, WorkProcessorSourceOperatorFactory sourceOperatorFactory, List<WorkProcessorOperatorFactory> operatorFactories) {
            this.operatorId = operatorId;
            this.sourceOperatorFactory = Objects.requireNonNull(sourceOperatorFactory, "sourceOperatorFactory is null");
            this.operatorFactories = Objects.requireNonNull(operatorFactories, "operatorFactories is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceOperatorFactory.getSourceId();
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new WorkProcessorPipelineSourceOperator(this.operatorId, driverContext, this.sourceOperatorFactory, this.operatorFactories);
        }

        @Override
        public void noMoreOperators() {
            this.operatorFactories.forEach(WorkProcessorOperatorFactory::close);
            this.closed = true;
        }

        @Override
        public void noMoreOperators(Lifespan lifespan) {
            this.operatorFactories.forEach(operatorFactory -> operatorFactory.lifespanFinished(lifespan));
        }
    }

    private static class WorkProcessorOperatorContext {
        final int operatorId;
        final PlanNodeId planNodeId;
        final String operatorType;
        final MemoryTrackingContext memoryTrackingContext;
        final OperationTimer.OperationTiming operatorTiming = new OperationTimer.OperationTiming();
        final AtomicLong blockedWallNanos = new AtomicLong();
        final AtomicLong physicalInputDataSize = new AtomicLong();
        final AtomicLong physicalInputPositions = new AtomicLong();
        final AtomicLong internalNetworkInputDataSize = new AtomicLong();
        final AtomicLong internalNetworkInputPositions = new AtomicLong();
        final AtomicLong inputDataSize = new AtomicLong();
        final AtomicLong inputPositions = new AtomicLong();
        final AtomicLong readTimeNanos = new AtomicLong();
        final AtomicLong outputDataSize = new AtomicLong();
        final AtomicLong outputPositions = new AtomicLong();
        final AtomicLong dynamicFilterSplitsProcessed = new AtomicLong();
        final AtomicLong peakUserMemoryReservation = new AtomicLong();
        final AtomicLong peakSystemMemoryReservation = new AtomicLong();
        final AtomicLong peakRevocableMemoryReservation = new AtomicLong();
        final AtomicLong peakTotalMemoryReservation = new AtomicLong();
        @Nullable
        volatile WorkProcessorOperator operator;
        @Nullable
        volatile OperatorInfo finalOperatorInfo;

        private WorkProcessorOperatorContext(WorkProcessorOperator operator, int operatorId, PlanNodeId planNodeId, String operatorType, MemoryTrackingContext memoryTrackingContext) {
            this.operator = operator;
            this.operatorId = operatorId;
            this.planNodeId = planNodeId;
            this.operatorType = operatorType;
            this.memoryTrackingContext = memoryTrackingContext;
        }

        void updatePeakMemoryReservations() {
            long userMemory = this.memoryTrackingContext.getUserMemory();
            long systemMemory = this.memoryTrackingContext.getSystemMemory();
            long revocableMemory = this.memoryTrackingContext.getRevocableMemory();
            long totalMemory = userMemory + systemMemory;
            this.peakUserMemoryReservation.accumulateAndGet(userMemory, Math::max);
            this.peakSystemMemoryReservation.accumulateAndGet(systemMemory, Math::max);
            this.peakRevocableMemoryReservation.accumulateAndGet(revocableMemory, Math::max);
            this.peakTotalMemoryReservation.accumulateAndGet(totalMemory, Math::max);
        }
    }

    private static class InternalAggregatedMemoryContext
    implements AggregatedMemoryContext {
        final AggregatedMemoryContext delegate;
        final Runnable allocationListener;

        InternalAggregatedMemoryContext(AggregatedMemoryContext delegate, Runnable allocationListener) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.allocationListener = Objects.requireNonNull(allocationListener, "allocationListener is null");
        }

        public AggregatedMemoryContext newAggregatedMemoryContext() {
            return new InternalAggregatedMemoryContext(this.delegate.newAggregatedMemoryContext(), this.allocationListener);
        }

        public LocalMemoryContext newLocalMemoryContext(String allocationTag) {
            return new InternalLocalMemoryContext(this.delegate.newLocalMemoryContext(allocationTag), this.allocationListener);
        }

        public long getBytes() {
            return this.delegate.getBytes();
        }

        public void close() {
            this.delegate.close();
        }
    }

    private static class InternalLocalMemoryContext
    implements LocalMemoryContext {
        final LocalMemoryContext delegate;
        final Runnable allocationListener;

        InternalLocalMemoryContext(LocalMemoryContext delegate, Runnable allocationListener) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.allocationListener = Objects.requireNonNull(allocationListener, "allocationListener is null");
        }

        public long getBytes() {
            return this.delegate.getBytes();
        }

        public ListenableFuture<?> setBytes(long bytes) {
            ListenableFuture blocked = this.delegate.setBytes(bytes);
            this.allocationListener.run();
            return blocked;
        }

        public boolean trySetBytes(long bytes) {
            if (this.delegate.trySetBytes(bytes)) {
                this.allocationListener.run();
                return true;
            }
            return false;
        }

        public void close() {
            this.delegate.close();
            this.allocationListener.run();
        }
    }

    private class Splits
    implements WorkProcessor.Process<Split> {
        private Splits() {
        }

        @Override
        public WorkProcessor.ProcessState<Split> process() {
            boolean noMoreSplits;
            boolean bl = noMoreSplits = WorkProcessorPipelineSourceOperator.this.sourceOperator == null;
            if (WorkProcessorPipelineSourceOperator.this.pendingSplits.isEmpty()) {
                if (noMoreSplits) {
                    return WorkProcessor.ProcessState.finished();
                }
                WorkProcessorPipelineSourceOperator.this.blockedOnSplits = SettableFuture.create();
                WorkProcessorPipelineSourceOperator.this.blockedFuture = WorkProcessorPipelineSourceOperator.this.blockedOnSplits;
                return WorkProcessor.ProcessState.blocked(WorkProcessorPipelineSourceOperator.this.blockedOnSplits);
            }
            return WorkProcessor.ProcessState.ofResult(WorkProcessorPipelineSourceOperator.this.pendingSplits.remove(0));
        }
    }
}

