/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.Session;
import io.prestosql.operator.GroupByIdBlock;
import io.prestosql.operator.MarkDistinctHash;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.UpdateMemory;
import io.prestosql.operator.Work;
import io.prestosql.operator.aggregation.Accumulator;
import io.prestosql.operator.aggregation.AccumulatorFactory;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.GroupedAccumulator;
import io.prestosql.operator.aggregation.LambdaProvider;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.function.WindowIndex;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinCompiler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GenericAccumulatorFactory
implements AccumulatorFactory {
    private final List<AggregationMetadata.AccumulatorStateDescriptor> stateDescriptors;
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;
    private final List<LambdaProvider> lambdaProviders;
    private final Optional<Integer> maskChannel;
    private final List<Integer> inputChannels;
    private final List<Type> sourceTypes;
    private final List<Integer> orderByChannels;
    private final List<SortOrder> orderings;
    private final boolean accumulatorHasRemoveInput;
    @Nullable
    private final JoinCompiler joinCompiler;
    @Nullable
    private final Session session;
    private final boolean distinct;
    private final PagesIndex.Factory pagesIndexFactory;

    public GenericAccumulatorFactory(List<AggregationMetadata.AccumulatorStateDescriptor> stateDescriptors, Constructor<? extends Accumulator> accumulatorConstructor, boolean accumulatorHasRemoveInput, Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor, List<LambdaProvider> lambdaProviders, List<Integer> inputChannels, Optional<Integer> maskChannel, List<Type> sourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory, @Nullable JoinCompiler joinCompiler, @Nullable Session session, boolean distinct) {
        this.stateDescriptors = Objects.requireNonNull(stateDescriptors, "stateDescriptors is null");
        this.accumulatorConstructor = Objects.requireNonNull(accumulatorConstructor, "accumulatorConstructor is null");
        this.accumulatorHasRemoveInput = accumulatorHasRemoveInput;
        this.groupedAccumulatorConstructor = Objects.requireNonNull(groupedAccumulatorConstructor, "groupedAccumulatorConstructor is null");
        this.lambdaProviders = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaProviders, "lambdaProviders is null"));
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        this.inputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
        this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
        this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
        this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
        Preconditions.checkArgument((orderByChannels.isEmpty() || !Objects.isNull(pagesIndexFactory) ? 1 : 0) != 0, (Object)"No pagesIndexFactory to process ordering");
        this.pagesIndexFactory = pagesIndexFactory;
        Preconditions.checkArgument((!distinct || !Objects.isNull(session) && !Objects.isNull(joinCompiler) ? 1 : 0) != 0, (Object)"joinCompiler and session needed when distinct is true");
        this.joinCompiler = joinCompiler;
        this.session = session;
        this.distinct = distinct;
    }

    @Override
    public List<Integer> getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public boolean hasRemoveInput() {
        return this.accumulatorHasRemoveInput;
    }

    @Override
    public Accumulator createAccumulator() {
        Accumulator accumulator;
        if (this.distinct) {
            accumulator = this.instantiateAccumulator(this.inputChannels.stream().map(value -> value + 1).collect(Collectors.toList()), Optional.of(0));
            List<Type> argumentTypes = this.inputChannels.stream().map(this.sourceTypes::get).collect(Collectors.toList());
            accumulator = new DistinctingAccumulator(accumulator, argumentTypes, this.inputChannels, this.maskChannel, this.session, this.joinCompiler);
        } else {
            accumulator = this.instantiateAccumulator(this.inputChannels, this.maskChannel);
        }
        if (this.orderByChannels.isEmpty()) {
            return accumulator;
        }
        return new OrderingAccumulator(accumulator, this.sourceTypes, this.orderByChannels, this.orderings, this.pagesIndexFactory);
    }

    @Override
    public Accumulator createIntermediateAccumulator() {
        try {
            return this.accumulatorConstructor.newInstance(this.stateDescriptors, ImmutableList.of(), Optional.empty(), this.lambdaProviders);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator() {
        GroupedAccumulator accumulator;
        if (this.distinct) {
            accumulator = this.instantiateGroupedAccumulator(this.inputChannels.stream().map(value -> value + 1).collect(Collectors.toList()), Optional.of(0));
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            for (int input : this.inputChannels) {
                argumentTypes.add(this.sourceTypes.get(input));
            }
            accumulator = new DistinctingGroupedAccumulator(accumulator, argumentTypes, this.inputChannels, this.maskChannel, this.session, this.joinCompiler);
        } else {
            accumulator = this.instantiateGroupedAccumulator(this.inputChannels, this.maskChannel);
        }
        if (this.orderByChannels.isEmpty()) {
            return accumulator;
        }
        return new OrderingGroupedAccumulator(accumulator, this.sourceTypes, this.orderByChannels, this.orderings, this.pagesIndexFactory);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator() {
        try {
            return this.groupedAccumulatorConstructor.newInstance(this.stateDescriptors, ImmutableList.of(), Optional.empty(), this.lambdaProviders);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasOrderBy() {
        return !this.orderByChannels.isEmpty();
    }

    @Override
    public boolean hasDistinct() {
        return this.distinct;
    }

    private Accumulator instantiateAccumulator(List<Integer> inputs, Optional<Integer> mask) {
        try {
            return this.accumulatorConstructor.newInstance(this.stateDescriptors, inputs, mask, this.lambdaProviders);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private GroupedAccumulator instantiateGroupedAccumulator(List<Integer> inputs, Optional<Integer> mask) {
        try {
            return this.groupedAccumulatorConstructor.newInstance(this.stateDescriptors, inputs, mask, this.lambdaProviders);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Page filter(Page page, Block mask) {
        int[] ids = new int[mask.getPositionCount()];
        int next = 0;
        for (int i = 0; i < page.getPositionCount(); ++i) {
            if (!BooleanType.BOOLEAN.getBoolean(mask, i)) continue;
            ids[next++] = i;
        }
        return page.getPositions(ids, 0, next);
    }

    private static class OrderingGroupedAccumulator
    implements GroupedAccumulator {
        private final GroupedAccumulator accumulator;
        private final List<Integer> orderByChannels;
        private final List<SortOrder> orderings;
        private final PagesIndex pagesIndex;
        private long groupCount;

        private OrderingGroupedAccumulator(GroupedAccumulator accumulator, List<Type> aggregationSourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            Objects.requireNonNull(aggregationSourceTypes, "aggregationSourceTypes is null");
            this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
            ArrayList<Type> pageIndexTypes = new ArrayList<Type>(aggregationSourceTypes);
            pageIndexTypes.add((Type)BigintType.BIGINT);
            this.pagesIndex = pagesIndexFactory.newPagesIndex(pageIndexTypes, 10000);
            this.groupCount = 0L;
        }

        @Override
        public long getEstimatedSize() {
            return this.pagesIndex.getEstimatedSize().toBytes() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        @Override
        public Type getIntermediateType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            Block[] blocks = new Block[page.getChannelCount() + 1];
            for (int i = 0; i < page.getChannelCount(); ++i) {
                blocks[i] = page.getBlock(i);
            }
            blocks[page.getChannelCount()] = groupIdsBlock;
            this.groupCount = Long.max(this.groupCount, groupIdsBlock.getGroupCount());
            this.pagesIndex.addPage(new Page(blocks));
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.accumulator.evaluateFinal(groupId, output);
        }

        @Override
        public void prepareFinal() {
            this.pagesIndex.sort(this.orderByChannels, this.orderings);
            Iterator<Page> pagesIterator = this.pagesIndex.getSortedPages();
            pagesIterator.forEachRemaining(page -> {
                GroupByIdBlock groupIds = new GroupByIdBlock(this.groupCount, page.getBlock(page.getChannelCount() - 1));
                this.accumulator.addInput(groupIds, (Page)page);
            });
        }
    }

    private static class OrderingAccumulator
    implements Accumulator {
        private final Accumulator accumulator;
        private final List<Integer> orderByChannels;
        private final List<SortOrder> orderings;
        private final PagesIndex pagesIndex;

        private OrderingAccumulator(Accumulator accumulator, List<Type> aggregationSourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
            this.pagesIndex = pagesIndexFactory.newPagesIndex(aggregationSourceTypes, 10000);
        }

        @Override
        public long getEstimatedSize() {
            return this.pagesIndex.getEstimatedSize().toBytes() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        @Override
        public Type getIntermediateType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInput(Page page) {
            this.pagesIndex.addPage(page);
        }

        @Override
        public void addInput(WindowIndex index, List<Integer> channels, int startPosition, int endPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeInput(WindowIndex index, List<Integer> channels, int startPosition, int endPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addIntermediate(Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(BlockBuilder blockBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(BlockBuilder blockBuilder) {
            this.pagesIndex.sort(this.orderByChannels, this.orderings);
            Iterator<Page> pagesIterator = this.pagesIndex.getSortedPages();
            pagesIterator.forEachRemaining(this.accumulator::addInput);
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }

    private static class DistinctingGroupedAccumulator
    implements GroupedAccumulator {
        private final GroupedAccumulator accumulator;
        private final MarkDistinctHash hash;
        private final Optional<Integer> maskChannel;

        private DistinctingGroupedAccumulator(GroupedAccumulator accumulator, List<Type> inputTypes, List<Integer> inputChannels, Optional<Integer> maskChannel, Session session, JoinCompiler joinCompiler) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
            ImmutableList types = ImmutableList.builder().add((Object)BigintType.BIGINT).addAll(inputTypes).build();
            int[] inputs = new int[inputChannels.size() + 1];
            inputs[0] = 0;
            for (int i = 0; i < inputChannels.size(); ++i) {
                inputs[i + 1] = inputChannels.get(i) + 1;
            }
            this.hash = new MarkDistinctHash(session, (List<Type>)types, inputs, Optional.empty(), joinCompiler, UpdateMemory.NOOP);
        }

        @Override
        public long getEstimatedSize() {
            return this.hash.getEstimatedSize() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        @Override
        public Type getIntermediateType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            Page withGroup = page.prependColumn((Block)groupIdsBlock);
            Page filtered = this.maskChannel.map(channel -> GenericAccumulatorFactory.filter(withGroup, withGroup.getBlock(channel + 1))).orElse(withGroup);
            Work<Block> work = this.hash.markDistinctRows(filtered);
            Preconditions.checkState((boolean)work.process());
            Block distinctMask = work.getResult();
            GroupByIdBlock groupIds = new GroupByIdBlock(groupIdsBlock.getGroupCount(), filtered.getBlock(0));
            Block[] columns = new Block[filtered.getChannelCount()];
            columns[0] = distinctMask;
            for (int i = 1; i < filtered.getChannelCount(); ++i) {
                columns[i] = filtered.getBlock(i);
            }
            this.accumulator.addInput(groupIds, new Page(filtered.getPositionCount(), columns));
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.accumulator.evaluateFinal(groupId, output);
        }

        @Override
        public void prepareFinal() {
        }
    }

    private static class DistinctingAccumulator
    implements Accumulator {
        private final Accumulator accumulator;
        private final MarkDistinctHash hash;
        private final Optional<Integer> maskChannel;

        private DistinctingAccumulator(Accumulator accumulator, List<Type> inputTypes, List<Integer> inputs, Optional<Integer> maskChannel, Session session, JoinCompiler joinCompiler) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
            this.hash = new MarkDistinctHash(session, inputTypes, Ints.toArray(inputs), Optional.empty(), joinCompiler, UpdateMemory.NOOP);
        }

        @Override
        public long getEstimatedSize() {
            return this.hash.getEstimatedSize() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        @Override
        public Type getIntermediateType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInput(Page page) {
            Page filtered = this.maskChannel.map(channel -> GenericAccumulatorFactory.filter(page, page.getBlock(channel.intValue()))).orElse(page);
            if (filtered.getPositionCount() == 0) {
                return;
            }
            Work<Block> work = this.hash.markDistinctRows(filtered);
            Preconditions.checkState((boolean)work.process());
            Block distinctMask = work.getResult();
            this.accumulator.addInput(filtered.prependColumn(distinctMask));
        }

        @Override
        public void addInput(WindowIndex index, List<Integer> channels, int startPosition, int endPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeInput(WindowIndex index, List<Integer> channels, int startPosition, int endPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addIntermediate(Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(BlockBuilder blockBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(BlockBuilder blockBuilder) {
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }
}

