/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingAccessControl
implements AccessControl {
    public static ForwardingAccessControl of(final Supplier<AccessControl> accessControlSupplier) {
        Objects.requireNonNull(accessControlSupplier, "accessControlSupplier is null");
        return new ForwardingAccessControl(){

            @Override
            protected AccessControl delegate() {
                return Objects.requireNonNull((AccessControl)accessControlSupplier.get(), "accessControlSupplier.get() is null");
            }
        };
    }

    protected abstract AccessControl delegate();

    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        this.delegate().checkCanImpersonateUser(identity, userName);
    }

    @Override
    @Deprecated
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        this.delegate().checkCanSetUser(principal, userName);
    }

    @Override
    public void checkCanExecuteQuery(Identity identity) {
        this.delegate().checkCanExecuteQuery(identity);
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, String queryOwner) {
        this.delegate().checkCanViewQueryOwnedBy(identity, queryOwner);
    }

    @Override
    public Set<String> filterQueriesOwnedBy(Identity identity, Set<String> queryOwners) {
        return this.delegate().filterQueriesOwnedBy(identity, queryOwners);
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, String queryOwner) {
        this.delegate().checkCanKillQueryOwnedBy(identity, queryOwner);
    }

    @Override
    public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        return this.delegate().filterCatalogs(identity, catalogs);
    }

    @Override
    public void checkCanCreateSchema(SecurityContext context, CatalogSchemaName schemaName) {
        this.delegate().checkCanCreateSchema(context, schemaName);
    }

    @Override
    public void checkCanDropSchema(SecurityContext context, CatalogSchemaName schemaName) {
        this.delegate().checkCanDropSchema(context, schemaName);
    }

    @Override
    public void checkCanRenameSchema(SecurityContext context, CatalogSchemaName schemaName, String newSchemaName) {
        this.delegate().checkCanRenameSchema(context, schemaName, newSchemaName);
    }

    @Override
    public void checkCanSetSchemaAuthorization(SecurityContext context, CatalogSchemaName schemaName, PrestoPrincipal principal) {
        this.delegate().checkCanSetSchemaAuthorization(context, schemaName, principal);
    }

    @Override
    public void checkCanShowSchemas(SecurityContext context, String catalogName) {
        this.delegate().checkCanShowSchemas(context, catalogName);
    }

    @Override
    public Set<String> filterSchemas(SecurityContext context, String catalogName, Set<String> schemaNames) {
        return this.delegate().filterSchemas(context, catalogName, schemaNames);
    }

    @Override
    public void checkCanShowCreateSchema(SecurityContext context, CatalogSchemaName schemaName) {
        this.delegate().checkCanShowCreateSchema(context, schemaName);
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanShowCreateTable(context, tableName);
    }

    @Override
    public void checkCanCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanCreateTable(context, tableName);
    }

    @Override
    public void checkCanDropTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanDropTable(context, tableName);
    }

    @Override
    public void checkCanRenameTable(SecurityContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        this.delegate().checkCanRenameTable(context, tableName, newTableName);
    }

    @Override
    public void checkCanSetTableComment(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanSetTableComment(context, tableName);
    }

    @Override
    public void checkCanShowTables(SecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanShowTables(context, schema);
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(context, catalogName, tableNames);
    }

    @Override
    public void checkCanShowColumns(SecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanShowColumns(context, table);
    }

    @Override
    public List<ColumnMetadata> filterColumns(SecurityContext context, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
        return this.delegate().filterColumns(context, tableName, columns);
    }

    @Override
    public void checkCanAddColumns(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanAddColumns(context, tableName);
    }

    @Override
    public void checkCanDropColumn(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanDropColumn(context, tableName);
    }

    @Override
    public void checkCanRenameColumn(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanRenameColumn(context, tableName);
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanInsertIntoTable(context, tableName);
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanDeleteFromTable(context, tableName);
    }

    @Override
    public void checkCanCreateView(SecurityContext context, QualifiedObjectName viewName) {
        this.delegate().checkCanCreateView(context, viewName);
    }

    @Override
    public void checkCanRenameView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        this.delegate().checkCanRenameView(context, viewName, newViewName);
    }

    @Override
    public void checkCanDropView(SecurityContext context, QualifiedObjectName viewName) {
        this.delegate().checkCanDropView(context, viewName);
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames);
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, String functionName, Identity grantee, boolean grantOption) {
        this.delegate().checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption);
    }

    @Override
    public void checkCanGrantTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantTablePrivilege(context, privilege, tableName, grantee, grantOption);
    }

    @Override
    public void checkCanRevokeTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeTablePrivilege(context, privilege, tableName, revokee, grantOption);
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        this.delegate().checkCanSetSystemSessionProperty(identity, propertyName);
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext context, String catalogName, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        this.delegate().checkCanSelectFromColumns(context, tableName, columnNames);
    }

    @Override
    public void checkCanCreateRole(SecurityContext context, String role, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate().checkCanCreateRole(context, role, grantor, catalogName);
    }

    @Override
    public void checkCanDropRole(SecurityContext context, String role, String catalogName) {
        this.delegate().checkCanDropRole(context, role, catalogName);
    }

    @Override
    public void checkCanGrantRoles(SecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate().checkCanGrantRoles(context, roles, grantees, adminOption, grantor, catalogName);
    }

    @Override
    public void checkCanRevokeRoles(SecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate().checkCanRevokeRoles(context, roles, grantees, adminOption, grantor, catalogName);
    }

    @Override
    public void checkCanSetRole(SecurityContext context, String role, String catalogName) {
        this.delegate().checkCanSetRole(context, role, catalogName);
    }

    @Override
    public void checkCanShowRoles(SecurityContext context, String catalogName) {
        this.delegate().checkCanShowRoles(context, catalogName);
    }

    @Override
    public void checkCanShowCurrentRoles(SecurityContext context, String catalogName) {
        this.delegate().checkCanShowCurrentRoles(context, catalogName);
    }

    @Override
    public void checkCanShowRoleGrants(SecurityContext context, String catalogName) {
        this.delegate().checkCanShowRoleGrants(context, catalogName);
    }

    @Override
    public void checkCanExecuteProcedure(SecurityContext context, QualifiedObjectName procedureName) {
        this.delegate().checkCanExecuteProcedure(context, procedureName);
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, String functionName) {
        this.delegate().checkCanExecuteFunction(context, functionName);
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        return this.delegate().getRowFilters(context, tableName);
    }

    @Override
    public List<ViewExpression> getColumnMasks(SecurityContext context, QualifiedObjectName tableName, String columnName, Type type) {
        return this.delegate().getColumnMasks(context, tableName, columnName, type);
    }
}

