/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Modules;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.server.TheServlet;
import io.prestosql.server.security.AuthenticationFilter;
import io.prestosql.server.security.Authenticator;
import io.prestosql.server.security.CertificateAuthenticator;
import io.prestosql.server.security.CertificateAuthenticatorManager;
import io.prestosql.server.security.CertificateConfig;
import io.prestosql.server.security.JsonWebTokenAuthenticator;
import io.prestosql.server.security.JsonWebTokenConfig;
import io.prestosql.server.security.KerberosAuthenticator;
import io.prestosql.server.security.KerberosConfig;
import io.prestosql.server.security.PasswordAuthenticator;
import io.prestosql.server.security.PasswordAuthenticatorConfig;
import io.prestosql.server.security.PasswordAuthenticatorManager;
import io.prestosql.server.security.SecurityConfig;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;

public class ServerSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(AuthenticationFilter.class).in(Scopes.SINGLETON);
        binder.bind(PasswordAuthenticatorManager.class).in(Scopes.SINGLETON);
        binder.bind(CertificateAuthenticatorManager.class).in(Scopes.SINGLETON);
        ServerSecurityModule.authenticatorBinder(binder);
        this.installAuthenticator("certificate", CertificateAuthenticator.class, CertificateConfig.class);
        this.installAuthenticator("kerberos", KerberosAuthenticator.class, KerberosConfig.class);
        this.installAuthenticator("password", PasswordAuthenticator.class, PasswordAuthenticatorConfig.class);
        this.installAuthenticator("jwt", JsonWebTokenAuthenticator.class, JsonWebTokenConfig.class);
    }

    @Provides
    public List<Authenticator> getAuthenticatorList(SecurityConfig config, Map<String, Authenticator> authenticators) {
        return (List)ServerSecurityModule.authenticationTypes(config).stream().map(type -> {
            Authenticator authenticator = (Authenticator)authenticators.get(type);
            if (authenticator == null) {
                throw new RuntimeException("Unknown authenticator type: " + type);
            }
            return authenticator;
        }).collect(ImmutableList.toImmutableList());
    }

    public static Module authenticatorModule(String name, Class<? extends Authenticator> clazz, Module module) {
        Preconditions.checkArgument((boolean)name.toLowerCase(Locale.ENGLISH).equals(name), (String)"name is not lower case: %s", (Object)name);
        Module authModule = binder -> ServerSecurityModule.authenticatorBinder(binder).addBinding((Object)name).to(clazz).in(Scopes.SINGLETON);
        return ConditionalModule.installModuleIf(SecurityConfig.class, config -> ServerSecurityModule.authenticationTypes(config).contains(name), (Module)Modules.combine((Module[])new Module[]{module, authModule}));
    }

    private void installAuthenticator(String name, Class<? extends Authenticator> authenticator, Class<?> config) {
        this.install(ServerSecurityModule.authenticatorModule(name, authenticator, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(config)));
    }

    private static MapBinder<String, Authenticator> authenticatorBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, String.class, Authenticator.class);
    }

    private static List<String> authenticationTypes(SecurityConfig config) {
        return (List)config.getAuthenticationTypes().stream().map(type -> type.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }
}

