/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.scalar.FormatFunction;
import io.prestosql.security.AccessControl;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.PrestoWarning;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.WarningCodeSupplier;
import io.prestosql.spi.connector.StandardWarningCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalParseResult;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeNotFoundException;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import io.prestosql.sql.NodeUtils;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.analyzer.CorrelationSupport;
import io.prestosql.sql.analyzer.ExpressionAnalysis;
import io.prestosql.sql.analyzer.ExpressionTreeUtils;
import io.prestosql.sql.analyzer.Field;
import io.prestosql.sql.analyzer.FieldId;
import io.prestosql.sql.analyzer.RelationId;
import io.prestosql.sql.analyzer.RelationType;
import io.prestosql.sql.analyzer.ResolvedField;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.analyzer.StatementAnalyzer;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.ArrayConstructor;
import io.prestosql.sql.tree.AtTimeZone;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BinaryLiteral;
import io.prestosql.sql.tree.BindExpression;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CharLiteral;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.CurrentPath;
import io.prestosql.sql.tree.CurrentTime;
import io.prestosql.sql.tree.CurrentUser;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Extract;
import io.prestosql.sql.tree.FieldReference;
import io.prestosql.sql.tree.Format;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.GroupingOperation;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IntervalLiteral;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullIfExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.QuantifiedComparisonExpression;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.StackableAstVisitor;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SubqueryExpression;
import io.prestosql.sql.tree.SubscriptExpression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.TimeLiteral;
import io.prestosql.sql.tree.TimestampLiteral;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.sql.tree.WhenClause;
import io.prestosql.sql.tree.Window;
import io.prestosql.sql.tree.WindowFrame;
import io.prestosql.type.ArrayParametricType;
import io.prestosql.type.FunctionType;
import io.prestosql.type.IntervalDayTimeType;
import io.prestosql.type.IntervalYearMonthType;
import io.prestosql.type.JsonType;
import io.prestosql.type.TypeCoercion;
import io.prestosql.type.UnknownType;
import io.prestosql.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExpressionAnalyzer {
    private static final int MAX_NUMBER_GROUPING_ARGUMENTS_BIGINT = 63;
    private static final int MAX_NUMBER_GROUPING_ARGUMENTS_INTEGER = 31;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final Function<Node, StatementAnalyzer> statementAnalyzerFactory;
    private final TypeProvider symbolTypes;
    private final boolean isDescribe;
    private final Map<NodeRef<FunctionCall>, ResolvedFunction> resolvedFunctions = new LinkedHashMap<NodeRef<FunctionCall>, ResolvedFunction>();
    private final Set<NodeRef<SubqueryExpression>> scalarSubqueries = new LinkedHashSet<NodeRef<SubqueryExpression>>();
    private final Set<NodeRef<ExistsPredicate>> existsSubqueries = new LinkedHashSet<NodeRef<ExistsPredicate>>();
    private final Map<NodeRef<Expression>, Type> expressionCoercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<Expression>> typeOnlyCoercions = new LinkedHashSet<NodeRef<Expression>>();
    private final Set<NodeRef<InPredicate>> subqueryInPredicates = new LinkedHashSet<NodeRef<InPredicate>>();
    private final Map<NodeRef<Expression>, FieldId> columnReferences = new LinkedHashMap<NodeRef<Expression>, FieldId>();
    private final Map<NodeRef<Expression>, Type> expressionTypes = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons = new LinkedHashSet<NodeRef<QuantifiedComparisonExpression>>();
    private final Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences = new LinkedHashMap<NodeRef<Identifier>, LambdaArgumentDeclaration>();
    private final Set<NodeRef<FunctionCall>> windowFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Multimap<QualifiedObjectName, String> tableColumnReferences = HashMultimap.create();
    private final Multimap<NodeRef<Node>, Field> referencedFields = HashMultimap.create();
    private final Session session;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private final WarningCollector warningCollector;
    private final TypeCoercion typeCoercion;
    private final CorrelationSupport correlationSupport;

    public ExpressionAnalyzer(Metadata metadata, AccessControl accessControl, Function<Node, StatementAnalyzer> statementAnalyzerFactory, Session session, TypeProvider symbolTypes, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, boolean isDescribe, CorrelationSupport correlationSupport) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.symbolTypes = Objects.requireNonNull(symbolTypes, "symbolTypes is null");
        this.parameters = Objects.requireNonNull(parameters, "parameterMap is null");
        this.isDescribe = isDescribe;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.typeCoercion = new TypeCoercion(metadata::getType);
        this.correlationSupport = Objects.requireNonNull(correlationSupport, "correlation is null");
    }

    public Map<NodeRef<FunctionCall>, ResolvedFunction> getResolvedFunctions() {
        return Collections.unmodifiableMap(this.resolvedFunctions);
    }

    public Map<NodeRef<Expression>, Type> getExpressionTypes() {
        return Collections.unmodifiableMap(this.expressionTypes);
    }

    public Type setExpressionType(Expression expression, Type type) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.expressionTypes.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        return type;
    }

    private Type getExpressionType(Expression expression) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Type type = this.expressionTypes.get(NodeRef.of((Node)expression));
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Expression not yet analyzed: %s", (Object)expression);
        return type;
    }

    public Map<NodeRef<Expression>, Type> getExpressionCoercions() {
        return Collections.unmodifiableMap(this.expressionCoercions);
    }

    public Set<NodeRef<Expression>> getTypeOnlyCoercions() {
        return Collections.unmodifiableSet(this.typeOnlyCoercions);
    }

    public Set<NodeRef<InPredicate>> getSubqueryInPredicates() {
        return Collections.unmodifiableSet(this.subqueryInPredicates);
    }

    public Map<NodeRef<Expression>, FieldId> getColumnReferences() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public Map<NodeRef<Identifier>, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return Collections.unmodifiableMap(this.lambdaArgumentReferences);
    }

    public Type analyze(Expression expression, Scope scope) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)Context.notInLambda(scope)));
    }

    private Type analyze(Expression expression, Scope baseScope, Context context) {
        Visitor visitor = new Visitor(baseScope, this.warningCollector);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)context));
    }

    public Set<NodeRef<SubqueryExpression>> getScalarSubqueries() {
        return Collections.unmodifiableSet(this.scalarSubqueries);
    }

    public Set<NodeRef<ExistsPredicate>> getExistsSubqueries() {
        return Collections.unmodifiableSet(this.existsSubqueries);
    }

    public Set<NodeRef<QuantifiedComparisonExpression>> getQuantifiedComparisons() {
        return Collections.unmodifiableSet(this.quantifiedComparisons);
    }

    public Set<NodeRef<FunctionCall>> getWindowFunctions() {
        return Collections.unmodifiableSet(this.windowFunctions);
    }

    public Multimap<QualifiedObjectName, String> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public Multimap<NodeRef<Node>, Field> getReferencedFields() {
        return this.referencedFields;
    }

    public static ExpressionAnalysis analyzeExpressions(Session session, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, TypeProvider types, Iterable<Expression> expressions, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        Analysis analysis = new Analysis(null, parameters, isDescribe);
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(analysis, session, metadata, sqlParser, accessControl, types, warningCollector);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(new Field[0])).build());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getScalarSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalysis analyzeExpression(Session session, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(analysis, session, metadata, sqlParser, accessControl, TypeProvider.empty(), warningCollector, correlationSupport);
        analyzer.analyze(expression, scope);
        Map<NodeRef<Expression>, Type> expressionTypes = analyzer.getExpressionTypes();
        Map<NodeRef<Expression>, Type> expressionCoercions = analyzer.getExpressionCoercions();
        Set<NodeRef<Expression>> typeOnlyCoercions = analyzer.getTypeOnlyCoercions();
        Map<NodeRef<FunctionCall>, ResolvedFunction> resolvedFunctions = analyzer.getResolvedFunctions();
        analysis.addTypes(expressionTypes);
        analysis.addCoercions(expressionCoercions, typeOnlyCoercions);
        resolvedFunctions.entrySet().forEach(entry -> analysis.addResolvedFunction((FunctionCall)((NodeRef)entry.getKey()).getNode(), (ResolvedFunction)entry.getValue(), session.getUser()));
        analysis.addColumnReferences(analyzer.getColumnReferences());
        analysis.addLambdaArgumentReferences(analyzer.getLambdaArgumentReferences());
        analysis.addTableColumnReferences(accessControl, session.getIdentity(), analyzer.getTableColumnReferences());
        analysis.addReferencedFields(analyzer.getReferencedFields());
        return new ExpressionAnalysis(expressionTypes, expressionCoercions, analyzer.getSubqueryInPredicates(), analyzer.getScalarSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalyzer create(Analysis analysis, Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, TypeProvider types, WarningCollector warningCollector) {
        return ExpressionAnalyzer.create(analysis, session, metadata, sqlParser, accessControl, types, warningCollector, CorrelationSupport.ALLOWED);
    }

    public static ExpressionAnalyzer create(Analysis analysis, Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, TypeProvider types, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        return new ExpressionAnalyzer(metadata, accessControl, node -> new StatementAnalyzer(analysis, metadata, sqlParser, accessControl, session, warningCollector, correlationSupport), session, types, analysis.getParameters(), warningCollector, analysis.isDescribe(), correlationSupport);
    }

    public static ExpressionAnalyzer createConstantAnalyzer(Metadata metadata, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata, accessControl, session, parameters, (ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", warningCollector, false);
    }

    public static ExpressionAnalyzer createConstantAnalyzer(Metadata metadata, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata, accessControl, session, parameters, (ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", warningCollector, isDescribe);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(Metadata metadata, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, ErrorCodeSupplier errorCode, String message, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata, accessControl, session, TypeProvider.empty(), parameters, (? super Node node) -> SemanticExceptions.semanticException(errorCode, node, message, new Object[0]), warningCollector, isDescribe);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(Metadata metadata, AccessControl accessControl, Session session, TypeProvider symbolTypes, Map<NodeRef<Parameter>, Expression> parameters, Function<? super Node, ? extends RuntimeException> statementAnalyzerRejection, WarningCollector warningCollector, boolean isDescribe) {
        return new ExpressionAnalyzer(metadata, accessControl, node -> {
            throw (RuntimeException)statementAnalyzerRejection.apply((Node)node);
        }, session, symbolTypes, parameters, warningCollector, isDescribe, CorrelationSupport.ALLOWED);
    }

    private static class Context {
        private final Scope scope;
        private final List<Type> functionInputTypes;
        private final Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration;

        private Context(Scope scope, List<Type> functionInputTypes, Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration) {
            this.scope = Objects.requireNonNull(scope, "scope is null");
            this.functionInputTypes = functionInputTypes;
            this.fieldToLambdaArgumentDeclaration = fieldToLambdaArgumentDeclaration;
        }

        public static Context notInLambda(Scope scope) {
            return new Context(scope, null, null);
        }

        public static Context inLambda(Scope scope, Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration) {
            return new Context(scope, null, Objects.requireNonNull(fieldToLambdaArgumentDeclaration, "fieldToLambdaArgumentDeclaration is null"));
        }

        public Context expectingLambda(List<Type> functionInputTypes) {
            return new Context(this.scope, Objects.requireNonNull(functionInputTypes, "functionInputTypes is null"), this.fieldToLambdaArgumentDeclaration);
        }

        public Context notExpectingLambda() {
            return new Context(this.scope, null, this.fieldToLambdaArgumentDeclaration);
        }

        Scope getScope() {
            return this.scope;
        }

        public boolean isInLambda() {
            return this.fieldToLambdaArgumentDeclaration != null;
        }

        public boolean isExpectingLambda() {
            return this.functionInputTypes != null;
        }

        public Map<FieldId, LambdaArgumentDeclaration> getFieldToLambdaArgumentDeclaration() {
            Preconditions.checkState((boolean)this.isInLambda());
            return this.fieldToLambdaArgumentDeclaration;
        }

        public List<Type> getFunctionInputTypes() {
            Preconditions.checkState((boolean)this.isExpectingLambda());
            return this.functionInputTypes;
        }
    }

    private class Visitor
    extends StackableAstVisitor<Type, Context> {
        private final Scope baseScope;
        private final WarningCollector warningCollector;

        public Visitor(Scope baseScope, WarningCollector warningCollector) {
            this.baseScope = Objects.requireNonNull(baseScope, "baseScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        public Type process(Node node, @Nullable StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            if (node instanceof Expression && (type = ExpressionAnalyzer.this.expressionTypes.get(NodeRef.of((Node)((Expression)node)))) != null) {
                return type;
            }
            return (Type)super.process(node, context);
        }

        protected Type visitRow(Row node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            List types = (List)node.getItems().stream().map(child -> this.process((Node)child, context)).collect(ImmutableList.toImmutableList());
            RowType type = RowType.anonymous((List)types);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitCurrentTime(CurrentTime node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            DateType type;
            if (node.getPrecision() != null) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "non-default precision not yet supported", new Object[0]);
            }
            switch (node.getFunction()) {
                case DATE: {
                    type = DateType.DATE;
                    break;
                }
                case TIME: {
                    type = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIME: {
                    type = TimeType.TIME;
                    break;
                }
                case TIMESTAMP: {
                    type = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIMESTAMP: {
                    type = TimestampType.TIMESTAMP;
                    break;
                }
                default: {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "%s not yet supported", node.getFunction().getName());
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitSymbolReference(SymbolReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Optional<ResolvedField> resolvedField;
            if (((Context)context.getContext()).isInLambda() && (resolvedField = ((Context)context.getContext()).getScope().tryResolveField((Expression)node, QualifiedName.of((String)node.getName()))).isPresent() && ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().containsKey(FieldId.from(resolvedField.get()))) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, resolvedField.get().getType());
            }
            Type type = ExpressionAnalyzer.this.symbolTypes.get(Symbol.from((Expression)node));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitIdentifier(Identifier node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedField resolvedField = ((Context)context.getContext()).getScope().resolveField((Expression)node, QualifiedName.of((String)node.getValue()));
            return this.handleResolvedField((Expression)node, resolvedField, context);
        }

        private Type handleResolvedField(Expression node, ResolvedField resolvedField, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (!resolvedField.isLocal() && ExpressionAnalyzer.this.correlationSupport != CorrelationSupport.ALLOWED) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Reference to column '%s' from outer scope not allowed in this context", node);
            }
            return this.handleResolvedField(node, FieldId.from(resolvedField), resolvedField.getField(), context);
        }

        private Type handleResolvedField(Expression node, FieldId fieldId, Field field, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            LambdaArgumentDeclaration lambdaArgumentDeclaration;
            if (((Context)context.getContext()).isInLambda() && (lambdaArgumentDeclaration = ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().get(fieldId)) != null) {
                ExpressionAnalyzer.this.lambdaArgumentReferences.put((NodeRef<Identifier>)NodeRef.of((Node)((Identifier)node)), lambdaArgumentDeclaration);
                return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
            }
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                ExpressionAnalyzer.this.tableColumnReferences.put((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get());
            }
            fieldId.getRelationId().getSourceNode().ifPresent(source -> ExpressionAnalyzer.this.referencedFields.put((Object)NodeRef.of((Node)source), (Object)field));
            FieldId previous = ExpressionAnalyzer.this.columnReferences.put((NodeRef<Expression>)NodeRef.of((Node)node), fieldId);
            Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"%s already known to refer to %s", (Object)node, (Object)previous);
            return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
        }

        protected Type visitDereferenceExpression(DereferenceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type baseType;
            QualifiedName qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)node);
            if (qualifiedName != null) {
                Scope scope = ((Context)context.getContext()).getScope();
                Optional<ResolvedField> resolvedField = scope.tryResolveField((Expression)node, qualifiedName);
                if (resolvedField.isPresent()) {
                    return this.handleResolvedField((Expression)node, resolvedField.get(), context);
                }
                if (!scope.isColumnReference(qualifiedName)) {
                    throw SemanticExceptions.missingAttributeException((Expression)node, qualifiedName);
                }
            }
            if (!((baseType = this.process((Node)node.getBase(), context)) instanceof RowType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getBase(), "Expression %s is not of type ROW", node.getBase());
            }
            RowType rowType = (RowType)baseType;
            String fieldName = node.getField().getValue();
            Type rowFieldType = null;
            for (RowType.Field rowField : rowType.getFields()) {
                if (!fieldName.equalsIgnoreCase(rowField.getName().orElse(null))) continue;
                rowFieldType = rowField.getType();
                break;
            }
            if (rowFieldType == null) {
                throw SemanticExceptions.missingAttributeException((Expression)node, qualifiedName);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, rowFieldType);
        }

        protected Type visitNotExpression(NotExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitLogicalBinaryExpression(LogicalBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getLeft(), (Type)BooleanType.BOOLEAN, "Left side of logical expression");
            this.coerceType(context, node.getRight(), (Type)BooleanType.BOOLEAN, "Right side of logical expression");
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitComparisonExpression(ComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            OperatorType operatorType = OperatorType.valueOf((String)node.getOperator().name());
            return this.getOperator(context, (Expression)node, operatorType, node.getLeft(), node.getRight());
        }

        protected Type visitIsNullPredicate(IsNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitNullIfExpression(NullIfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type secondType;
            Type firstType = this.process((Node)node.getFirst(), context);
            if (ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(firstType, secondType = this.process((Node)node.getSecond(), context)).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with NULLIF: %s vs %s", firstType, secondType);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, firstType);
        }

        protected Type visitIfExpression(IfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, (Node)node, "Result types for IF must be the same: %s vs %s", node.getTrueValue(), (Expression)node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType((Expression)whenClause, whenClauseType);
            }
            return type;
        }

        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceCaseOperandToToSingleType(node, context);
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType((Expression)whenClause, whenClauseType);
            }
            return type;
        }

        private void coerceCaseOperandToToSingleType(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression whenOperand;
            Type operandType = this.process((Node)node.getOperand(), context);
            List whenClauses = node.getWhenClauses();
            ArrayList<Type> whenOperandTypes = new ArrayList<Type>(whenClauses.size());
            Type commonType = operandType;
            for (WhenClause whenClause : whenClauses) {
                whenOperand = whenClause.getOperand();
                Type whenOperandType = this.process((Node)whenOperand, context);
                whenOperandTypes.add(whenOperandType);
                Optional<Type> operandCommonType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(commonType, whenOperandType);
                if (operandCommonType.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)whenOperand, "CASE operand type does not match WHEN clause operand type: %s vs %s", operandType, whenOperandType);
                }
                commonType = operandCommonType.get();
            }
            if (commonType != operandType) {
                this.addOrReplaceExpressionCoercion(node.getOperand(), operandType, commonType);
            }
            for (int i = 0; i < whenOperandTypes.size(); ++i) {
                Type whenOperandType = (Type)whenOperandTypes.get(i);
                if (whenOperandType.equals(commonType)) continue;
                whenOperand = ((WhenClause)whenClauses.get(i)).getOperand();
                this.addOrReplaceExpressionCoercion(whenOperand, whenOperandType, commonType);
            }
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            defaultValue.ifPresent(resultExpressions::add);
            return resultExpressions;
        }

        protected Type visitCoalesceExpression(CoalesceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands must be the same type: %s", node.getOperands());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitArithmeticUnary(ArithmeticUnaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            switch (node.getSign()) {
                case PLUS: {
                    Type type = this.process((Node)node.getValue(), context);
                    if (!(type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unary '+' operator cannot by applied to %s type", type);
                    }
                    return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
                }
                case MINUS: {
                    return this.getOperator(context, (Expression)node, OperatorType.NEGATION, node.getValue());
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected Type visitArithmeticBinary(ArithmeticBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.getOperator(context, (Expression)node, OperatorType.valueOf((String)node.getOperator().name()), node.getLeft(), node.getRight());
        }

        protected Type visitLikePredicate(LikePredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            if (!(valueType instanceof CharType) && !(valueType instanceof VarcharType)) {
                this.coerceType(context, node.getValue(), (Type)VarcharType.VARCHAR, "Left side of LIKE expression");
            }
            Type patternType = this.getVarcharType(node.getPattern(), context);
            this.coerceType(context, node.getPattern(), patternType, "Pattern for LIKE expression");
            if (node.getEscape().isPresent()) {
                Expression escape = (Expression)node.getEscape().get();
                Type escapeType = this.getVarcharType(escape, context);
                this.coerceType(context, escape, escapeType, "Escape for LIKE expression");
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        private Type getVarcharType(Expression value, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.process((Node)value, context);
            if (!(type instanceof VarcharType)) {
                return VarcharType.VARCHAR;
            }
            return type;
        }

        protected Type visitSubscriptExpression(SubscriptExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type baseType = this.process((Node)node.getBase(), context);
            if (baseType instanceof RowType) {
                if (!(node.getIndex() instanceof LongLiteral)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)node.getIndex(), "Subscript expression on ROW requires a constant index", new Object[0]);
                }
                Type indexType = this.process((Node)node.getIndex(), context);
                if (!indexType.equals(IntegerType.INTEGER)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getIndex(), "Subscript expression on ROW requires integer index, found %s", indexType);
                }
                int indexValue = Math.toIntExact(((LongLiteral)node.getIndex()).getValue());
                if (indexValue <= 0) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node.getIndex(), "Invalid subscript index: %s. ROW indices start at 1", indexValue);
                }
                List rowTypes = baseType.getTypeParameters();
                if (indexValue > rowTypes.size()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node.getIndex(), "Subscript index out of bounds: %s, max value is %s", indexValue, rowTypes.size());
                }
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)rowTypes.get(indexValue - 1));
            }
            return this.getOperator(context, (Expression)node, OperatorType.SUBSCRIPT, node.getBase(), node.getIndex());
        }

        protected Type visitArrayConstructor(ArrayConstructor node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All ARRAY elements must be the same type: %s", node.getValues());
            Type arrayType = ExpressionAnalyzer.this.metadata.getParameterizedType(ArrayParametricType.ARRAY.getName(), (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)type.getTypeSignature())));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, arrayType);
        }

        protected Type visitStringLiteral(StringLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            VarcharType type = VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice()));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitCharLiteral(CharLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            CharType type = CharType.createCharType((long)node.getValue().length());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitBinaryLiteral(BinaryLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarbinaryType.VARBINARY);
        }

        protected Type visitLongLiteral(LongLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)IntegerType.INTEGER);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        protected Type visitDoubleLiteral(DoubleLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)DoubleType.DOUBLE);
        }

        protected Type visitDecimalLiteral(DecimalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)parseResult.getType());
        }

        protected Type visitBooleanLiteral(BooleanLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitGenericLiteral(GenericLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            try {
                type = ExpressionAnalyzer.this.metadata.fromSqlType(node.getType());
            }
            catch (TypeNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)node, "Unknown type: %s", node.getType());
            }
            if (!JsonType.JSON.equals(type)) {
                try {
                    ExpressionAnalyzer.this.metadata.getCoercion((Type)VarcharType.VARCHAR, type);
                }
                catch (IllegalArgumentException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "No literal form for type %s", type);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitTimeLiteral(TimeLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            boolean hasTimeZone;
            try {
                hasTimeZone = DateTimeUtils.timeHasTimeZone(node.getValue());
            }
            catch (IllegalArgumentException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid time literal", node.getValue());
            }
            TimeWithTimeZoneType type = hasTimeZone ? TimeWithTimeZoneType.TIME_WITH_TIME_ZONE : TimeType.TIME;
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitTimestampLiteral(TimestampLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            TimestampWithTimeZoneType type;
            try {
                if (DateTimeUtils.timestampHasTimeZone(node.getValue())) {
                    type = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
                    DateTimeUtils.parseTimestampWithTimeZone(node.getValue());
                } else {
                    type = TimestampType.TIMESTAMP;
                    if (SystemSessionProperties.isLegacyTimestamp(ExpressionAnalyzer.this.session)) {
                        DateTimeUtils.parseLegacyTimestamp(ExpressionAnalyzer.this.session.getTimeZoneKey(), node.getValue());
                    } else {
                        DateTimeUtils.parseTimestamp(node.getValue());
                    }
                }
            }
            catch (Exception e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid timestamp literal", node.getValue());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitIntervalLiteral(IntervalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Object type = node.isYearToMonth() ? IntervalYearMonthType.INTERVAL_YEAR_MONTH : IntervalDayTimeType.INTERVAL_DAY_TIME;
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitNullLiteral(NullLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)UnknownType.UNKNOWN);
        }

        protected Type visitFunctionCall(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedFunction function;
            if (node.getWindow().isPresent()) {
                Type type;
                for (Expression expression : ((Window)node.getWindow().get()).getPartitionBy()) {
                    this.process((Node)expression, context);
                    type = ExpressionAnalyzer.this.getExpressionType(expression);
                    if (type.isComparable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in window function PARTITION BY", type);
                }
                for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(((Window)node.getWindow().get()).getOrderBy())) {
                    this.process((Node)sortItem.getSortKey(), context);
                    type = ExpressionAnalyzer.this.getExpressionType(sortItem.getSortKey());
                    if (type.isOrderable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "%s is not orderable, and therefore cannot be used in window function ORDER BY", type);
                }
                if (((Window)node.getWindow().get()).getFrame().isPresent()) {
                    Type type2;
                    WindowFrame frame = (WindowFrame)((Window)node.getWindow().get()).getFrame().get();
                    if (frame.getStart().getValue().isPresent() && !(type2 = this.process((Node)frame.getStart().getValue().get(), context)).equals(IntegerType.INTEGER) && !type2.equals(BigintType.BIGINT)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Window frame start value type must be INTEGER or BIGINT(actual %s)", type2);
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent() && !(type2 = this.process((Node)((FrameBound)frame.getEnd().get()).getValue().get(), context)).equals(IntegerType.INTEGER) && !type2.equals(BigintType.BIGINT)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Window frame end value type must be INTEGER or BIGINT (actual %s)", type2);
                    }
                }
                ExpressionAnalyzer.this.windowFunctions.add((NodeRef<FunctionCall>)NodeRef.of((Node)node));
            }
            if (node.getFilter().isPresent()) {
                Expression expression = (Expression)node.getFilter().get();
                this.process((Node)expression, context);
            }
            List<TypeSignatureProvider> argumentTypes = this.getCallArgumentTypes(node.getArguments(), context);
            try {
                function = ExpressionAnalyzer.this.metadata.resolveFunction(node.getName(), argumentTypes);
            }
            catch (PrestoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new PrestoException(() -> ((PrestoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            if (function.getSignature().getName().equalsIgnoreCase("ARRAY_CONSTRUCTOR")) {
                if (node.getArguments().size() > 254) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, (Node)node, "Too many arguments for array constructor", function.getSignature().getName());
                }
            } else if (node.getArguments().size() > 127) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, (Node)node, "Too many arguments for function call %s()", function.getSignature().getName());
            }
            if (node.getOrderBy().isPresent()) {
                for (SortItem sortItem : ((OrderBy)node.getOrderBy().get()).getSortItems()) {
                    Type sortKeyType = this.process((Node)sortItem.getSortKey(), context);
                    if (sortKeyType.isOrderable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "ORDER BY can only be applied to orderable types (actual: %s)", sortKeyType.getDisplayName());
                }
            }
            Signature signature = function.getSignature();
            for (int i = 0; i < node.getArguments().size(); ++i) {
                Expression expression = (Expression)node.getArguments().get(i);
                Type expectedType = ExpressionAnalyzer.this.metadata.getType(signature.getArgumentTypes().get(i));
                Objects.requireNonNull(expectedType, String.format("Type '%s' not found", signature.getArgumentTypes().get(i)));
                if (node.isDistinct() && !expectedType.isComparable()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "DISTINCT can only be applied to comparable types (actual: %s)", expectedType);
                }
                if (argumentTypes.get(i).hasDependency()) {
                    FunctionType expectedFunctionType = (FunctionType)expectedType;
                    this.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).expectingLambda(expectedFunctionType.getArgumentTypes())));
                    continue;
                }
                Type actualType = ExpressionAnalyzer.this.metadata.getType(argumentTypes.get(i).getTypeSignature());
                this.coerceType(expression, actualType, expectedType, String.format("Function %s argument %d", function, i));
            }
            ExpressionAnalyzer.this.accessControl.checkCanExecuteFunction(SecurityContext.of(ExpressionAnalyzer.this.session), node.getName().toString());
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<FunctionCall>)NodeRef.of((Node)node), function);
            FunctionMetadata functionMetadata = ExpressionAnalyzer.this.metadata.getFunctionMetadata(function);
            if (functionMetadata.isDeprecated()) {
                this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.DEPRECATED_FUNCTION, String.format("Use of deprecated function: %s: %s", functionMetadata.getSignature().getName(), functionMetadata.getDescription())));
            }
            Type type = ExpressionAnalyzer.this.metadata.getType(signature.getReturnType());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public List<TypeSignatureProvider> getCallArgumentTypes(List<Expression> arguments, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ImmutableList.Builder argumentTypesBuilder = ImmutableList.builder();
            for (Expression argument : arguments) {
                if (argument instanceof LambdaExpression || argument instanceof BindExpression) {
                    argumentTypesBuilder.add((Object)new TypeSignatureProvider(types -> {
                        ExpressionAnalyzer innerExpressionAnalyzer = new ExpressionAnalyzer(ExpressionAnalyzer.this.metadata, ExpressionAnalyzer.this.accessControl, ExpressionAnalyzer.this.statementAnalyzerFactory, ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.symbolTypes, ExpressionAnalyzer.this.parameters, this.warningCollector, ExpressionAnalyzer.this.isDescribe, ExpressionAnalyzer.this.correlationSupport);
                        if (((Context)context.getContext()).isInLambda()) {
                            for (LambdaArgumentDeclaration lambdaArgument : ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().values()) {
                                innerExpressionAnalyzer.setExpressionType((Expression)lambdaArgument, ExpressionAnalyzer.this.getExpressionType((Expression)lambdaArgument));
                            }
                        }
                        return innerExpressionAnalyzer.analyze(argument, this.baseScope, ((Context)context.getContext()).expectingLambda((List<Type>)types)).getTypeSignature();
                    }));
                    continue;
                }
                argumentTypesBuilder.add((Object)new TypeSignatureProvider(this.process((Node)argument, context).getTypeSignature()));
            }
            return argumentTypesBuilder.build();
        }

        protected Type visitAtTimeZone(AtTimeZone node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            this.process((Node)node.getTimeZone(), context);
            if (!(valueType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || valueType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || valueType.equals(TimeType.TIME) || valueType.equals(TimestampType.TIMESTAMP))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Type of value must be a time or timestamp with or without time zone (actual %s)", valueType);
            }
            Type resultType = valueType;
            if (valueType.equals(TimeType.TIME)) {
                resultType = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
            } else if (valueType.equals(TimestampType.TIMESTAMP)) {
                resultType = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
        }

        protected Type visitCurrentUser(CurrentUser node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitCurrentPath(CurrentPath node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitFormat(Format node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            List arguments = (List)node.getArguments().stream().map(expression -> this.process((Node)expression, context)).collect(ImmutableList.toImmutableList());
            if (!Varchars.isVarcharType((Type)((Type)arguments.get(0)))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getArguments().get(0), "Type of first argument to format() must be VARCHAR (actual: %s)", arguments.get(0));
            }
            for (int i = 1; i < arguments.size(); ++i) {
                try {
                    FormatFunction.validateType(ExpressionAnalyzer.this.metadata, (Type)arguments.get(i));
                    continue;
                }
                catch (PrestoException e) {
                    if (e.getErrorCode().equals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode())) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node.getArguments().get(i), "%s", e.getRawMessage());
                    }
                    throw e;
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitParameter(Parameter node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (ExpressionAnalyzer.this.isDescribe) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)UnknownType.UNKNOWN);
            }
            if (ExpressionAnalyzer.this.parameters.size() == 0) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Query takes no parameters", new Object[0]);
            }
            if (node.getPosition() >= ExpressionAnalyzer.this.parameters.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Invalid parameter index %s, max value is %s", node.getPosition(), ExpressionAnalyzer.this.parameters.size() - 1);
            }
            Type resultType = this.process((Node)ExpressionAnalyzer.this.parameters.get(NodeRef.of((Node)node)), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
        }

        protected Type visitExtract(Extract node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.process((Node)node.getExpression(), context);
            if (!this.isDateTimeType(type)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract must be DATE, TIME, TIMESTAMP, or INTERVAL (actual %s)", type);
            }
            Extract.Field field = node.getField();
            if (!(field != Extract.Field.TIMEZONE_HOUR && field != Extract.Field.TIMEZONE_MINUTE || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract time zone field must have a time zone (actual %s)", type);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        private boolean isDateTimeType(Type type) {
            return type.equals(DateType.DATE) || type.equals(TimeType.TIME) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampType.TIMESTAMP) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) || type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        }

        protected Type visitBetweenPredicate(BetweenPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.getOperator(context, (Expression)node, OperatorType.BETWEEN, node.getValue(), node.getMin(), node.getMax());
        }

        public Type visitTryExpression(TryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.process((Node)node.getInnerExpression(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public Type visitCast(Cast node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            try {
                type = ExpressionAnalyzer.this.metadata.getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
            }
            catch (TypeNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getType());
            }
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "UNKNOWN is not a valid type", new Object[0]);
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (!value.equals((Object)UnknownType.UNKNOWN) && !node.isTypeOnly()) {
                try {
                    ExpressionAnalyzer.this.metadata.getCoercion(value, type);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast %s to %s", value, type);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitInPredicate(InPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression value = node.getValue();
            this.process((Node)value, context);
            Expression valueList = node.getValueList();
            this.process((Node)valueList, context);
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                this.coerceToSingleType(context, "IN value and list items must be the same type: %s", (List<Expression>)ImmutableList.builder().add((Object)value).addAll((Iterable)inListExpression.getValues()).build());
            } else if (valueList instanceof SubqueryExpression) {
                this.coerceToSingleType(context, (Node)node, "value and result of subquery must be of the same type for IN expression: %s vs %s", value, valueList);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitInListExpression(InListExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All IN list values must be the same type: %s", node.getValues());
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            return type;
        }

        protected Type visitSubqueryExpression(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (((Context)context.getContext()).isInLambda()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Lambda expression cannot contain subqueries", new Object[0]);
            }
            StatementAnalyzer analyzer = ExpressionAnalyzer.this.statementAnalyzerFactory.apply((Node)node);
            Scope subqueryScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).build();
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), subqueryScope);
            if (queryScope.getRelationType().getVisibleFieldCount() != 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Multiple columns returned by subquery are not yet supported. Found %s", queryScope.getRelationType().getVisibleFieldCount());
            }
            Node previousNode = context.getPreviousNode().orElse(null);
            if (previousNode instanceof InPredicate && ((InPredicate)previousNode).getValue() != node) {
                ExpressionAnalyzer.this.subqueryInPredicates.add((NodeRef<InPredicate>)NodeRef.of((Node)((InPredicate)previousNode)));
            } else if (previousNode instanceof QuantifiedComparisonExpression) {
                ExpressionAnalyzer.this.quantifiedComparisons.add((NodeRef<QuantifiedComparisonExpression>)NodeRef.of((Node)((QuantifiedComparisonExpression)previousNode)));
            } else {
                ExpressionAnalyzer.this.scalarSubqueries.add((NodeRef<SubqueryExpression>)NodeRef.of((Node)node));
            }
            Type type = ((Field)Iterables.getOnlyElement(queryScope.getRelationType().getVisibleFields())).getType();
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitExists(ExistsPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            StatementAnalyzer analyzer = ExpressionAnalyzer.this.statementAnalyzerFactory.apply((Node)node);
            Scope subqueryScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).build();
            analyzer.analyze((Node)node.getSubquery(), subqueryScope);
            ExpressionAnalyzer.this.existsSubqueries.add((NodeRef<ExistsPredicate>)NodeRef.of((Node)node));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression value = node.getValue();
            this.process((Node)value, context);
            Expression subquery = node.getSubquery();
            this.process((Node)subquery, context);
            Type comparisonType = this.coerceToSingleType(context, (Node)node, "Value expression and result of subquery must be of the same type for quantified comparison: %s vs %s", value, subquery);
            switch (node.getOperator()) {
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    if (comparisonType.isOrderable()) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Type [%s] must be orderable in order to be used in quantified comparison", comparisonType);
                }
                case EQUAL: 
                case NOT_EQUAL: {
                    if (comparisonType.isComparable()) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Type [%s] must be comparable in order to be used in quantified comparison", comparisonType);
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected comparison type: %s", node.getOperator()));
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        public Type visitFieldReference(FieldReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Field field = this.baseScope.getRelationType().getFieldByIndex(node.getFieldIndex());
            return this.handleResolvedField((Expression)node, new FieldId(this.baseScope.getRelationId(), node.getFieldIndex()), field, context);
        }

        protected Type visitLambdaExpression(LambdaExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(ExpressionAnalyzer.this.metadata, node.getBody(), "Lambda expression");
            if (!((Context)context.getContext()).isExpectingLambda()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Lambda expression should always be used inside a function", new Object[0]);
            }
            List<Type> types = ((Context)context.getContext()).getFunctionInputTypes();
            List lambdaArguments = node.getArguments();
            if (types.size() != lambdaArguments.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, String.format("Expected a lambda that takes %s argument(s) but got %s", types.size(), lambdaArguments.size()), new Object[0]);
            }
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < lambdaArguments.size(); ++i) {
                LambdaArgumentDeclaration lambdaArgument = (LambdaArgumentDeclaration)lambdaArguments.get(i);
                Type type = types.get(i);
                fields.add((Object)Field.newUnqualified(lambdaArgument.getName().getValue(), type));
                ExpressionAnalyzer.this.setExpressionType((Expression)lambdaArgument, type);
            }
            Scope lambdaScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).withRelationType(RelationId.of((Node)node), new RelationType((List<Field>)fields.build())).build();
            ImmutableMap.Builder fieldToLambdaArgumentDeclaration = ImmutableMap.builder();
            if (((Context)context.getContext()).isInLambda()) {
                fieldToLambdaArgumentDeclaration.putAll(((Context)context.getContext()).getFieldToLambdaArgumentDeclaration());
            }
            for (LambdaArgumentDeclaration lambdaArgument : lambdaArguments) {
                ResolvedField resolvedField = lambdaScope.resolveField((Expression)lambdaArgument, QualifiedName.of((String)lambdaArgument.getName().getValue()));
                fieldToLambdaArgumentDeclaration.put((Object)FieldId.from(resolvedField), (Object)lambdaArgument);
            }
            Type returnType = this.process((Node)node.getBody(), (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)Context.inLambda(lambdaScope, (Map<FieldId, LambdaArgumentDeclaration>)fieldToLambdaArgumentDeclaration.build())));
            FunctionType functionType = new FunctionType(types, returnType);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, functionType);
        }

        protected Type visitBindExpression(BindExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Verify.verify((boolean)((Context)context.getContext()).isExpectingLambda(), (String)"bind expression found when lambda is not expected", (Object[])new Object[0]);
            StackableAstVisitor.StackableAstVisitorContext innerContext = new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).notExpectingLambda());
            ImmutableList.Builder functionInputTypesBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                functionInputTypesBuilder.add((Object)this.process((Node)value, (StackableAstVisitor.StackableAstVisitorContext<Context>)innerContext));
            }
            functionInputTypesBuilder.addAll(((Context)context.getContext()).getFunctionInputTypes());
            ImmutableList functionInputTypes = functionInputTypesBuilder.build();
            FunctionType functionType = (FunctionType)this.process((Node)node.getFunction(), (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).expectingLambda((List<Type>)functionInputTypes)));
            List<Type> argumentTypes = functionType.getArgumentTypes();
            int numCapturedValues = node.getValues().size();
            Verify.verify((argumentTypes.size() == functionInputTypes.size() ? 1 : 0) != 0);
            for (int i = 0; i < numCapturedValues; ++i) {
                Verify.verify((boolean)((Type)functionInputTypes.get(i)).equals(argumentTypes.get(i)));
            }
            FunctionType result = new FunctionType(argumentTypes.subList(numCapturedValues, argumentTypes.size()), functionType.getReturnType());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, result);
        }

        protected Type visitExpression(Expression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "not yet implemented: %s", node.getClass().getName());
        }

        protected Type visitNode(Node node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, node, "not yet implemented: %s", node.getClass().getName());
        }

        public Type visitGroupingOperation(GroupingOperation node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getGroupingColumns().size() > 63) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, (Node)node, "GROUPING supports up to %d column arguments", 63);
            }
            for (Expression columnArgument : node.getGroupingColumns()) {
                this.process((Node)columnArgument, context);
            }
            if (node.getGroupingColumns().size() <= 31) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)IntegerType.INTEGER);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        private Type getOperator(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression node, OperatorType operatorType, Expression ... arguments) {
            Signature operatorSignature;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                operatorSignature = ExpressionAnalyzer.this.metadata.resolveOperator(operatorType, (List<? extends Type>)argumentTypes.build()).getSignature();
            }
            catch (OperatorNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "%s", e.getMessage());
            }
            for (int i = 0; i < arguments.length; ++i) {
                Expression expression = arguments[i];
                Type type = ExpressionAnalyzer.this.metadata.getType(operatorSignature.getArgumentTypes().get(i));
                this.coerceType(context, expression, type, String.format("Operator %s argument %d", operatorSignature, i));
            }
            Type type = ExpressionAnalyzer.this.metadata.getType(operatorSignature.getReturnType());
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        private void coerceType(Expression expression, Type actualType, Type expectedType, String message) {
            if (!actualType.equals(expectedType)) {
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(actualType, expectedType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "%s must evaluate to a %s (actual: %s)", message, expectedType, actualType);
                }
                this.addOrReplaceExpressionCoercion(expression, actualType, expectedType);
            }
        }

        private void coerceType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            this.coerceType(expression, actualType, expectedType, message);
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Node node, String message, Expression first, Expression second) {
            Optional<Type> superTypeOptional;
            UnknownType firstType = UnknownType.UNKNOWN;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            UnknownType secondType = UnknownType.UNKNOWN;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if ((superTypeOptional = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType((Type)firstType, (Type)secondType)).isPresent() && ExpressionAnalyzer.this.typeCoercion.canCoerce((Type)firstType, superTypeOptional.get()) && ExpressionAnalyzer.this.typeCoercion.canCoerce((Type)secondType, superTypeOptional.get())) {
                Type superType = superTypeOptional.get();
                if (!((Object)((Object)firstType)).equals(superType)) {
                    this.addOrReplaceExpressionCoercion(first, (Type)firstType, superType);
                }
                if (!((Object)((Object)secondType)).equals(superType)) {
                    this.addOrReplaceExpressionCoercion(second, (Type)secondType, superType);
                }
                return superType;
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, message, new Object[]{firstType, secondType});
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, String message, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            for (Expression expression : expressions) {
                Optional<Type> newSuperType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType((Type)superType, this.process((Node)expression, context));
                if (newSuperType.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                superType = newSuperType.get();
            }
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                if (type.equals((Object)superType)) continue;
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(type, (Type)superType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                this.addOrReplaceExpressionCoercion(expression, type, (Type)superType);
            }
            return superType;
        }

        private void addOrReplaceExpressionCoercion(Expression expression, Type type, Type superType) {
            NodeRef ref = NodeRef.of((Node)expression);
            ExpressionAnalyzer.this.expressionCoercions.put((NodeRef<Expression>)ref, superType);
            if (ExpressionAnalyzer.this.typeCoercion.isTypeOnlyCoercion(type, superType)) {
                ExpressionAnalyzer.this.typeOnlyCoercions.add((NodeRef<Expression>)ref);
            } else if (ExpressionAnalyzer.this.typeOnlyCoercions.contains(ref)) {
                ExpressionAnalyzer.this.typeOnlyCoercions.remove(ref);
            }
        }
    }
}

