/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.prestosql.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import io.prestosql.operator.aggregation.histogram.HistogramGroupImplementation;
import io.prestosql.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import io.prestosql.sql.analyzer.RegexLibrary;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"deprecated.legacy-char-to-varchar-coercion", "deprecated.legacy-map-subscript", "deprecated.group-by-uses-equal", "deprecated.legacy-row-field-ordinal-access", "deprecated.legacy-unnest-array-rows", "resource-group-manager", "experimental.resource-groups-enabled", "experimental-syntax-enabled", "analyzer.experimental-syntax-enabled", "optimizer.processing-optimization", "deprecated.legacy-order-by", "deprecated.legacy-join-using"})
public class FeaturesConfig {
    @VisibleForTesting
    static final String SPILL_ENABLED = "spill-enabled";
    public static final String SPILLER_SPILL_PATH = "spiller-spill-path";
    private double cpuCostWeight = 75.0;
    private double memoryCostWeight = 10.0;
    private double networkCostWeight = 15.0;
    private boolean distributedIndexJoinsEnabled;
    private DataSize joinMaxBroadcastTableSize = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private JoinDistributionType joinDistributionType = JoinDistributionType.AUTOMATIC;
    private boolean colocatedJoinsEnabled;
    private boolean groupedExecutionEnabled;
    private boolean dynamicScheduleForGroupedExecution;
    private int concurrentLifespansPerTask;
    private boolean spatialJoinsEnabled = true;
    private boolean fastInequalityJoins = true;
    private JoinReorderingStrategy joinReorderingStrategy = JoinReorderingStrategy.AUTOMATIC;
    private int maxReorderedJoins = 9;
    private boolean redistributeWrites = true;
    private boolean usePreferredWritePartitioning;
    private boolean scaleWriters;
    private DataSize writerMinSize = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean optimizeMetadataQueries;
    private boolean optimizeHashGeneration = true;
    private boolean enableIntermediateAggregations;
    private boolean pushTableWriteThroughUnion = true;
    private DataIntegrityVerification exchangeDataIntegrityVerification = DataIntegrityVerification.ABORT;
    private boolean exchangeCompressionEnabled;
    private boolean legacyTimestamp = true;
    private boolean optimizeMixedDistinctAggregations;
    private boolean unwrapCasts = true;
    private boolean forceSingleNodeOutput = true;
    private boolean pagesIndexEagerCompactionEnabled;
    private boolean distributedSort = true;
    private boolean dictionaryAggregation;
    private int re2JDfaStatesLimit = Integer.MAX_VALUE;
    private int re2JDfaRetries = 5;
    private RegexLibrary regexLibrary = RegexLibrary.JONI;
    private HistogramGroupImplementation histogramGroupImplementation = HistogramGroupImplementation.NEW;
    private ArrayAggGroupImplementation arrayAggGroupImplementation = ArrayAggGroupImplementation.NEW;
    private MultimapAggGroupImplementation multimapAggGroupImplementation = MultimapAggGroupImplementation.NEW;
    private boolean spillEnabled;
    private boolean spillOrderBy = true;
    private boolean spillWindowOperator = true;
    private DataSize aggregationOperatorUnspillMemoryLimit = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private List<Path> spillerSpillPaths = ImmutableList.of();
    private int spillerThreads = 4;
    private double spillMaxUsedSpaceThreshold = 0.9;
    private boolean iterativeOptimizerEnabled = true;
    private boolean enableStatsCalculator = true;
    private boolean collectPlanStatisticsForAllQueries;
    private boolean ignoreStatsCalculatorFailures = true;
    private boolean defaultFilterFactorEnabled;
    private boolean enableForcedExchangeBelowGroupId = true;
    private boolean pushAggregationThroughOuterJoin = true;
    private boolean pushPartialAggregationThoughJoin;
    private double memoryRevokingTarget = 0.5;
    private double memoryRevokingThreshold = 0.9;
    private boolean parseDecimalLiteralsAsDouble;
    private boolean useMarkDistinct = true;
    private boolean preferPartialAggregation = true;
    private boolean optimizeTopNRowNumber = true;
    private boolean lateMaterializationEnabled;
    private boolean skipRedundantSort = true;
    private boolean predicatePushdownUseTableProperties = true;
    private boolean ignoreDownstreamPreferences;
    private Duration iterativeOptimizerTimeout = new Duration(3.0, TimeUnit.MINUTES);
    private boolean enableDynamicFiltering = true;
    private int dynamicFilteringMaxPerDriverRowCount = 100;
    private DataSize dynamicFilteringMaxPerDriverSize = DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private DataSize filterAndProjectMinOutputPageSize = DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int filterAndProjectMinOutputPageRowCount = 256;
    private int maxGroupingSets = 2048;

    public double getCpuCostWeight() {
        return this.cpuCostWeight;
    }

    @Config(value="cpu-cost-weight")
    public FeaturesConfig setCpuCostWeight(double cpuCostWeight) {
        this.cpuCostWeight = cpuCostWeight;
        return this;
    }

    public double getMemoryCostWeight() {
        return this.memoryCostWeight;
    }

    @Config(value="memory-cost-weight")
    public FeaturesConfig setMemoryCostWeight(double memoryCostWeight) {
        this.memoryCostWeight = memoryCostWeight;
        return this;
    }

    public double getNetworkCostWeight() {
        return this.networkCostWeight;
    }

    @Config(value="network-cost-weight")
    public FeaturesConfig setNetworkCostWeight(double networkCostWeight) {
        this.networkCostWeight = networkCostWeight;
        return this;
    }

    public boolean isDistributedIndexJoinsEnabled() {
        return this.distributedIndexJoinsEnabled;
    }

    @Config(value="distributed-index-joins-enabled")
    public FeaturesConfig setDistributedIndexJoinsEnabled(boolean distributedIndexJoinsEnabled) {
        this.distributedIndexJoinsEnabled = distributedIndexJoinsEnabled;
        return this;
    }

    @Config(value="deprecated.legacy-timestamp")
    public FeaturesConfig setLegacyTimestamp(boolean value) {
        this.legacyTimestamp = value;
        return this;
    }

    public boolean isLegacyTimestamp() {
        return this.legacyTimestamp;
    }

    public JoinDistributionType getJoinDistributionType() {
        return this.joinDistributionType;
    }

    @Config(value="join-distribution-type")
    public FeaturesConfig setJoinDistributionType(JoinDistributionType joinDistributionType) {
        this.joinDistributionType = Objects.requireNonNull(joinDistributionType, "joinDistributionType is null");
        return this;
    }

    @NotNull
    public DataSize getJoinMaxBroadcastTableSize() {
        return this.joinMaxBroadcastTableSize;
    }

    @Config(value="join-max-broadcast-table-size")
    @ConfigDescription(value="Maximum estimated size of a table that can be broadcast when using automatic join type selection")
    public FeaturesConfig setJoinMaxBroadcastTableSize(DataSize joinMaxBroadcastTableSize) {
        this.joinMaxBroadcastTableSize = joinMaxBroadcastTableSize;
        return this;
    }

    public boolean isGroupedExecutionEnabled() {
        return this.groupedExecutionEnabled;
    }

    @Config(value="grouped-execution-enabled")
    @ConfigDescription(value="Experimental: Use grouped execution when possible")
    public FeaturesConfig setGroupedExecutionEnabled(boolean groupedExecutionEnabled) {
        this.groupedExecutionEnabled = groupedExecutionEnabled;
        return this;
    }

    public boolean isDynamicScheduleForGroupedExecutionEnabled() {
        return this.dynamicScheduleForGroupedExecution;
    }

    @Config(value="dynamic-schedule-for-grouped-execution")
    @ConfigDescription(value="Experimental: Use dynamic schedule for grouped execution when possible")
    public FeaturesConfig setDynamicScheduleForGroupedExecutionEnabled(boolean dynamicScheduleForGroupedExecution) {
        this.dynamicScheduleForGroupedExecution = dynamicScheduleForGroupedExecution;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getConcurrentLifespansPerTask() {
        return this.concurrentLifespansPerTask;
    }

    @Config(value="concurrent-lifespans-per-task")
    @ConfigDescription(value="Experimental: Default number of lifespans that run in parallel on each task when grouped execution is enabled")
    public FeaturesConfig setConcurrentLifespansPerTask(int concurrentLifespansPerTask) {
        this.concurrentLifespansPerTask = concurrentLifespansPerTask;
        return this;
    }

    public boolean isColocatedJoinsEnabled() {
        return this.colocatedJoinsEnabled;
    }

    @Config(value="colocated-joins-enabled")
    @ConfigDescription(value="Experimental: Use a colocated join when possible")
    public FeaturesConfig setColocatedJoinsEnabled(boolean colocatedJoinsEnabled) {
        this.colocatedJoinsEnabled = colocatedJoinsEnabled;
        return this;
    }

    public boolean isSpatialJoinsEnabled() {
        return this.spatialJoinsEnabled;
    }

    @Config(value="spatial-joins-enabled")
    @ConfigDescription(value="Use spatial index for spatial joins when possible")
    public FeaturesConfig setSpatialJoinsEnabled(boolean spatialJoinsEnabled) {
        this.spatialJoinsEnabled = spatialJoinsEnabled;
        return this;
    }

    @Config(value="fast-inequality-joins")
    @ConfigDescription(value="Use faster handling of inequality joins if it is possible")
    public FeaturesConfig setFastInequalityJoins(boolean fastInequalityJoins) {
        this.fastInequalityJoins = fastInequalityJoins;
        return this;
    }

    public boolean isFastInequalityJoins() {
        return this.fastInequalityJoins;
    }

    public JoinReorderingStrategy getJoinReorderingStrategy() {
        return this.joinReorderingStrategy;
    }

    @Config(value="optimizer.join-reordering-strategy")
    @ConfigDescription(value="The strategy to use for reordering joins")
    public FeaturesConfig setJoinReorderingStrategy(JoinReorderingStrategy joinReorderingStrategy) {
        this.joinReorderingStrategy = joinReorderingStrategy;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getMaxReorderedJoins() {
        return this.maxReorderedJoins;
    }

    @Config(value="optimizer.max-reordered-joins")
    @ConfigDescription(value="The maximum number of tables to reorder in cost-based join reordering")
    public FeaturesConfig setMaxReorderedJoins(int maxReorderedJoins) {
        this.maxReorderedJoins = maxReorderedJoins;
        return this;
    }

    public boolean isRedistributeWrites() {
        return this.redistributeWrites;
    }

    @Config(value="redistribute-writes")
    public FeaturesConfig setRedistributeWrites(boolean redistributeWrites) {
        this.redistributeWrites = redistributeWrites;
        return this;
    }

    public boolean isUsePreferredWritePartitioning() {
        return this.usePreferredWritePartitioning;
    }

    @Config(value="use-preferred-write-partitioning")
    public FeaturesConfig setUsePreferredWritePartitioning(boolean usePreferredWritePartitioning) {
        this.usePreferredWritePartitioning = usePreferredWritePartitioning;
        return this;
    }

    public boolean isScaleWriters() {
        return this.scaleWriters;
    }

    @Config(value="scale-writers")
    public FeaturesConfig setScaleWriters(boolean scaleWriters) {
        this.scaleWriters = scaleWriters;
        return this;
    }

    @NotNull
    public DataSize getWriterMinSize() {
        return this.writerMinSize;
    }

    @Config(value="writer-min-size")
    @ConfigDescription(value="Target minimum size of writer output when scaling writers")
    public FeaturesConfig setWriterMinSize(DataSize writerMinSize) {
        this.writerMinSize = writerMinSize;
        return this;
    }

    public boolean isOptimizeMetadataQueries() {
        return this.optimizeMetadataQueries;
    }

    @Config(value="optimizer.optimize-metadata-queries")
    public FeaturesConfig setOptimizeMetadataQueries(boolean optimizeMetadataQueries) {
        this.optimizeMetadataQueries = optimizeMetadataQueries;
        return this;
    }

    public boolean isUseMarkDistinct() {
        return this.useMarkDistinct;
    }

    @Config(value="optimizer.use-mark-distinct")
    public FeaturesConfig setUseMarkDistinct(boolean value) {
        this.useMarkDistinct = value;
        return this;
    }

    public boolean isPreferPartialAggregation() {
        return this.preferPartialAggregation;
    }

    @Config(value="optimizer.prefer-partial-aggregation")
    public FeaturesConfig setPreferPartialAggregation(boolean value) {
        this.preferPartialAggregation = value;
        return this;
    }

    public boolean isOptimizeTopNRowNumber() {
        return this.optimizeTopNRowNumber;
    }

    @Config(value="optimizer.optimize-top-n-row-number")
    public FeaturesConfig setOptimizeTopNRowNumber(boolean optimizeTopNRowNumber) {
        this.optimizeTopNRowNumber = optimizeTopNRowNumber;
        return this;
    }

    public boolean isOptimizeHashGeneration() {
        return this.optimizeHashGeneration;
    }

    @Config(value="optimizer.optimize-hash-generation")
    public FeaturesConfig setOptimizeHashGeneration(boolean optimizeHashGeneration) {
        this.optimizeHashGeneration = optimizeHashGeneration;
        return this;
    }

    public boolean isPushTableWriteThroughUnion() {
        return this.pushTableWriteThroughUnion;
    }

    @Config(value="optimizer.push-table-write-through-union")
    public FeaturesConfig setPushTableWriteThroughUnion(boolean pushTableWriteThroughUnion) {
        this.pushTableWriteThroughUnion = pushTableWriteThroughUnion;
        return this;
    }

    public boolean isDictionaryAggregation() {
        return this.dictionaryAggregation;
    }

    @Config(value="optimizer.dictionary-aggregation")
    public FeaturesConfig setDictionaryAggregation(boolean dictionaryAggregation) {
        this.dictionaryAggregation = dictionaryAggregation;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getRe2JDfaStatesLimit() {
        return this.re2JDfaStatesLimit;
    }

    @Config(value="re2j.dfa-states-limit")
    public FeaturesConfig setRe2JDfaStatesLimit(int re2JDfaStatesLimit) {
        this.re2JDfaStatesLimit = re2JDfaStatesLimit;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getRe2JDfaRetries() {
        return this.re2JDfaRetries;
    }

    @Config(value="re2j.dfa-retries")
    public FeaturesConfig setRe2JDfaRetries(int re2JDfaRetries) {
        this.re2JDfaRetries = re2JDfaRetries;
        return this;
    }

    public RegexLibrary getRegexLibrary() {
        return this.regexLibrary;
    }

    @Config(value="regex-library")
    public FeaturesConfig setRegexLibrary(RegexLibrary regexLibrary) {
        this.regexLibrary = regexLibrary;
        return this;
    }

    public boolean isSpillEnabled() {
        return this.spillEnabled;
    }

    @Config(value="spill-enabled")
    @LegacyConfig(value={"experimental.spill-enabled"})
    public FeaturesConfig setSpillEnabled(boolean spillEnabled) {
        this.spillEnabled = spillEnabled;
        return this;
    }

    public boolean isSpillOrderBy() {
        return this.spillOrderBy;
    }

    @Config(value="spill-order-by")
    @LegacyConfig(value={"experimental.spill-order-by"})
    public FeaturesConfig setSpillOrderBy(boolean spillOrderBy) {
        this.spillOrderBy = spillOrderBy;
        return this;
    }

    public boolean isSpillWindowOperator() {
        return this.spillWindowOperator;
    }

    @Config(value="spill-window-operator")
    @LegacyConfig(value={"experimental.spill-window-operator"})
    public FeaturesConfig setSpillWindowOperator(boolean spillWindowOperator) {
        this.spillWindowOperator = spillWindowOperator;
        return this;
    }

    public boolean isIterativeOptimizerEnabled() {
        return this.iterativeOptimizerEnabled;
    }

    @Config(value="iterative-optimizer-enabled")
    @LegacyConfig(value={"experimental.iterative-optimizer-enabled"})
    public FeaturesConfig setIterativeOptimizerEnabled(boolean value) {
        this.iterativeOptimizerEnabled = value;
        return this;
    }

    public Duration getIterativeOptimizerTimeout() {
        return this.iterativeOptimizerTimeout;
    }

    @Config(value="iterative-optimizer-timeout")
    @LegacyConfig(value={"experimental.iterative-optimizer-timeout"})
    public FeaturesConfig setIterativeOptimizerTimeout(Duration timeout) {
        this.iterativeOptimizerTimeout = timeout;
        return this;
    }

    public boolean isEnableStatsCalculator() {
        return this.enableStatsCalculator;
    }

    @Config(value="enable-stats-calculator")
    @LegacyConfig(value={"experimental.enable-stats-calculator"})
    public FeaturesConfig setEnableStatsCalculator(boolean enableStatsCalculator) {
        this.enableStatsCalculator = enableStatsCalculator;
        return this;
    }

    public boolean isCollectPlanStatisticsForAllQueries() {
        return this.collectPlanStatisticsForAllQueries;
    }

    @Config(value="collect-plan-statistics-for-all-queries")
    @ConfigDescription(value="Collect plan statistics for non-EXPLAIN queries")
    public FeaturesConfig setCollectPlanStatisticsForAllQueries(boolean collectPlanStatisticsForAllQueries) {
        this.collectPlanStatisticsForAllQueries = collectPlanStatisticsForAllQueries;
        return this;
    }

    public boolean isIgnoreStatsCalculatorFailures() {
        return this.ignoreStatsCalculatorFailures;
    }

    @Config(value="optimizer.ignore-stats-calculator-failures")
    @ConfigDescription(value="Ignore statistics calculator failures")
    public FeaturesConfig setIgnoreStatsCalculatorFailures(boolean ignoreStatsCalculatorFailures) {
        this.ignoreStatsCalculatorFailures = ignoreStatsCalculatorFailures;
        return this;
    }

    @Config(value="optimizer.default-filter-factor-enabled")
    public FeaturesConfig setDefaultFilterFactorEnabled(boolean defaultFilterFactorEnabled) {
        this.defaultFilterFactorEnabled = defaultFilterFactorEnabled;
        return this;
    }

    public boolean isDefaultFilterFactorEnabled() {
        return this.defaultFilterFactorEnabled;
    }

    public boolean isEnableForcedExchangeBelowGroupId() {
        return this.enableForcedExchangeBelowGroupId;
    }

    @Config(value="enable-forced-exchange-below-group-id")
    public FeaturesConfig setEnableForcedExchangeBelowGroupId(boolean enableForcedExchangeBelowGroupId) {
        this.enableForcedExchangeBelowGroupId = enableForcedExchangeBelowGroupId;
        return this;
    }

    public DataSize getAggregationOperatorUnspillMemoryLimit() {
        return this.aggregationOperatorUnspillMemoryLimit;
    }

    @Config(value="aggregation-operator-unspill-memory-limit")
    @LegacyConfig(value={"experimental.aggregation-operator-unspill-memory-limit"})
    public FeaturesConfig setAggregationOperatorUnspillMemoryLimit(DataSize aggregationOperatorUnspillMemoryLimit) {
        this.aggregationOperatorUnspillMemoryLimit = aggregationOperatorUnspillMemoryLimit;
        return this;
    }

    public List<Path> getSpillerSpillPaths() {
        return this.spillerSpillPaths;
    }

    @Config(value="spiller-spill-path")
    @LegacyConfig(value={"experimental.spiller-spill-path"})
    public FeaturesConfig setSpillerSpillPaths(String spillPaths) {
        ImmutableList spillPathsSplit = ImmutableList.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)spillPaths));
        this.spillerSpillPaths = (List)spillPathsSplit.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSpillerThreads() {
        return this.spillerThreads;
    }

    @Config(value="spiller-threads")
    @LegacyConfig(value={"experimental.spiller-threads"})
    public FeaturesConfig setSpillerThreads(int spillerThreads) {
        this.spillerThreads = spillerThreads;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingThreshold() {
        return this.memoryRevokingThreshold;
    }

    @Config(value="memory-revoking-threshold")
    @LegacyConfig(value={"experimental.memory-revoking-threshold"})
    @ConfigDescription(value="Revoke memory when memory pool is filled over threshold")
    public FeaturesConfig setMemoryRevokingThreshold(double memoryRevokingThreshold) {
        this.memoryRevokingThreshold = memoryRevokingThreshold;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingTarget() {
        return this.memoryRevokingTarget;
    }

    @Config(value="memory-revoking-target")
    @LegacyConfig(value={"experimental.memory-revoking-target"})
    @ConfigDescription(value="When revoking memory, try to revoke so much that pool is filled below target at the end")
    public FeaturesConfig setMemoryRevokingTarget(double memoryRevokingTarget) {
        this.memoryRevokingTarget = memoryRevokingTarget;
        return this;
    }

    public double getSpillMaxUsedSpaceThreshold() {
        return this.spillMaxUsedSpaceThreshold;
    }

    @Config(value="spiller-max-used-space-threshold")
    @LegacyConfig(value={"experimental.spiller-max-used-space-threshold"})
    public FeaturesConfig setSpillMaxUsedSpaceThreshold(double spillMaxUsedSpaceThreshold) {
        this.spillMaxUsedSpaceThreshold = spillMaxUsedSpaceThreshold;
        return this;
    }

    public boolean isEnableDynamicFiltering() {
        return this.enableDynamicFiltering;
    }

    @Config(value="enable-dynamic-filtering")
    @LegacyConfig(value={"experimental.enable-dynamic-filtering"})
    public FeaturesConfig setEnableDynamicFiltering(boolean value) {
        this.enableDynamicFiltering = value;
        return this;
    }

    public int getDynamicFilteringMaxPerDriverRowCount() {
        return this.dynamicFilteringMaxPerDriverRowCount;
    }

    @Config(value="dynamic-filtering-max-per-driver-row-count")
    @LegacyConfig(value={"experimental.dynamic-filtering-max-per-driver-row-count"})
    public FeaturesConfig setDynamicFilteringMaxPerDriverRowCount(int dynamicFilteringMaxPerDriverRowCount) {
        this.dynamicFilteringMaxPerDriverRowCount = dynamicFilteringMaxPerDriverRowCount;
        return this;
    }

    @MaxDataSize(value="1MB")
    public @MaxDataSize(value="1MB") DataSize getDynamicFilteringMaxPerDriverSize() {
        return this.dynamicFilteringMaxPerDriverSize;
    }

    @Config(value="dynamic-filtering-max-per-driver-size")
    @LegacyConfig(value={"experimental.dynamic-filtering-max-per-driver-size"})
    public FeaturesConfig setDynamicFilteringMaxPerDriverSize(DataSize dynamicFilteringMaxPerDriverSize) {
        this.dynamicFilteringMaxPerDriverSize = dynamicFilteringMaxPerDriverSize;
        return this;
    }

    public boolean isOptimizeMixedDistinctAggregations() {
        return this.optimizeMixedDistinctAggregations;
    }

    @Config(value="optimizer.optimize-mixed-distinct-aggregations")
    public FeaturesConfig setOptimizeMixedDistinctAggregations(boolean value) {
        this.optimizeMixedDistinctAggregations = value;
        return this;
    }

    public boolean isUnwrapCasts() {
        return this.unwrapCasts;
    }

    @Config(value="optimizer.unwrap-casts")
    public FeaturesConfig setUnwrapCasts(boolean unwrapCasts) {
        this.unwrapCasts = unwrapCasts;
        return this;
    }

    public boolean isExchangeCompressionEnabled() {
        return this.exchangeCompressionEnabled;
    }

    @Config(value="exchange.compression-enabled")
    public FeaturesConfig setExchangeCompressionEnabled(boolean exchangeCompressionEnabled) {
        this.exchangeCompressionEnabled = exchangeCompressionEnabled;
        return this;
    }

    public DataIntegrityVerification getExchangeDataIntegrityVerification() {
        return this.exchangeDataIntegrityVerification;
    }

    @Config(value="exchange.data-integrity-verification")
    public FeaturesConfig setExchangeDataIntegrityVerification(DataIntegrityVerification exchangeDataIntegrityVerification) {
        this.exchangeDataIntegrityVerification = exchangeDataIntegrityVerification;
        return this;
    }

    public boolean isEnableIntermediateAggregations() {
        return this.enableIntermediateAggregations;
    }

    @Config(value="optimizer.enable-intermediate-aggregations")
    public FeaturesConfig setEnableIntermediateAggregations(boolean enableIntermediateAggregations) {
        this.enableIntermediateAggregations = enableIntermediateAggregations;
        return this;
    }

    public boolean isPushAggregationThroughOuterJoin() {
        return this.pushAggregationThroughOuterJoin;
    }

    @Config(value="optimizer.push-aggregation-through-outer-join")
    @LegacyConfig(value={"optimizer.push-aggregation-through-join"})
    public FeaturesConfig setPushAggregationThroughOuterJoin(boolean pushAggregationThroughOuterJoin) {
        this.pushAggregationThroughOuterJoin = pushAggregationThroughOuterJoin;
        return this;
    }

    public boolean isPushPartialAggregationThoughJoin() {
        return this.pushPartialAggregationThoughJoin;
    }

    @Config(value="optimizer.push-partial-aggregation-through-join")
    public FeaturesConfig setPushPartialAggregationThoughJoin(boolean pushPartialAggregationThoughJoin) {
        this.pushPartialAggregationThoughJoin = pushPartialAggregationThoughJoin;
        return this;
    }

    public boolean isParseDecimalLiteralsAsDouble() {
        return this.parseDecimalLiteralsAsDouble;
    }

    @Config(value="parse-decimal-literals-as-double")
    public FeaturesConfig setParseDecimalLiteralsAsDouble(boolean parseDecimalLiteralsAsDouble) {
        this.parseDecimalLiteralsAsDouble = parseDecimalLiteralsAsDouble;
        return this;
    }

    public boolean isForceSingleNodeOutput() {
        return this.forceSingleNodeOutput;
    }

    @Config(value="optimizer.force-single-node-output")
    public FeaturesConfig setForceSingleNodeOutput(boolean value) {
        this.forceSingleNodeOutput = value;
        return this;
    }

    public boolean isPagesIndexEagerCompactionEnabled() {
        return this.pagesIndexEagerCompactionEnabled;
    }

    @Config(value="pages-index.eager-compaction-enabled")
    public FeaturesConfig setPagesIndexEagerCompactionEnabled(boolean pagesIndexEagerCompactionEnabled) {
        this.pagesIndexEagerCompactionEnabled = pagesIndexEagerCompactionEnabled;
        return this;
    }

    @MaxDataSize(value="1MB")
    public @MaxDataSize(value="1MB") DataSize getFilterAndProjectMinOutputPageSize() {
        return this.filterAndProjectMinOutputPageSize;
    }

    @Config(value="filter-and-project-min-output-page-size")
    @LegacyConfig(value={"experimental.filter-and-project-min-output-page-size"})
    public FeaturesConfig setFilterAndProjectMinOutputPageSize(DataSize filterAndProjectMinOutputPageSize) {
        this.filterAndProjectMinOutputPageSize = filterAndProjectMinOutputPageSize;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getFilterAndProjectMinOutputPageRowCount() {
        return this.filterAndProjectMinOutputPageRowCount;
    }

    @Config(value="filter-and-project-min-output-page-row-count")
    @LegacyConfig(value={"experimental.filter-and-project-min-output-page-row-count"})
    public FeaturesConfig setFilterAndProjectMinOutputPageRowCount(int filterAndProjectMinOutputPageRowCount) {
        this.filterAndProjectMinOutputPageRowCount = filterAndProjectMinOutputPageRowCount;
        return this;
    }

    @Config(value="histogram.implementation")
    public FeaturesConfig setHistogramGroupImplementation(HistogramGroupImplementation groupByMode) {
        this.histogramGroupImplementation = groupByMode;
        return this;
    }

    public HistogramGroupImplementation getHistogramGroupImplementation() {
        return this.histogramGroupImplementation;
    }

    public ArrayAggGroupImplementation getArrayAggGroupImplementation() {
        return this.arrayAggGroupImplementation;
    }

    @Config(value="arrayagg.implementation")
    public FeaturesConfig setArrayAggGroupImplementation(ArrayAggGroupImplementation groupByMode) {
        this.arrayAggGroupImplementation = groupByMode;
        return this;
    }

    public MultimapAggGroupImplementation getMultimapAggGroupImplementation() {
        return this.multimapAggGroupImplementation;
    }

    @Config(value="multimapagg.implementation")
    public FeaturesConfig setMultimapAggGroupImplementation(MultimapAggGroupImplementation groupByMode) {
        this.multimapAggGroupImplementation = groupByMode;
        return this;
    }

    public boolean isDistributedSortEnabled() {
        return this.distributedSort;
    }

    @Config(value="distributed-sort")
    public FeaturesConfig setDistributedSortEnabled(boolean enabled) {
        this.distributedSort = enabled;
        return this;
    }

    public int getMaxGroupingSets() {
        return this.maxGroupingSets;
    }

    @Config(value="analyzer.max-grouping-sets")
    public FeaturesConfig setMaxGroupingSets(int maxGroupingSets) {
        this.maxGroupingSets = maxGroupingSets;
        return this;
    }

    public boolean isLateMaterializationEnabled() {
        return this.lateMaterializationEnabled;
    }

    @Config(value="experimental.late-materialization.enabled")
    @LegacyConfig(value={"experimental.work-processor-pipelines"})
    public FeaturesConfig setLateMaterializationEnabled(boolean lateMaterializationEnabled) {
        this.lateMaterializationEnabled = lateMaterializationEnabled;
        return this;
    }

    public boolean isSkipRedundantSort() {
        return this.skipRedundantSort;
    }

    @Config(value="optimizer.skip-redundant-sort")
    public FeaturesConfig setSkipRedundantSort(boolean value) {
        this.skipRedundantSort = value;
        return this;
    }

    public boolean isPredicatePushdownUseTableProperties() {
        return this.predicatePushdownUseTableProperties;
    }

    @Config(value="optimizer.predicate-pushdown-use-table-properties")
    public FeaturesConfig setPredicatePushdownUseTableProperties(boolean predicatePushdownUseTableProperties) {
        this.predicatePushdownUseTableProperties = predicatePushdownUseTableProperties;
        return this;
    }

    public boolean isIgnoreDownstreamPreferences() {
        return this.ignoreDownstreamPreferences;
    }

    @Config(value="optimizer.ignore-downstream-preferences")
    public FeaturesConfig setIgnoreDownstreamPreferences(boolean ignoreDownstreamPreferences) {
        this.ignoreDownstreamPreferences = ignoreDownstreamPreferences;
        return this;
    }

    public static enum DataIntegrityVerification {
        NONE,
        ABORT,
        RETRY;

    }

    public static enum JoinDistributionType {
        BROADCAST,
        PARTITIONED,
        AUTOMATIC;


        public boolean canPartition() {
            return this == PARTITIONED || this == AUTOMATIC;
        }

        public boolean canReplicate() {
            return this == BROADCAST || this == AUTOMATIC;
        }
    }

    public static enum JoinReorderingStrategy {
        NONE,
        ELIMINATE_CROSS_JOINS,
        AUTOMATIC;

    }
}

