/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WindowNode
extends PlanNode {
    private final PlanNode source;
    private final Set<Symbol> prePartitionedInputs;
    private final Specification specification;
    private final int preSortedOrderPrefix;
    private final Map<Symbol, Function> windowFunctions;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public WindowNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="specification") Specification specification, @JsonProperty(value="windowFunctions") Map<Symbol, Function> windowFunctions, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="prePartitionedInputs") Set<Symbol> prePartitionedInputs, @JsonProperty(value="preSortedOrderPrefix") int preSortedOrderPrefix) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Objects.requireNonNull(windowFunctions, "windowFunctions is null");
        Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        Preconditions.checkArgument((boolean)specification.getPartitionBy().containsAll(prePartitionedInputs), (Object)"prePartitionedInputs must be contained in partitionBy");
        Optional<OrderingScheme> orderingScheme = specification.getOrderingScheme();
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || orderingScheme.isPresent() && preSortedOrderPrefix <= orderingScheme.get().getOrderBy().size() ? 1 : 0) != 0, (Object)"Cannot have sorted more symbols than those requested");
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || ImmutableSet.copyOf(prePartitionedInputs).equals((Object)ImmutableSet.copyOf(specification.getPartitionBy())) ? 1 : 0) != 0, (Object)"preSortedOrderPrefix can only be greater than zero if all partition symbols are pre-partitioned");
        this.source = source;
        this.prePartitionedInputs = ImmutableSet.copyOf(prePartitionedInputs);
        this.specification = specification;
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.hashSymbol = hashSymbol;
        this.preSortedOrderPrefix = preSortedOrderPrefix;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), this.windowFunctions.keySet()));
    }

    public Set<Symbol> getCreatedSymbols() {
        return ImmutableSet.copyOf(this.windowFunctions.keySet());
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Specification getSpecification() {
        return this.specification;
    }

    public List<Symbol> getPartitionBy() {
        return this.specification.getPartitionBy();
    }

    public Optional<OrderingScheme> getOrderingScheme() {
        return this.specification.orderingScheme;
    }

    @JsonProperty
    public Map<Symbol, Function> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<Frame> getFrames() {
        return (List)this.windowFunctions.values().stream().map(Function::getFrame).collect(ImmutableList.toImmutableList());
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty
    public Set<Symbol> getPrePartitionedInputs() {
        return this.prePartitionedInputs;
    }

    @JsonProperty
    public int getPreSortedOrderPrefix() {
        return this.preSortedOrderPrefix;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new WindowNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.specification, this.windowFunctions, this.hashSymbol, this.prePartitionedInputs, this.preSortedOrderPrefix);
    }

    @Immutable
    public static final class Function {
        private final ResolvedFunction resolvedFunction;
        private final List<Expression> arguments;
        private final Frame frame;
        private final boolean ignoreNulls;

        @JsonCreator
        public Function(@JsonProperty(value="resolvedFunction") ResolvedFunction resolvedFunction, @JsonProperty(value="arguments") List<Expression> arguments, @JsonProperty(value="frame") Frame frame, @JsonProperty(value="ignoreNulls") boolean ignoreNulls) {
            this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
            this.arguments = Objects.requireNonNull(arguments, "arguments is null");
            this.frame = Objects.requireNonNull(frame, "frame is null");
            this.ignoreNulls = ignoreNulls;
        }

        @JsonProperty
        public ResolvedFunction getResolvedFunction() {
            return this.resolvedFunction;
        }

        @JsonProperty
        public List<Expression> getArguments() {
            return this.arguments;
        }

        @JsonProperty
        public Frame getFrame() {
            return this.frame;
        }

        @JsonProperty
        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }

        public int hashCode() {
            return Objects.hash(this.resolvedFunction, this.arguments, this.frame, this.ignoreNulls);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Function other = (Function)obj;
            return Objects.equals(this.resolvedFunction, other.resolvedFunction) && Objects.equals(this.arguments, other.arguments) && Objects.equals(this.frame, other.frame) && this.ignoreNulls == other.ignoreNulls;
        }
    }

    @Immutable
    public static class Frame {
        private final WindowFrame.Type type;
        private final FrameBound.Type startType;
        private final Optional<Symbol> startValue;
        private final FrameBound.Type endType;
        private final Optional<Symbol> endValue;
        private final Optional<Expression> originalStartValue;
        private final Optional<Expression> originalEndValue;

        @JsonCreator
        public Frame(@JsonProperty(value="type") WindowFrame.Type type, @JsonProperty(value="startType") FrameBound.Type startType, @JsonProperty(value="startValue") Optional<Symbol> startValue, @JsonProperty(value="endType") FrameBound.Type endType, @JsonProperty(value="endValue") Optional<Symbol> endValue, @JsonProperty(value="originalStartValue") Optional<Expression> originalStartValue, @JsonProperty(value="originalEndValue") Optional<Expression> originalEndValue) {
            this.startType = Objects.requireNonNull(startType, "startType is null");
            this.startValue = Objects.requireNonNull(startValue, "startValue is null");
            this.endType = Objects.requireNonNull(endType, "endType is null");
            this.endValue = Objects.requireNonNull(endValue, "endValue is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.originalStartValue = Objects.requireNonNull(originalStartValue, "originalStartValue is null");
            this.originalEndValue = Objects.requireNonNull(originalEndValue, "originalEndValue is null");
            if (startValue.isPresent()) {
                Preconditions.checkArgument((boolean)originalStartValue.isPresent(), (Object)"originalStartValue must be present if startValue is present");
            }
            if (endValue.isPresent()) {
                Preconditions.checkArgument((boolean)originalEndValue.isPresent(), (Object)"originalEndValue must be present if endValue is present");
            }
        }

        @JsonProperty
        public WindowFrame.Type getType() {
            return this.type;
        }

        @JsonProperty
        public FrameBound.Type getStartType() {
            return this.startType;
        }

        @JsonProperty
        public Optional<Symbol> getStartValue() {
            return this.startValue;
        }

        @JsonProperty
        public FrameBound.Type getEndType() {
            return this.endType;
        }

        @JsonProperty
        public Optional<Symbol> getEndValue() {
            return this.endValue;
        }

        @JsonProperty
        public Optional<Expression> getOriginalStartValue() {
            return this.originalStartValue;
        }

        @JsonProperty
        public Optional<Expression> getOriginalEndValue() {
            return this.originalEndValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Frame frame = (Frame)o;
            return this.type == frame.type && this.startType == frame.startType && Objects.equals(this.startValue, frame.startValue) && this.endType == frame.endType && Objects.equals(this.endValue, frame.endValue);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.startType, this.startValue, this.endType, this.endValue, this.originalStartValue, this.originalEndValue);
        }
    }

    @Immutable
    public static class Specification {
        private final List<Symbol> partitionBy;
        private final Optional<OrderingScheme> orderingScheme;

        @JsonCreator
        public Specification(@JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme) {
            Objects.requireNonNull(partitionBy, "partitionBy is null");
            Objects.requireNonNull(orderingScheme, "orderingScheme is null");
            this.partitionBy = ImmutableList.copyOf(partitionBy);
            this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        }

        @JsonProperty
        public List<Symbol> getPartitionBy() {
            return this.partitionBy;
        }

        @JsonProperty
        public Optional<OrderingScheme> getOrderingScheme() {
            return this.orderingScheme;
        }

        public int hashCode() {
            return Objects.hash(this.partitionBy, this.orderingScheme);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Specification other = (Specification)obj;
            return Objects.equals(this.partitionBy, other.partitionBy) && Objects.equals(this.orderingScheme, other.orderingScheme);
        }
    }
}

