/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class SpatialJoinUtils {
    public static final String ST_CONTAINS = "st_contains";
    public static final String ST_WITHIN = "st_within";
    public static final String ST_INTERSECTS = "st_intersects";
    public static final String ST_DISTANCE = "st_distance";

    private SpatialJoinUtils() {
    }

    public static List<FunctionCall> extractSupportedSpatialFunctions(Expression filterExpression) {
        return (List)ExpressionUtils.extractConjuncts(filterExpression).stream().filter(FunctionCall.class::isInstance).map(FunctionCall.class::cast).filter(SpatialJoinUtils::isSupportedSpatialFunction).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialFunction(FunctionCall functionCall) {
        String functionName = SpatialJoinUtils.getFunctionName(functionCall);
        return functionName.equalsIgnoreCase(ST_CONTAINS) || functionName.equalsIgnoreCase(ST_WITHIN) || functionName.equalsIgnoreCase(ST_INTERSECTS);
    }

    public static List<ComparisonExpression> extractSupportedSpatialComparisons(Expression filterExpression) {
        return (List)ExpressionUtils.extractConjuncts(filterExpression).stream().filter(ComparisonExpression.class::isInstance).map(ComparisonExpression.class::cast).filter(SpatialJoinUtils::isSupportedSpatialComparison).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialComparison(ComparisonExpression expression) {
        switch (expression.getOperator()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance(expression.getLeft());
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance(expression.getRight());
            }
        }
        return false;
    }

    private static boolean isSTDistance(Expression expression) {
        if (expression instanceof FunctionCall) {
            return SpatialJoinUtils.getFunctionName((FunctionCall)expression).equalsIgnoreCase(ST_DISTANCE);
        }
        return false;
    }

    private static String getFunctionName(FunctionCall functionCall) {
        return ResolvedFunction.fromQualifiedName(functionCall.getName()).map(ResolvedFunction::getSignature).map(Signature::getName).orElse(functionCall.getName().toString());
    }

    public static boolean isSpatialJoinFilter(PlanNode left, PlanNode right, Expression filterExpression) {
        List<FunctionCall> functionCalls = SpatialJoinUtils.extractSupportedSpatialFunctions(filterExpression);
        for (FunctionCall functionCall : functionCalls) {
            if (!SpatialJoinUtils.isSpatialJoinFilter(left, right, functionCall)) continue;
            return true;
        }
        List<ComparisonExpression> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filterExpression);
        for (ComparisonExpression spatialComparison : spatialComparisons) {
            Expression radius;
            if (spatialComparison.getOperator() != ComparisonExpression.Operator.LESS_THAN && spatialComparison.getOperator() != ComparisonExpression.Operator.LESS_THAN_OR_EQUAL || !((radius = spatialComparison.getRight()) instanceof Literal) && (!(radius instanceof SymbolReference) || !SpatialJoinUtils.getSymbolReferences(right.getOutputSymbols()).contains(radius)) || !SpatialJoinUtils.isSpatialJoinFilter(left, right, (FunctionCall)spatialComparison.getLeft())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpatialJoinFilter(PlanNode left, PlanNode right, FunctionCall spatialFunction) {
        List arguments = spatialFunction.getArguments();
        Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
        if (!(arguments.get(0) instanceof SymbolReference) || !(arguments.get(1) instanceof SymbolReference)) {
            return false;
        }
        SymbolReference firstSymbol = (SymbolReference)arguments.get(0);
        SymbolReference secondSymbol = (SymbolReference)arguments.get(1);
        Set<SymbolReference> probeSymbols = SpatialJoinUtils.getSymbolReferences(left.getOutputSymbols());
        Set<SymbolReference> buildSymbols = SpatialJoinUtils.getSymbolReferences(right.getOutputSymbols());
        if (probeSymbols.contains(firstSymbol) && buildSymbols.contains(secondSymbol)) {
            return true;
        }
        return probeSymbols.contains(secondSymbol) && buildSymbols.contains(firstSymbol);
    }

    private static Set<SymbolReference> getSymbolReferences(Collection<Symbol> symbols) {
        return (Set)symbols.stream().map(Symbol::toSymbolReference).collect(ImmutableSet.toImmutableSet());
    }
}

