/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaInfoWithVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.ObjectMapperFactory;

public final class SchemaUtils {
    private static final byte[] KEY_VALUE_SCHEMA_IS_PRIMITIVE = new byte[0];
    private static final String KEY_VALUE_SCHEMA_NULL_STRING = "\"\"";
    private static final Map<SchemaType, List<Class>> SCHEMA_TYPE_CLASSES = new HashMap<SchemaType, List<Class>>();
    private static final Map<Class<?>, SchemaType> JAVA_CLASS_SCHEMA_TYPES = new HashMap();
    private static final SchemaPropertiesSerializer SCHEMA_PROPERTIES_SERIALIZER;
    private static final SchemaPropertiesDeserializer SCHEMA_PROPERTIES_DESERIALIZER;
    private static final SchemaInfoToStringAdapter SCHEMAINFO_ADAPTER;

    private SchemaUtils() {
    }

    public static void validateFieldSchema(String name, SchemaType type, Object val) {
        if (null == val) {
            return;
        }
        List<Class> expectedClasses = SCHEMA_TYPE_CLASSES.get(type);
        if (null == expectedClasses) {
            throw new RuntimeException("Invalid Java object for schema type " + type + " : " + val.getClass() + " for field : \"" + name + "\"");
        }
        boolean foundMatch = false;
        for (Class expectedCls : expectedClasses) {
            if (!expectedCls.isInstance(val)) continue;
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            throw new RuntimeException("Invalid Java object for schema type " + type + " : " + val.getClass() + " for field : \"" + name + "\"");
        }
        switch (type) {
            case INT8: 
            case INT16: 
            case PROTOBUF: 
            case AVRO: 
            case AUTO_CONSUME: 
            case AUTO_PUBLISH: 
            case AUTO: 
            case KEY_VALUE: 
            case JSON: 
            case NONE: {
                throw new RuntimeException("Currently " + type.name() + " is not supported");
            }
        }
    }

    public static Object toAvroObject(Object value) {
        if (value != null) {
            if (value instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)value;
                byte[] bytes = new byte[bb.remaining()];
                bb.duplicate().get(bytes);
                return bytes;
            }
            if (value instanceof ByteBuf) {
                return ByteBufUtil.getBytes((ByteBuf)((ByteBuf)value));
            }
            return value;
        }
        return null;
    }

    public static String getStringSchemaVersion(byte[] schemaVersionBytes) {
        if (null == schemaVersionBytes) {
            return "NULL";
        }
        if (schemaVersionBytes.length == 8 || schemaVersionBytes.length == 64) {
            ByteBuffer bb = ByteBuffer.wrap(schemaVersionBytes);
            return String.valueOf(bb.getLong());
        }
        if (schemaVersionBytes.length == 0) {
            return "EMPTY";
        }
        return Base64.getEncoder().encodeToString(schemaVersionBytes);
    }

    public static String jsonifySchemaInfo(SchemaInfo schemaInfo) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToStringAdapter(schemaInfo)).registerTypeHierarchyAdapter(Map.class, (Object)SCHEMA_PROPERTIES_SERIALIZER);
        return gsonBuilder.create().toJson((Object)schemaInfo);
    }

    public static String jsonifySchemaInfoWithVersion(SchemaInfoWithVersion schemaInfoWithVersion) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(SchemaInfo.class, (Object)SCHEMAINFO_ADAPTER).registerTypeHierarchyAdapter(Map.class, (Object)SCHEMA_PROPERTIES_SERIALIZER);
        return gsonBuilder.create().toJson((Object)schemaInfoWithVersion);
    }

    public static JsonElement toJsonElement(String str) {
        try {
            return JsonParser.parseString((String)str).getAsJsonObject();
        }
        catch (IllegalStateException e) {
            return new JsonPrimitive(str);
        }
    }

    public static String jsonifyKeyValueSchemaInfo(KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeHierarchyAdapter(SchemaInfo.class, (Object)SCHEMAINFO_ADAPTER).registerTypeHierarchyAdapter(Map.class, (Object)SCHEMA_PROPERTIES_SERIALIZER);
        return gsonBuilder.create().toJson(kvSchemaInfo);
    }

    public static String convertKeyValueSchemaInfoDataToString(KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.create();
        KeyValue keyValue = new KeyValue((Object)(SchemaType.isPrimitiveType((SchemaType)((SchemaInfo)kvSchemaInfo.getKey()).getType()) ? "" : objectMapper.readTree(((SchemaInfo)kvSchemaInfo.getKey()).getSchema())), (Object)(SchemaType.isPrimitiveType((SchemaType)((SchemaInfo)kvSchemaInfo.getValue()).getType()) ? "" : objectMapper.readTree(((SchemaInfo)kvSchemaInfo.getValue()).getSchema())));
        return objectMapper.writeValueAsString((Object)keyValue);
    }

    private static byte[] getKeyOrValueSchemaBytes(JsonElement jsonElement) {
        return KEY_VALUE_SCHEMA_NULL_STRING.equals(jsonElement.toString()) ? KEY_VALUE_SCHEMA_IS_PRIMITIVE : jsonElement.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] convertKeyValueDataStringToSchemaInfoSchema(byte[] keyValueSchemaInfoDataJsonBytes) throws IOException {
        JsonObject jsonObject = (JsonObject)SchemaUtils.toJsonElement(new String(keyValueSchemaInfoDataJsonBytes, StandardCharsets.UTF_8));
        byte[] keyBytes = SchemaUtils.getKeyOrValueSchemaBytes(jsonObject.get("key"));
        byte[] valueBytes = SchemaUtils.getKeyOrValueSchemaBytes(jsonObject.get("value"));
        int dataLength = 4 + keyBytes.length + 4 + valueBytes.length;
        byte[] schema = new byte[dataLength];
        ByteBuf byteBuf = PulsarByteBufAllocator.DEFAULT.heapBuffer(dataLength);
        byteBuf.writeInt(keyBytes.length).writeBytes(keyBytes).writeInt(valueBytes.length).writeBytes(valueBytes);
        byteBuf.readBytes(schema);
        return schema;
    }

    public static String serializeSchemaProperties(Map<String, String> properties) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeHierarchyAdapter(Map.class, (Object)SCHEMA_PROPERTIES_SERIALIZER);
        return gsonBuilder.create().toJson(properties);
    }

    public static Map<String, String> deserializeSchemaProperties(String serializedProperties) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeHierarchyAdapter(Map.class, (Object)SCHEMA_PROPERTIES_DESERIALIZER);
        return (Map)gsonBuilder.create().fromJson(serializedProperties, Map.class);
    }

    static {
        SCHEMA_TYPE_CLASSES.put(SchemaType.INT8, Arrays.asList(Byte.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.INT16, Arrays.asList(Short.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.INT32, Arrays.asList(Integer.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.INT64, Arrays.asList(Long.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.FLOAT, Arrays.asList(Float.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.DOUBLE, Arrays.asList(Double.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.BOOLEAN, Arrays.asList(Boolean.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.STRING, Arrays.asList(String.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.BYTES, Arrays.asList(byte[].class, ByteBuffer.class, ByteBuf.class));
        SCHEMA_TYPE_CLASSES.forEach((type, classes) -> classes.forEach(clz -> JAVA_CLASS_SCHEMA_TYPES.put((Class<?>)clz, (SchemaType)type)));
        SCHEMA_PROPERTIES_SERIALIZER = new SchemaPropertiesSerializer();
        SCHEMA_PROPERTIES_DESERIALIZER = new SchemaPropertiesDeserializer();
        SCHEMAINFO_ADAPTER = new SchemaInfoToStringAdapter();
    }

    private static class ByteArrayToStringAdapter
    implements JsonSerializer<byte[]> {
        private final SchemaInfo schemaInfo;

        public ByteArrayToStringAdapter(SchemaInfo schemaInfo) {
            this.schemaInfo = schemaInfo;
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            String schemaDef = this.schemaInfo.getSchemaDefinition();
            SchemaType type = this.schemaInfo.getType();
            switch (type) {
                case PROTOBUF: 
                case AVRO: 
                case JSON: {
                    return SchemaUtils.toJsonElement(this.schemaInfo.getSchemaDefinition());
                }
                case KEY_VALUE: {
                    KeyValue schemaInfoKeyValue = DefaultImplementation.getDefaultImplementation().decodeKeyValueSchemaInfo(this.schemaInfo);
                    JsonObject obj = new JsonObject();
                    String keyJson = SchemaUtils.jsonifySchemaInfo((SchemaInfo)schemaInfoKeyValue.getKey());
                    String valueJson = SchemaUtils.jsonifySchemaInfo((SchemaInfo)schemaInfoKeyValue.getValue());
                    obj.add("key", SchemaUtils.toJsonElement(keyJson));
                    obj.add("value", SchemaUtils.toJsonElement(valueJson));
                    return obj;
                }
            }
            return new JsonPrimitive(schemaDef);
        }
    }

    private static class SchemaPropertiesSerializer
    implements JsonSerializer<Map<String, String>> {
        private SchemaPropertiesSerializer() {
        }

        public JsonElement serialize(Map<String, String> properties, Type type, JsonSerializationContext jsonSerializationContext) {
            TreeMap<String, String> sortedProperties = new TreeMap<String, String>();
            sortedProperties.putAll(properties);
            JsonObject object = new JsonObject();
            sortedProperties.forEach((key, value) -> object.add(key, (JsonElement)(value != null ? new JsonPrimitive(value) : null)));
            return object;
        }
    }

    private static class SchemaInfoToStringAdapter
    implements JsonSerializer<SchemaInfo> {
        private SchemaInfoToStringAdapter() {
        }

        public JsonElement serialize(SchemaInfo schemaInfo, Type type, JsonSerializationContext jsonSerializationContext) {
            return SchemaUtils.toJsonElement(SchemaUtils.jsonifySchemaInfo(schemaInfo));
        }
    }

    private static class SchemaPropertiesDeserializer
    implements JsonDeserializer<Map<String, String>> {
        private SchemaPropertiesDeserializer() {
        }

        public Map<String, String> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            TreeMap<String, String> sortedProperties = new TreeMap<String, String>();
            jsonElement.getAsJsonObject().entrySet().forEach(entry -> sortedProperties.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
            return sortedProperties;
        }
    }
}

