/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedHashSet;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.common.policies.data.ClusterData;

@ApiModel(value="ClusterData", description="The configuration data for a cluster")
public final class ClusterDataImpl
implements ClusterData,
Cloneable {
    @ApiModelProperty(name="serviceUrl", value="The HTTP rest service URL (for admin operations)", example="http://pulsar.example.com:8080")
    private String serviceUrl;
    @ApiModelProperty(name="serviceUrlTls", value="The HTTPS rest service URL (for admin operations)", example="https://pulsar.example.com:8443")
    private String serviceUrlTls;
    @ApiModelProperty(name="brokerServiceUrl", value="The broker service url (for produce and consume operations)", example="pulsar://pulsar.example.com:6650")
    private String brokerServiceUrl;
    @ApiModelProperty(name="brokerServiceUrlTls", value="The secured broker service url (for produce and consume operations)", example="pulsar+ssl://pulsar.example.com:6651")
    private String brokerServiceUrlTls;
    @ApiModelProperty(name="proxyServiceUrl", value="Proxy-service url when client would like to connect to broker via proxy.", example="pulsar+ssl://ats-proxy.example.com:4443 or pulsar://ats-proxy.example.com:4080")
    private String proxyServiceUrl;
    @ApiModelProperty(name="authenticationPlugin", value="Authentication plugin when client would like to connect to cluster.", example="org.apache.pulsar.client.impl.auth.AuthenticationToken")
    private String authenticationPlugin;
    @ApiModelProperty(name="authenticationParameters", value="Authentication parameters when client would like to connect to cluster.")
    private String authenticationParameters;
    @ApiModelProperty(name="proxyProtocol", value="protocol to decide type of proxy routing eg: SNI-routing", example="SNI")
    private ProxyProtocol proxyProtocol;
    @ApiModelProperty(name="peerClusterNames", value="A set of peer cluster names")
    private LinkedHashSet<String> peerClusterNames;
    @ApiModelProperty(name="brokerClientTlsEnabled", value="Enable TLS when talking with other brokers in the same cluster (admin operation) or different clusters (replication)")
    private boolean brokerClientTlsEnabled;
    @ApiModelProperty(name="tlsAllowInsecureConnection", value="Allow TLS connections to servers whose certificate cannot be be verified to have been signed by a trusted certificate authority.")
    private boolean tlsAllowInsecureConnection;
    @ApiModelProperty(name="brokerClientTlsEnabledWithKeyStore", value="Whether internal client use KeyStore type to authenticate with other Pulsar brokers")
    private boolean brokerClientTlsEnabledWithKeyStore;
    @ApiModelProperty(name="brokerClientTlsTrustStoreType", value="TLS TrustStore type configuration for internal client: JKS, PKCS12 used by the internal client to authenticate with Pulsar brokers", example="JKS")
    private String brokerClientTlsTrustStoreType;
    @ApiModelProperty(name="brokerClientTlsTrustStore", value="TLS TrustStore path for internal client used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStore;
    @ApiModelProperty(name="brokerClientTlsTrustStorePassword", value="TLS TrustStore password for internal client used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStorePassword;
    @ApiModelProperty(name="brokerClientTlsKeyStoreType", value="TLS KeyStore type configuration for internal client: JKS, PKCS12, used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsKeyStoreType;
    @ApiModelProperty(name="brokerClientTlsKeyStore", value="TLS KeyStore path for internal client,  used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsKeyStore;
    @ApiModelProperty(name="brokerClientTlsKeyStorePassword", value="TLS KeyStore password for internal client,  used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsKeyStorePassword;
    @ApiModelProperty(name="brokerClientTrustCertsFilePath", value="Path for the trusted TLS certificate file for outgoing connection to a server (broker)")
    private String brokerClientTrustCertsFilePath;
    @ApiModelProperty(name="brokerClientKeyFilePath", value="TLS private key file for internal client, used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientKeyFilePath;
    @ApiModelProperty(name="brokerClientCertificateFilePath", value="TLS certificate file for internal client, used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientCertificateFilePath;
    @ApiModelProperty(name="listenerName", value="listenerName when client would like to connect to cluster", example="")
    private String listenerName;

    public static ClusterDataImplBuilder builder() {
        return new ClusterDataImplBuilder();
    }

    public ClusterDataImplBuilder clone() {
        return ClusterDataImpl.builder().serviceUrl(this.serviceUrl).serviceUrlTls(this.serviceUrlTls).brokerServiceUrl(this.brokerServiceUrl).brokerServiceUrlTls(this.brokerServiceUrlTls).proxyServiceUrl(this.proxyServiceUrl).authenticationPlugin(this.authenticationPlugin).authenticationParameters(this.authenticationParameters).proxyProtocol(this.proxyProtocol).peerClusterNames((LinkedHashSet)this.peerClusterNames).brokerClientTlsEnabled(this.brokerClientTlsEnabled).tlsAllowInsecureConnection(this.tlsAllowInsecureConnection).brokerClientTlsEnabledWithKeyStore(this.brokerClientTlsEnabledWithKeyStore).brokerClientTlsTrustStoreType(this.brokerClientTlsTrustStoreType).brokerClientTlsTrustStore(this.brokerClientTlsTrustStore).brokerClientTlsTrustStorePassword(this.brokerClientTlsTrustStorePassword).brokerClientTlsKeyStoreType(this.brokerClientTlsKeyStoreType).brokerClientTlsKeyStore(this.brokerClientTlsKeyStore).brokerClientTlsKeyStorePassword(this.brokerClientTlsKeyStorePassword).brokerClientTrustCertsFilePath(this.brokerClientTrustCertsFilePath).brokerClientCertificateFilePath(this.brokerClientCertificateFilePath).brokerClientKeyFilePath(this.brokerClientKeyFilePath).listenerName(this.listenerName);
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public String getProxyServiceUrl() {
        return this.proxyServiceUrl;
    }

    public String getAuthenticationPlugin() {
        return this.authenticationPlugin;
    }

    public String getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public ProxyProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public LinkedHashSet<String> getPeerClusterNames() {
        return this.peerClusterNames;
    }

    public boolean isBrokerClientTlsEnabled() {
        return this.brokerClientTlsEnabled;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isBrokerClientTlsEnabledWithKeyStore() {
        return this.brokerClientTlsEnabledWithKeyStore;
    }

    public String getBrokerClientTlsTrustStoreType() {
        return this.brokerClientTlsTrustStoreType;
    }

    public String getBrokerClientTlsTrustStore() {
        return this.brokerClientTlsTrustStore;
    }

    public String getBrokerClientTlsTrustStorePassword() {
        return this.brokerClientTlsTrustStorePassword;
    }

    public String getBrokerClientTlsKeyStoreType() {
        return this.brokerClientTlsKeyStoreType;
    }

    public String getBrokerClientTlsKeyStore() {
        return this.brokerClientTlsKeyStore;
    }

    public String getBrokerClientTlsKeyStorePassword() {
        return this.brokerClientTlsKeyStorePassword;
    }

    public String getBrokerClientTrustCertsFilePath() {
        return this.brokerClientTrustCertsFilePath;
    }

    public String getBrokerClientKeyFilePath() {
        return this.brokerClientKeyFilePath;
    }

    public String getBrokerClientCertificateFilePath() {
        return this.brokerClientCertificateFilePath;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceUrlTls(String serviceUrlTls) {
        this.serviceUrlTls = serviceUrlTls;
    }

    public void setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public void setProxyServiceUrl(String proxyServiceUrl) {
        this.proxyServiceUrl = proxyServiceUrl;
    }

    public void setAuthenticationPlugin(String authenticationPlugin) {
        this.authenticationPlugin = authenticationPlugin;
    }

    public void setAuthenticationParameters(String authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
    }

    public void setProxyProtocol(ProxyProtocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public void setPeerClusterNames(LinkedHashSet<String> peerClusterNames) {
        this.peerClusterNames = peerClusterNames;
    }

    public void setBrokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
        this.brokerClientTlsEnabled = brokerClientTlsEnabled;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setBrokerClientTlsEnabledWithKeyStore(boolean brokerClientTlsEnabledWithKeyStore) {
        this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
    }

    public void setBrokerClientTlsTrustStoreType(String brokerClientTlsTrustStoreType) {
        this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
    }

    public void setBrokerClientTlsTrustStore(String brokerClientTlsTrustStore) {
        this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
    }

    public void setBrokerClientTlsTrustStorePassword(String brokerClientTlsTrustStorePassword) {
        this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
    }

    public void setBrokerClientTlsKeyStoreType(String brokerClientTlsKeyStoreType) {
        this.brokerClientTlsKeyStoreType = brokerClientTlsKeyStoreType;
    }

    public void setBrokerClientTlsKeyStore(String brokerClientTlsKeyStore) {
        this.brokerClientTlsKeyStore = brokerClientTlsKeyStore;
    }

    public void setBrokerClientTlsKeyStorePassword(String brokerClientTlsKeyStorePassword) {
        this.brokerClientTlsKeyStorePassword = brokerClientTlsKeyStorePassword;
    }

    public void setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
    }

    public void setBrokerClientKeyFilePath(String brokerClientKeyFilePath) {
        this.brokerClientKeyFilePath = brokerClientKeyFilePath;
    }

    public void setBrokerClientCertificateFilePath(String brokerClientCertificateFilePath) {
        this.brokerClientCertificateFilePath = brokerClientCertificateFilePath;
    }

    public void setListenerName(String listenerName) {
        this.listenerName = listenerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterDataImpl)) {
            return false;
        }
        ClusterDataImpl other = (ClusterDataImpl)o;
        if (this.isBrokerClientTlsEnabled() != other.isBrokerClientTlsEnabled()) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isBrokerClientTlsEnabledWithKeyStore() != other.isBrokerClientTlsEnabledWithKeyStore()) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$serviceUrlTls = this.getServiceUrlTls();
        String other$serviceUrlTls = other.getServiceUrlTls();
        if (this$serviceUrlTls == null ? other$serviceUrlTls != null : !this$serviceUrlTls.equals(other$serviceUrlTls)) {
            return false;
        }
        String this$brokerServiceUrl = this.getBrokerServiceUrl();
        String other$brokerServiceUrl = other.getBrokerServiceUrl();
        if (this$brokerServiceUrl == null ? other$brokerServiceUrl != null : !this$brokerServiceUrl.equals(other$brokerServiceUrl)) {
            return false;
        }
        String this$brokerServiceUrlTls = this.getBrokerServiceUrlTls();
        String other$brokerServiceUrlTls = other.getBrokerServiceUrlTls();
        if (this$brokerServiceUrlTls == null ? other$brokerServiceUrlTls != null : !this$brokerServiceUrlTls.equals(other$brokerServiceUrlTls)) {
            return false;
        }
        String this$proxyServiceUrl = this.getProxyServiceUrl();
        String other$proxyServiceUrl = other.getProxyServiceUrl();
        if (this$proxyServiceUrl == null ? other$proxyServiceUrl != null : !this$proxyServiceUrl.equals(other$proxyServiceUrl)) {
            return false;
        }
        String this$authenticationPlugin = this.getAuthenticationPlugin();
        String other$authenticationPlugin = other.getAuthenticationPlugin();
        if (this$authenticationPlugin == null ? other$authenticationPlugin != null : !this$authenticationPlugin.equals(other$authenticationPlugin)) {
            return false;
        }
        String this$authenticationParameters = this.getAuthenticationParameters();
        String other$authenticationParameters = other.getAuthenticationParameters();
        if (this$authenticationParameters == null ? other$authenticationParameters != null : !this$authenticationParameters.equals(other$authenticationParameters)) {
            return false;
        }
        ProxyProtocol this$proxyProtocol = this.getProxyProtocol();
        ProxyProtocol other$proxyProtocol = other.getProxyProtocol();
        if (this$proxyProtocol == null ? other$proxyProtocol != null : !this$proxyProtocol.equals(other$proxyProtocol)) {
            return false;
        }
        LinkedHashSet<String> this$peerClusterNames = this.getPeerClusterNames();
        LinkedHashSet<String> other$peerClusterNames = other.getPeerClusterNames();
        if (this$peerClusterNames == null ? other$peerClusterNames != null : !((Object)this$peerClusterNames).equals(other$peerClusterNames)) {
            return false;
        }
        String this$brokerClientTlsTrustStoreType = this.getBrokerClientTlsTrustStoreType();
        String other$brokerClientTlsTrustStoreType = other.getBrokerClientTlsTrustStoreType();
        if (this$brokerClientTlsTrustStoreType == null ? other$brokerClientTlsTrustStoreType != null : !this$brokerClientTlsTrustStoreType.equals(other$brokerClientTlsTrustStoreType)) {
            return false;
        }
        String this$brokerClientTlsTrustStore = this.getBrokerClientTlsTrustStore();
        String other$brokerClientTlsTrustStore = other.getBrokerClientTlsTrustStore();
        if (this$brokerClientTlsTrustStore == null ? other$brokerClientTlsTrustStore != null : !this$brokerClientTlsTrustStore.equals(other$brokerClientTlsTrustStore)) {
            return false;
        }
        String this$brokerClientTlsTrustStorePassword = this.getBrokerClientTlsTrustStorePassword();
        String other$brokerClientTlsTrustStorePassword = other.getBrokerClientTlsTrustStorePassword();
        if (this$brokerClientTlsTrustStorePassword == null ? other$brokerClientTlsTrustStorePassword != null : !this$brokerClientTlsTrustStorePassword.equals(other$brokerClientTlsTrustStorePassword)) {
            return false;
        }
        String this$brokerClientTlsKeyStoreType = this.getBrokerClientTlsKeyStoreType();
        String other$brokerClientTlsKeyStoreType = other.getBrokerClientTlsKeyStoreType();
        if (this$brokerClientTlsKeyStoreType == null ? other$brokerClientTlsKeyStoreType != null : !this$brokerClientTlsKeyStoreType.equals(other$brokerClientTlsKeyStoreType)) {
            return false;
        }
        String this$brokerClientTlsKeyStore = this.getBrokerClientTlsKeyStore();
        String other$brokerClientTlsKeyStore = other.getBrokerClientTlsKeyStore();
        if (this$brokerClientTlsKeyStore == null ? other$brokerClientTlsKeyStore != null : !this$brokerClientTlsKeyStore.equals(other$brokerClientTlsKeyStore)) {
            return false;
        }
        String this$brokerClientTlsKeyStorePassword = this.getBrokerClientTlsKeyStorePassword();
        String other$brokerClientTlsKeyStorePassword = other.getBrokerClientTlsKeyStorePassword();
        if (this$brokerClientTlsKeyStorePassword == null ? other$brokerClientTlsKeyStorePassword != null : !this$brokerClientTlsKeyStorePassword.equals(other$brokerClientTlsKeyStorePassword)) {
            return false;
        }
        String this$brokerClientTrustCertsFilePath = this.getBrokerClientTrustCertsFilePath();
        String other$brokerClientTrustCertsFilePath = other.getBrokerClientTrustCertsFilePath();
        if (this$brokerClientTrustCertsFilePath == null ? other$brokerClientTrustCertsFilePath != null : !this$brokerClientTrustCertsFilePath.equals(other$brokerClientTrustCertsFilePath)) {
            return false;
        }
        String this$brokerClientKeyFilePath = this.getBrokerClientKeyFilePath();
        String other$brokerClientKeyFilePath = other.getBrokerClientKeyFilePath();
        if (this$brokerClientKeyFilePath == null ? other$brokerClientKeyFilePath != null : !this$brokerClientKeyFilePath.equals(other$brokerClientKeyFilePath)) {
            return false;
        }
        String this$brokerClientCertificateFilePath = this.getBrokerClientCertificateFilePath();
        String other$brokerClientCertificateFilePath = other.getBrokerClientCertificateFilePath();
        if (this$brokerClientCertificateFilePath == null ? other$brokerClientCertificateFilePath != null : !this$brokerClientCertificateFilePath.equals(other$brokerClientCertificateFilePath)) {
            return false;
        }
        String this$listenerName = this.getListenerName();
        String other$listenerName = other.getListenerName();
        return !(this$listenerName == null ? other$listenerName != null : !this$listenerName.equals(other$listenerName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBrokerClientTlsEnabled() ? 79 : 97);
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isBrokerClientTlsEnabledWithKeyStore() ? 79 : 97);
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $serviceUrlTls = this.getServiceUrlTls();
        result = result * 59 + ($serviceUrlTls == null ? 43 : $serviceUrlTls.hashCode());
        String $brokerServiceUrl = this.getBrokerServiceUrl();
        result = result * 59 + ($brokerServiceUrl == null ? 43 : $brokerServiceUrl.hashCode());
        String $brokerServiceUrlTls = this.getBrokerServiceUrlTls();
        result = result * 59 + ($brokerServiceUrlTls == null ? 43 : $brokerServiceUrlTls.hashCode());
        String $proxyServiceUrl = this.getProxyServiceUrl();
        result = result * 59 + ($proxyServiceUrl == null ? 43 : $proxyServiceUrl.hashCode());
        String $authenticationPlugin = this.getAuthenticationPlugin();
        result = result * 59 + ($authenticationPlugin == null ? 43 : $authenticationPlugin.hashCode());
        String $authenticationParameters = this.getAuthenticationParameters();
        result = result * 59 + ($authenticationParameters == null ? 43 : $authenticationParameters.hashCode());
        ProxyProtocol $proxyProtocol = this.getProxyProtocol();
        result = result * 59 + ($proxyProtocol == null ? 43 : $proxyProtocol.hashCode());
        LinkedHashSet<String> $peerClusterNames = this.getPeerClusterNames();
        result = result * 59 + ($peerClusterNames == null ? 43 : ((Object)$peerClusterNames).hashCode());
        String $brokerClientTlsTrustStoreType = this.getBrokerClientTlsTrustStoreType();
        result = result * 59 + ($brokerClientTlsTrustStoreType == null ? 43 : $brokerClientTlsTrustStoreType.hashCode());
        String $brokerClientTlsTrustStore = this.getBrokerClientTlsTrustStore();
        result = result * 59 + ($brokerClientTlsTrustStore == null ? 43 : $brokerClientTlsTrustStore.hashCode());
        String $brokerClientTlsTrustStorePassword = this.getBrokerClientTlsTrustStorePassword();
        result = result * 59 + ($brokerClientTlsTrustStorePassword == null ? 43 : $brokerClientTlsTrustStorePassword.hashCode());
        String $brokerClientTlsKeyStoreType = this.getBrokerClientTlsKeyStoreType();
        result = result * 59 + ($brokerClientTlsKeyStoreType == null ? 43 : $brokerClientTlsKeyStoreType.hashCode());
        String $brokerClientTlsKeyStore = this.getBrokerClientTlsKeyStore();
        result = result * 59 + ($brokerClientTlsKeyStore == null ? 43 : $brokerClientTlsKeyStore.hashCode());
        String $brokerClientTlsKeyStorePassword = this.getBrokerClientTlsKeyStorePassword();
        result = result * 59 + ($brokerClientTlsKeyStorePassword == null ? 43 : $brokerClientTlsKeyStorePassword.hashCode());
        String $brokerClientTrustCertsFilePath = this.getBrokerClientTrustCertsFilePath();
        result = result * 59 + ($brokerClientTrustCertsFilePath == null ? 43 : $brokerClientTrustCertsFilePath.hashCode());
        String $brokerClientKeyFilePath = this.getBrokerClientKeyFilePath();
        result = result * 59 + ($brokerClientKeyFilePath == null ? 43 : $brokerClientKeyFilePath.hashCode());
        String $brokerClientCertificateFilePath = this.getBrokerClientCertificateFilePath();
        result = result * 59 + ($brokerClientCertificateFilePath == null ? 43 : $brokerClientCertificateFilePath.hashCode());
        String $listenerName = this.getListenerName();
        result = result * 59 + ($listenerName == null ? 43 : $listenerName.hashCode());
        return result;
    }

    public String toString() {
        return "ClusterDataImpl(serviceUrl=" + this.getServiceUrl() + ", serviceUrlTls=" + this.getServiceUrlTls() + ", brokerServiceUrl=" + this.getBrokerServiceUrl() + ", brokerServiceUrlTls=" + this.getBrokerServiceUrlTls() + ", proxyServiceUrl=" + this.getProxyServiceUrl() + ", authenticationPlugin=" + this.getAuthenticationPlugin() + ", authenticationParameters=" + this.getAuthenticationParameters() + ", proxyProtocol=" + this.getProxyProtocol() + ", peerClusterNames=" + this.getPeerClusterNames() + ", brokerClientTlsEnabled=" + this.isBrokerClientTlsEnabled() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", brokerClientTlsEnabledWithKeyStore=" + this.isBrokerClientTlsEnabledWithKeyStore() + ", brokerClientTlsTrustStoreType=" + this.getBrokerClientTlsTrustStoreType() + ", brokerClientTlsTrustStore=" + this.getBrokerClientTlsTrustStore() + ", brokerClientTlsTrustStorePassword=" + this.getBrokerClientTlsTrustStorePassword() + ", brokerClientTlsKeyStoreType=" + this.getBrokerClientTlsKeyStoreType() + ", brokerClientTlsKeyStore=" + this.getBrokerClientTlsKeyStore() + ", brokerClientTlsKeyStorePassword=" + this.getBrokerClientTlsKeyStorePassword() + ", brokerClientTrustCertsFilePath=" + this.getBrokerClientTrustCertsFilePath() + ", brokerClientKeyFilePath=" + this.getBrokerClientKeyFilePath() + ", brokerClientCertificateFilePath=" + this.getBrokerClientCertificateFilePath() + ", listenerName=" + this.getListenerName() + ")";
    }

    public ClusterDataImpl(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls, String proxyServiceUrl, String authenticationPlugin, String authenticationParameters, ProxyProtocol proxyProtocol, LinkedHashSet<String> peerClusterNames, boolean brokerClientTlsEnabled, boolean tlsAllowInsecureConnection, boolean brokerClientTlsEnabledWithKeyStore, String brokerClientTlsTrustStoreType, String brokerClientTlsTrustStore, String brokerClientTlsTrustStorePassword, String brokerClientTlsKeyStoreType, String brokerClientTlsKeyStore, String brokerClientTlsKeyStorePassword, String brokerClientTrustCertsFilePath, String brokerClientKeyFilePath, String brokerClientCertificateFilePath, String listenerName) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
        this.proxyServiceUrl = proxyServiceUrl;
        this.authenticationPlugin = authenticationPlugin;
        this.authenticationParameters = authenticationParameters;
        this.proxyProtocol = proxyProtocol;
        this.peerClusterNames = peerClusterNames;
        this.brokerClientTlsEnabled = brokerClientTlsEnabled;
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
        this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
        this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
        this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
        this.brokerClientTlsKeyStoreType = brokerClientTlsKeyStoreType;
        this.brokerClientTlsKeyStore = brokerClientTlsKeyStore;
        this.brokerClientTlsKeyStorePassword = brokerClientTlsKeyStorePassword;
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
        this.brokerClientKeyFilePath = brokerClientKeyFilePath;
        this.brokerClientCertificateFilePath = brokerClientCertificateFilePath;
        this.listenerName = listenerName;
    }

    public ClusterDataImpl() {
    }

    public static class ClusterDataImplBuilder
    implements ClusterData.Builder {
        private String serviceUrl;
        private String serviceUrlTls;
        private String brokerServiceUrl;
        private String brokerServiceUrlTls;
        private String proxyServiceUrl;
        private String authenticationPlugin;
        private String authenticationParameters;
        private ProxyProtocol proxyProtocol;
        private LinkedHashSet<String> peerClusterNames;
        private boolean brokerClientTlsEnabled = false;
        private boolean tlsAllowInsecureConnection = false;
        private boolean brokerClientTlsEnabledWithKeyStore = false;
        private String brokerClientTlsTrustStoreType = "JKS";
        private String brokerClientTlsTrustStore;
        private String brokerClientTlsTrustStorePassword;
        private String brokerClientTlsKeyStoreType = "JKS";
        private String brokerClientTlsKeyStore;
        private String brokerClientTlsKeyStorePassword;
        private String brokerClientCertificateFilePath;
        private String brokerClientKeyFilePath;
        private String brokerClientTrustCertsFilePath;
        private String listenerName;

        ClusterDataImplBuilder() {
        }

        public ClusterDataImplBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public ClusterDataImplBuilder serviceUrlTls(String serviceUrlTls) {
            this.serviceUrlTls = serviceUrlTls;
            return this;
        }

        public ClusterDataImplBuilder brokerServiceUrl(String brokerServiceUrl) {
            this.brokerServiceUrl = brokerServiceUrl;
            return this;
        }

        public ClusterDataImplBuilder brokerServiceUrlTls(String brokerServiceUrlTls) {
            this.brokerServiceUrlTls = brokerServiceUrlTls;
            return this;
        }

        public ClusterDataImplBuilder proxyServiceUrl(String proxyServiceUrl) {
            this.proxyServiceUrl = proxyServiceUrl;
            return this;
        }

        public ClusterDataImplBuilder authenticationPlugin(String authenticationPlugin) {
            this.authenticationPlugin = authenticationPlugin;
            return this;
        }

        public ClusterDataImplBuilder authenticationParameters(String authenticationParameters) {
            this.authenticationParameters = authenticationParameters;
            return this;
        }

        public ClusterDataImplBuilder proxyProtocol(ProxyProtocol proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
            return this;
        }

        public ClusterDataImplBuilder peerClusterNames(LinkedHashSet<String> peerClusterNames) {
            this.peerClusterNames = peerClusterNames;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
            this.brokerClientTlsEnabled = brokerClientTlsEnabled;
            return this;
        }

        public ClusterDataImplBuilder tlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
            this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTlsEnabledWithKeyStore(boolean brokerClientTlsEnabledWithKeyStore) {
            this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTlsTrustStoreType(String brokerClientTlsTrustStoreType) {
            this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTlsTrustStore(String brokerClientTlsTrustStore) {
            this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTlsTrustStorePassword(String brokerClientTlsTrustStorePassword) {
            this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTlsKeyStoreType(String keyStoreType) {
            this.brokerClientTlsKeyStoreType = keyStoreType;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTlsKeyStorePassword(String keyStorePassword) {
            this.brokerClientTlsKeyStorePassword = keyStorePassword;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTlsKeyStore(String keyStore) {
            this.brokerClientTlsKeyStore = keyStore;
            return this;
        }

        public ClusterDataImplBuilder brokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
            this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
            return this;
        }

        public ClusterDataImplBuilder brokerClientCertificateFilePath(String certificateFilePath) {
            this.brokerClientCertificateFilePath = certificateFilePath;
            return this;
        }

        public ClusterDataImplBuilder brokerClientKeyFilePath(String keyFilePath) {
            this.brokerClientKeyFilePath = keyFilePath;
            return this;
        }

        public ClusterDataImplBuilder listenerName(String listenerName) {
            this.listenerName = listenerName;
            return this;
        }

        public ClusterDataImpl build() {
            return new ClusterDataImpl(this.serviceUrl, this.serviceUrlTls, this.brokerServiceUrl, this.brokerServiceUrlTls, this.proxyServiceUrl, this.authenticationPlugin, this.authenticationParameters, this.proxyProtocol, this.peerClusterNames, this.brokerClientTlsEnabled, this.tlsAllowInsecureConnection, this.brokerClientTlsEnabledWithKeyStore, this.brokerClientTlsTrustStoreType, this.brokerClientTlsTrustStore, this.brokerClientTlsTrustStorePassword, this.brokerClientTlsKeyStoreType, this.brokerClientTlsKeyStore, this.brokerClientTlsKeyStorePassword, this.brokerClientTrustCertsFilePath, this.brokerClientKeyFilePath, this.brokerClientCertificateFilePath, this.listenerName);
        }

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public String getServiceUrlTls() {
            return this.serviceUrlTls;
        }

        public String getBrokerServiceUrl() {
            return this.brokerServiceUrl;
        }

        public String getBrokerServiceUrlTls() {
            return this.brokerServiceUrlTls;
        }

        public String getProxyServiceUrl() {
            return this.proxyServiceUrl;
        }

        public String getAuthenticationPlugin() {
            return this.authenticationPlugin;
        }

        public String getAuthenticationParameters() {
            return this.authenticationParameters;
        }

        public ProxyProtocol getProxyProtocol() {
            return this.proxyProtocol;
        }

        public LinkedHashSet<String> getPeerClusterNames() {
            return this.peerClusterNames;
        }

        public boolean isBrokerClientTlsEnabled() {
            return this.brokerClientTlsEnabled;
        }

        public boolean isTlsAllowInsecureConnection() {
            return this.tlsAllowInsecureConnection;
        }

        public boolean isBrokerClientTlsEnabledWithKeyStore() {
            return this.brokerClientTlsEnabledWithKeyStore;
        }

        public String getBrokerClientTlsTrustStoreType() {
            return this.brokerClientTlsTrustStoreType;
        }

        public String getBrokerClientTlsTrustStore() {
            return this.brokerClientTlsTrustStore;
        }

        public String getBrokerClientTlsTrustStorePassword() {
            return this.brokerClientTlsTrustStorePassword;
        }

        public String getBrokerClientTlsKeyStoreType() {
            return this.brokerClientTlsKeyStoreType;
        }

        public String getBrokerClientTlsKeyStore() {
            return this.brokerClientTlsKeyStore;
        }

        public String getBrokerClientTlsKeyStorePassword() {
            return this.brokerClientTlsKeyStorePassword;
        }

        public String getBrokerClientCertificateFilePath() {
            return this.brokerClientCertificateFilePath;
        }

        public String getBrokerClientKeyFilePath() {
            return this.brokerClientKeyFilePath;
        }

        public String getBrokerClientTrustCertsFilePath() {
            return this.brokerClientTrustCertsFilePath;
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public void setServiceUrlTls(String serviceUrlTls) {
            this.serviceUrlTls = serviceUrlTls;
        }

        public void setBrokerServiceUrl(String brokerServiceUrl) {
            this.brokerServiceUrl = brokerServiceUrl;
        }

        public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
            this.brokerServiceUrlTls = brokerServiceUrlTls;
        }

        public void setProxyServiceUrl(String proxyServiceUrl) {
            this.proxyServiceUrl = proxyServiceUrl;
        }

        public void setAuthenticationPlugin(String authenticationPlugin) {
            this.authenticationPlugin = authenticationPlugin;
        }

        public void setAuthenticationParameters(String authenticationParameters) {
            this.authenticationParameters = authenticationParameters;
        }

        public void setProxyProtocol(ProxyProtocol proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
        }

        public void setPeerClusterNames(LinkedHashSet<String> peerClusterNames) {
            this.peerClusterNames = peerClusterNames;
        }

        public void setBrokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
            this.brokerClientTlsEnabled = brokerClientTlsEnabled;
        }

        public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
            this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        }

        public void setBrokerClientTlsEnabledWithKeyStore(boolean brokerClientTlsEnabledWithKeyStore) {
            this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
        }

        public void setBrokerClientTlsTrustStoreType(String brokerClientTlsTrustStoreType) {
            this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
        }

        public void setBrokerClientTlsTrustStore(String brokerClientTlsTrustStore) {
            this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
        }

        public void setBrokerClientTlsTrustStorePassword(String brokerClientTlsTrustStorePassword) {
            this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
        }

        public void setBrokerClientTlsKeyStoreType(String brokerClientTlsKeyStoreType) {
            this.brokerClientTlsKeyStoreType = brokerClientTlsKeyStoreType;
        }

        public void setBrokerClientTlsKeyStore(String brokerClientTlsKeyStore) {
            this.brokerClientTlsKeyStore = brokerClientTlsKeyStore;
        }

        public void setBrokerClientTlsKeyStorePassword(String brokerClientTlsKeyStorePassword) {
            this.brokerClientTlsKeyStorePassword = brokerClientTlsKeyStorePassword;
        }

        public void setBrokerClientCertificateFilePath(String brokerClientCertificateFilePath) {
            this.brokerClientCertificateFilePath = brokerClientCertificateFilePath;
        }

        public void setBrokerClientKeyFilePath(String brokerClientKeyFilePath) {
            this.brokerClientKeyFilePath = brokerClientKeyFilePath;
        }

        public void setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
            this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
        }

        public void setListenerName(String listenerName) {
            this.listenerName = listenerName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterDataImplBuilder)) {
                return false;
            }
            ClusterDataImplBuilder other = (ClusterDataImplBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isBrokerClientTlsEnabled() != other.isBrokerClientTlsEnabled()) {
                return false;
            }
            if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
                return false;
            }
            if (this.isBrokerClientTlsEnabledWithKeyStore() != other.isBrokerClientTlsEnabledWithKeyStore()) {
                return false;
            }
            String this$serviceUrl = this.getServiceUrl();
            String other$serviceUrl = other.getServiceUrl();
            if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
                return false;
            }
            String this$serviceUrlTls = this.getServiceUrlTls();
            String other$serviceUrlTls = other.getServiceUrlTls();
            if (this$serviceUrlTls == null ? other$serviceUrlTls != null : !this$serviceUrlTls.equals(other$serviceUrlTls)) {
                return false;
            }
            String this$brokerServiceUrl = this.getBrokerServiceUrl();
            String other$brokerServiceUrl = other.getBrokerServiceUrl();
            if (this$brokerServiceUrl == null ? other$brokerServiceUrl != null : !this$brokerServiceUrl.equals(other$brokerServiceUrl)) {
                return false;
            }
            String this$brokerServiceUrlTls = this.getBrokerServiceUrlTls();
            String other$brokerServiceUrlTls = other.getBrokerServiceUrlTls();
            if (this$brokerServiceUrlTls == null ? other$brokerServiceUrlTls != null : !this$brokerServiceUrlTls.equals(other$brokerServiceUrlTls)) {
                return false;
            }
            String this$proxyServiceUrl = this.getProxyServiceUrl();
            String other$proxyServiceUrl = other.getProxyServiceUrl();
            if (this$proxyServiceUrl == null ? other$proxyServiceUrl != null : !this$proxyServiceUrl.equals(other$proxyServiceUrl)) {
                return false;
            }
            String this$authenticationPlugin = this.getAuthenticationPlugin();
            String other$authenticationPlugin = other.getAuthenticationPlugin();
            if (this$authenticationPlugin == null ? other$authenticationPlugin != null : !this$authenticationPlugin.equals(other$authenticationPlugin)) {
                return false;
            }
            String this$authenticationParameters = this.getAuthenticationParameters();
            String other$authenticationParameters = other.getAuthenticationParameters();
            if (this$authenticationParameters == null ? other$authenticationParameters != null : !this$authenticationParameters.equals(other$authenticationParameters)) {
                return false;
            }
            ProxyProtocol this$proxyProtocol = this.getProxyProtocol();
            ProxyProtocol other$proxyProtocol = other.getProxyProtocol();
            if (this$proxyProtocol == null ? other$proxyProtocol != null : !this$proxyProtocol.equals(other$proxyProtocol)) {
                return false;
            }
            LinkedHashSet<String> this$peerClusterNames = this.getPeerClusterNames();
            LinkedHashSet<String> other$peerClusterNames = other.getPeerClusterNames();
            if (this$peerClusterNames == null ? other$peerClusterNames != null : !((Object)this$peerClusterNames).equals(other$peerClusterNames)) {
                return false;
            }
            String this$brokerClientTlsTrustStoreType = this.getBrokerClientTlsTrustStoreType();
            String other$brokerClientTlsTrustStoreType = other.getBrokerClientTlsTrustStoreType();
            if (this$brokerClientTlsTrustStoreType == null ? other$brokerClientTlsTrustStoreType != null : !this$brokerClientTlsTrustStoreType.equals(other$brokerClientTlsTrustStoreType)) {
                return false;
            }
            String this$brokerClientTlsTrustStore = this.getBrokerClientTlsTrustStore();
            String other$brokerClientTlsTrustStore = other.getBrokerClientTlsTrustStore();
            if (this$brokerClientTlsTrustStore == null ? other$brokerClientTlsTrustStore != null : !this$brokerClientTlsTrustStore.equals(other$brokerClientTlsTrustStore)) {
                return false;
            }
            String this$brokerClientTlsTrustStorePassword = this.getBrokerClientTlsTrustStorePassword();
            String other$brokerClientTlsTrustStorePassword = other.getBrokerClientTlsTrustStorePassword();
            if (this$brokerClientTlsTrustStorePassword == null ? other$brokerClientTlsTrustStorePassword != null : !this$brokerClientTlsTrustStorePassword.equals(other$brokerClientTlsTrustStorePassword)) {
                return false;
            }
            String this$brokerClientTlsKeyStoreType = this.getBrokerClientTlsKeyStoreType();
            String other$brokerClientTlsKeyStoreType = other.getBrokerClientTlsKeyStoreType();
            if (this$brokerClientTlsKeyStoreType == null ? other$brokerClientTlsKeyStoreType != null : !this$brokerClientTlsKeyStoreType.equals(other$brokerClientTlsKeyStoreType)) {
                return false;
            }
            String this$brokerClientTlsKeyStore = this.getBrokerClientTlsKeyStore();
            String other$brokerClientTlsKeyStore = other.getBrokerClientTlsKeyStore();
            if (this$brokerClientTlsKeyStore == null ? other$brokerClientTlsKeyStore != null : !this$brokerClientTlsKeyStore.equals(other$brokerClientTlsKeyStore)) {
                return false;
            }
            String this$brokerClientTlsKeyStorePassword = this.getBrokerClientTlsKeyStorePassword();
            String other$brokerClientTlsKeyStorePassword = other.getBrokerClientTlsKeyStorePassword();
            if (this$brokerClientTlsKeyStorePassword == null ? other$brokerClientTlsKeyStorePassword != null : !this$brokerClientTlsKeyStorePassword.equals(other$brokerClientTlsKeyStorePassword)) {
                return false;
            }
            String this$brokerClientCertificateFilePath = this.getBrokerClientCertificateFilePath();
            String other$brokerClientCertificateFilePath = other.getBrokerClientCertificateFilePath();
            if (this$brokerClientCertificateFilePath == null ? other$brokerClientCertificateFilePath != null : !this$brokerClientCertificateFilePath.equals(other$brokerClientCertificateFilePath)) {
                return false;
            }
            String this$brokerClientKeyFilePath = this.getBrokerClientKeyFilePath();
            String other$brokerClientKeyFilePath = other.getBrokerClientKeyFilePath();
            if (this$brokerClientKeyFilePath == null ? other$brokerClientKeyFilePath != null : !this$brokerClientKeyFilePath.equals(other$brokerClientKeyFilePath)) {
                return false;
            }
            String this$brokerClientTrustCertsFilePath = this.getBrokerClientTrustCertsFilePath();
            String other$brokerClientTrustCertsFilePath = other.getBrokerClientTrustCertsFilePath();
            if (this$brokerClientTrustCertsFilePath == null ? other$brokerClientTrustCertsFilePath != null : !this$brokerClientTrustCertsFilePath.equals(other$brokerClientTrustCertsFilePath)) {
                return false;
            }
            String this$listenerName = this.getListenerName();
            String other$listenerName = other.getListenerName();
            return !(this$listenerName == null ? other$listenerName != null : !this$listenerName.equals(other$listenerName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClusterDataImplBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBrokerClientTlsEnabled() ? 79 : 97);
            result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
            result = result * 59 + (this.isBrokerClientTlsEnabledWithKeyStore() ? 79 : 97);
            String $serviceUrl = this.getServiceUrl();
            result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
            String $serviceUrlTls = this.getServiceUrlTls();
            result = result * 59 + ($serviceUrlTls == null ? 43 : $serviceUrlTls.hashCode());
            String $brokerServiceUrl = this.getBrokerServiceUrl();
            result = result * 59 + ($brokerServiceUrl == null ? 43 : $brokerServiceUrl.hashCode());
            String $brokerServiceUrlTls = this.getBrokerServiceUrlTls();
            result = result * 59 + ($brokerServiceUrlTls == null ? 43 : $brokerServiceUrlTls.hashCode());
            String $proxyServiceUrl = this.getProxyServiceUrl();
            result = result * 59 + ($proxyServiceUrl == null ? 43 : $proxyServiceUrl.hashCode());
            String $authenticationPlugin = this.getAuthenticationPlugin();
            result = result * 59 + ($authenticationPlugin == null ? 43 : $authenticationPlugin.hashCode());
            String $authenticationParameters = this.getAuthenticationParameters();
            result = result * 59 + ($authenticationParameters == null ? 43 : $authenticationParameters.hashCode());
            ProxyProtocol $proxyProtocol = this.getProxyProtocol();
            result = result * 59 + ($proxyProtocol == null ? 43 : $proxyProtocol.hashCode());
            LinkedHashSet<String> $peerClusterNames = this.getPeerClusterNames();
            result = result * 59 + ($peerClusterNames == null ? 43 : ((Object)$peerClusterNames).hashCode());
            String $brokerClientTlsTrustStoreType = this.getBrokerClientTlsTrustStoreType();
            result = result * 59 + ($brokerClientTlsTrustStoreType == null ? 43 : $brokerClientTlsTrustStoreType.hashCode());
            String $brokerClientTlsTrustStore = this.getBrokerClientTlsTrustStore();
            result = result * 59 + ($brokerClientTlsTrustStore == null ? 43 : $brokerClientTlsTrustStore.hashCode());
            String $brokerClientTlsTrustStorePassword = this.getBrokerClientTlsTrustStorePassword();
            result = result * 59 + ($brokerClientTlsTrustStorePassword == null ? 43 : $brokerClientTlsTrustStorePassword.hashCode());
            String $brokerClientTlsKeyStoreType = this.getBrokerClientTlsKeyStoreType();
            result = result * 59 + ($brokerClientTlsKeyStoreType == null ? 43 : $brokerClientTlsKeyStoreType.hashCode());
            String $brokerClientTlsKeyStore = this.getBrokerClientTlsKeyStore();
            result = result * 59 + ($brokerClientTlsKeyStore == null ? 43 : $brokerClientTlsKeyStore.hashCode());
            String $brokerClientTlsKeyStorePassword = this.getBrokerClientTlsKeyStorePassword();
            result = result * 59 + ($brokerClientTlsKeyStorePassword == null ? 43 : $brokerClientTlsKeyStorePassword.hashCode());
            String $brokerClientCertificateFilePath = this.getBrokerClientCertificateFilePath();
            result = result * 59 + ($brokerClientCertificateFilePath == null ? 43 : $brokerClientCertificateFilePath.hashCode());
            String $brokerClientKeyFilePath = this.getBrokerClientKeyFilePath();
            result = result * 59 + ($brokerClientKeyFilePath == null ? 43 : $brokerClientKeyFilePath.hashCode());
            String $brokerClientTrustCertsFilePath = this.getBrokerClientTrustCertsFilePath();
            result = result * 59 + ($brokerClientTrustCertsFilePath == null ? 43 : $brokerClientTrustCertsFilePath.hashCode());
            String $listenerName = this.getListenerName();
            result = result * 59 + ($listenerName == null ? 43 : $listenerName.hashCode());
            return result;
        }

        public String toString() {
            return "ClusterDataImpl.ClusterDataImplBuilder(serviceUrl=" + this.getServiceUrl() + ", serviceUrlTls=" + this.getServiceUrlTls() + ", brokerServiceUrl=" + this.getBrokerServiceUrl() + ", brokerServiceUrlTls=" + this.getBrokerServiceUrlTls() + ", proxyServiceUrl=" + this.getProxyServiceUrl() + ", authenticationPlugin=" + this.getAuthenticationPlugin() + ", authenticationParameters=" + this.getAuthenticationParameters() + ", proxyProtocol=" + this.getProxyProtocol() + ", peerClusterNames=" + this.getPeerClusterNames() + ", brokerClientTlsEnabled=" + this.isBrokerClientTlsEnabled() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", brokerClientTlsEnabledWithKeyStore=" + this.isBrokerClientTlsEnabledWithKeyStore() + ", brokerClientTlsTrustStoreType=" + this.getBrokerClientTlsTrustStoreType() + ", brokerClientTlsTrustStore=" + this.getBrokerClientTlsTrustStore() + ", brokerClientTlsTrustStorePassword=" + this.getBrokerClientTlsTrustStorePassword() + ", brokerClientTlsKeyStoreType=" + this.getBrokerClientTlsKeyStoreType() + ", brokerClientTlsKeyStore=" + this.getBrokerClientTlsKeyStore() + ", brokerClientTlsKeyStorePassword=" + this.getBrokerClientTlsKeyStorePassword() + ", brokerClientCertificateFilePath=" + this.getBrokerClientCertificateFilePath() + ", brokerClientKeyFilePath=" + this.getBrokerClientKeyFilePath() + ", brokerClientTrustCertsFilePath=" + this.getBrokerClientTrustCertsFilePath() + ", listenerName=" + this.getListenerName() + ")";
        }
    }
}

