/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public final class FormatUtils {
    private FormatUtils() {
    }

    public static String formatCount(long count) {
        double fractional = count;
        String unit = "";
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "K";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "M";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "B";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "T";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "Q";
        }
        return String.format("%s%s", FormatUtils.getFormat(fractional).format(fractional), unit);
    }

    public static String formatCountRate(double count, Duration duration, boolean longForm) {
        double rate = count / duration.getValue(TimeUnit.SECONDS);
        if (Double.isNaN(rate) || Double.isInfinite(rate)) {
            rate = 0.0;
        }
        String rateString = FormatUtils.formatCount((long)rate);
        if (longForm) {
            if (rateString.endsWith(" ")) {
                rateString = rateString.substring(0, rateString.length() - 1);
            }
            rateString = rateString + "/s";
        }
        return rateString;
    }

    public static String formatDataSize(DataSize size, boolean longForm) {
        double fractional = size.toBytes();
        String unit = null;
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "K";
        }
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "M";
        }
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "G";
        }
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "T";
        }
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "P";
        }
        if (unit == null) {
            unit = "B";
        } else if (longForm) {
            unit = unit + "B";
        }
        return String.format("%s%s", FormatUtils.getFormat(fractional).format(fractional), unit);
    }

    public static String formatDataRate(DataSize dataSize, Duration duration, boolean longForm) {
        long rate = Math.round((double)dataSize.toBytes() / duration.getValue(TimeUnit.SECONDS));
        if (Double.isNaN(rate) || Double.isInfinite(rate)) {
            rate = 0L;
        }
        String rateString = FormatUtils.formatDataSize(DataSize.ofBytes((long)rate), false);
        if (longForm) {
            if (!rateString.endsWith("B")) {
                rateString = rateString + "B";
            }
            rateString = rateString + "/s";
        }
        return rateString;
    }

    private static DecimalFormat getFormat(double value) {
        DecimalFormat format = value < 10.0 ? new DecimalFormat("#.##") : (value < 100.0 ? new DecimalFormat("#.#") : new DecimalFormat("#"));
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format;
    }

    public static String pluralize(String word, int count) {
        if (count != 1) {
            return word + "s";
        }
        return word;
    }

    public static String formatTime(Duration duration) {
        int totalSeconds = Ints.saturatedCast((long)duration.roundTo(TimeUnit.SECONDS));
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%s:%02d", minutes, seconds);
    }

    public static String formatFinalTime(Duration duration) {
        long totalMillis = duration.toMillis();
        if (totalMillis >= TimeUnit.MINUTES.toMillis(1L)) {
            return FormatUtils.formatTime(duration);
        }
        return String.format("%.2f", (double)totalMillis / 1000.0);
    }

    public static String formatProgressBar(int width, int tick) {
        int markerWidth = 3;
        int range = width - markerWidth;
        int lower = tick % range;
        if (tick / range % 2 == 1) {
            lower = range - lower;
        }
        return Strings.repeat((String)" ", (int)lower) + "<" + Strings.repeat((String)"=", (int)(markerWidth - 2)) + ">" + Strings.repeat((String)" ", (int)(width - (lower + markerWidth)));
    }

    public static String formatProgressBar(int width, int complete, int running, int total) {
        if (total == 0) {
            return Strings.repeat((String)" ", (int)width);
        }
        int pending = Math.max(0, total - complete - running);
        int completeLength = Math.min(width, FormatUtils.ceil(complete * width, total));
        int pendingLength = Math.min(width, FormatUtils.ceil(pending * width, total));
        int minRunningLength = running > 0 ? 1 : 0;
        int runningLength = Math.max(Math.min(width, FormatUtils.ceil(running * width, total)), minRunningLength);
        if (completeLength + runningLength + pendingLength != width && pending > 0) {
            pendingLength = Math.max(0, width - completeLength - runningLength);
        }
        if (completeLength + runningLength + pendingLength != width) {
            runningLength = Math.max(minRunningLength, width - completeLength - pendingLength);
        }
        if (completeLength + runningLength + pendingLength > width && complete > 0) {
            completeLength = Math.max(0, width - runningLength - pendingLength);
        }
        Preconditions.checkState((completeLength + runningLength + pendingLength == width ? 1 : 0) != 0, (String)"Expected completeLength (%s) + runningLength (%s) + pendingLength (%s) == width (%s), was %s for complete = %s, running = %s, total = %s", (Object[])new Object[]{completeLength, runningLength, pendingLength, width, completeLength + runningLength + pendingLength, complete, running, total});
        return Strings.repeat((String)"=", (int)completeLength) + Strings.repeat((String)">", (int)runningLength) + Strings.repeat((String)" ", (int)pendingLength);
    }

    private static int ceil(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }
}

