/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.Duration;
import io.prestosql.cli.ConsolePrinter;
import io.prestosql.cli.QueryPreprocessorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jline.terminal.Terminal;

public final class QueryPreprocessor {
    public static final String ENV_PREPROCESSOR = "PRESTO_PREPROCESSOR";
    public static final String ENV_PREPROCESSOR_TIMEOUT = "PRESTO_PREPROCESSOR_TIMEOUT";
    public static final String ENV_PRESTO_CATALOG = "PRESTO_CATALOG";
    public static final String ENV_PRESTO_SCHEMA = "PRESTO_SCHEMA";
    private static final Duration DEFAULT_PREPROCESSOR_TIMEOUT = new Duration(10.0, TimeUnit.SECONDS);
    private static final String PREPROCESSING_QUERY_MESSAGE = "Preprocessing query...";

    private QueryPreprocessor() {
    }

    public static String preprocessQuery(Terminal terminal, Optional<String> catalog, Optional<String> schema, String query) throws QueryPreprocessorException {
        String preprocessorCommand;
        Duration timeout = DEFAULT_PREPROCESSOR_TIMEOUT;
        String timeoutEnvironment = Strings.nullToEmpty((String)System.getenv(ENV_PREPROCESSOR_TIMEOUT)).trim();
        if (!timeoutEnvironment.isEmpty()) {
            timeout = Duration.valueOf((String)timeoutEnvironment);
        }
        if (Strings.emptyToNull((String)(preprocessorCommand = System.getenv(ENV_PREPROCESSOR))) == null) {
            return query;
        }
        return QueryPreprocessor.preprocessQuery(terminal, catalog, schema, query, (List<String>)ImmutableList.of((Object)"/bin/sh", (Object)"-c", (Object)preprocessorCommand), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String preprocessQuery(Terminal terminal, Optional<String> catalog, Optional<String> schema, String query, List<String> preprocessorCommand, Duration timeout) throws QueryPreprocessorException {
        Thread clientThread = Thread.currentThread();
        Terminal.SignalHandler oldHandler = terminal.handle(Terminal.Signal.INT, signal -> clientThread.interrupt());
        try {
            if (ConsolePrinter.REAL_TERMINAL) {
                System.out.print(PREPROCESSING_QUERY_MESSAGE);
                System.out.flush();
            }
            String string = QueryPreprocessor.preprocessQueryInternal(catalog, schema, query, preprocessorCommand, timeout);
            return string;
        }
        finally {
            if (ConsolePrinter.REAL_TERMINAL) {
                System.out.print("\r" + Strings.repeat((String)" ", (int)PREPROCESSING_QUERY_MESSAGE.length()) + "\r");
                System.out.flush();
            }
            terminal.handle(Terminal.Signal.INT, oldHandler);
            Thread.interrupted();
        }
    }

    private static String preprocessQueryInternal(Optional<String> catalog, Optional<String> schema, String query, List<String> preprocessorCommand, Duration timeout) throws QueryPreprocessorException {
        AtomicReference processReference = new AtomicReference();
        Future<String> task = QueryPreprocessor.executeInNewThread("Query preprocessor", () -> {
            int exitCode;
            String result;
            Future<String> readStderr;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(preprocessorCommand);
                processBuilder.environment().put(ENV_PRESTO_CATALOG, catalog.orElse(""));
                processBuilder.environment().put(ENV_PRESTO_SCHEMA, schema.orElse(""));
                Process process = processBuilder.start();
                processReference.set(process);
                Future<Object> writeOutput = null;
                try {
                    writeOutput = QueryPreprocessor.executeInNewThread("Query preprocessor output", () -> {
                        try (OutputStream outputStream = process.getOutputStream();){
                            outputStream.write(query.getBytes(StandardCharsets.UTF_8));
                        }
                        return null;
                    });
                    readStderr = QueryPreprocessor.executeInNewThread("Query preprocessor read stderr", () -> {
                        StringBuilder builder = new StringBuilder();
                        try (InputStream inputStream = process.getErrorStream();){
                            CharStreams.copy((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8), (Appendable)builder);
                        }
                        catch (IOException | RuntimeException exception) {
                            // empty catch block
                        }
                        return builder.toString();
                    });
                    try (InputStream inputStream = process.getInputStream();){
                        result = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    }
                    try {
                        writeOutput.get();
                    }
                    catch (ExecutionException e) {
                        throw e.getCause();
                    }
                    exitCode = process.waitFor();
                }
                finally {
                    process.destroyForcibly();
                    if (writeOutput != null) {
                        writeOutput.cancel(true);
                    }
                }
            }
            catch (QueryPreprocessorException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new QueryPreprocessorException("Interrupted while preprocessing query");
            }
            catch (Throwable e) {
                throw new QueryPreprocessorException("Error preprocessing query: " + e.getMessage(), e);
            }
            if (exitCode != 0) {
                Optional<String> errorMessage = MoreFutures.tryGetFutureValue(readStderr, (int)100, (TimeUnit)TimeUnit.MILLISECONDS).flatMap(value -> Optional.ofNullable(Strings.emptyToNull((String)value.trim())));
                throw new QueryPreprocessorException("Query preprocessor exited " + exitCode + errorMessage.map(message1 -> "\n===\n" + message1 + "\n===").orElse(""));
            }
            return result;
        });
        try {
            String string = task.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return string;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new QueryPreprocessorException("Interrupted while preprocessing query");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, QueryPreprocessorException.class);
            throw new QueryPreprocessorException("Error preprocessing query: " + cause.getMessage(), cause);
        }
        catch (TimeoutException e) {
            throw new QueryPreprocessorException("Timed out waiting for query preprocessor after " + timeout);
        }
        finally {
            Process process = (Process)processReference.get();
            if (process != null) {
                process.destroyForcibly();
            }
            task.cancel(true);
        }
    }

    private static <T> Future<T> executeInNewThread(String threadName, Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        Thread thread = new Thread(task);
        thread.setName(threadName);
        thread.setDaemon(true);
        thread.start();
        return task;
    }
}

