/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToInterleavedStorageCommand
extends BookieCommand<CTISFlags> {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToInterleavedStorageCommand.class);
    private static final String NAME = "converttointerleavedstorage";
    private static final String DESC = "Convert bookie indexes from DbLedgerStorage to InterleavedStorage format";
    private static final String NOT_INIT = "default formatter";
    private LedgerIdFormatter ledgerIdFormatter;

    public ConvertToInterleavedStorageCommand() {
        this(new CTISFlags());
    }

    public ConvertToInterleavedStorageCommand(CTISFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CTISFlags cmdFlags) {
        this.initLedgerIdFormatter(conf, cmdFlags);
        try {
            return this.handle(conf);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean handle(ServerConfiguration bkConf) throws Exception {
        LOG.info("=== Converting DbLedgerStorage ===");
        ServerConfiguration conf = new ServerConfiguration(bkConf);
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(bkConf, bkConf.getLedgerDirs(), new DiskChecker(bkConf.getDiskUsageThreshold(), bkConf.getDiskUsageWarnThreshold()));
        LedgerDirsManager ledgerIndexManager = new LedgerDirsManager(bkConf, bkConf.getLedgerDirs(), new DiskChecker(bkConf.getDiskUsageThreshold(), bkConf.getDiskUsageWarnThreshold()));
        DbLedgerStorage dbStorage = new DbLedgerStorage();
        InterleavedLedgerStorage interleavedStorage = new InterleavedLedgerStorage();
        CheckpointSource checkpointSource = new CheckpointSource(){

            @Override
            public CheckpointSource.Checkpoint newCheckpoint() {
                return CheckpointSource.Checkpoint.MAX;
            }

            @Override
            public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) {
            }
        };
        Checkpointer checkpointer = new Checkpointer(){

            @Override
            public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
            }

            @Override
            public void start() {
            }
        };
        dbStorage.initialize(conf, null, ledgerDirsManager, ledgerIndexManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        dbStorage.setCheckpointSource(checkpointSource);
        dbStorage.setCheckpointer(checkpointer);
        interleavedStorage.initialize(conf, null, ledgerDirsManager, ledgerIndexManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        interleavedStorage.setCheckpointSource(checkpointSource);
        interleavedStorage.setCheckpointer(checkpointer);
        LedgerCache interleavedLedgerCache = interleavedStorage.getLedgerCache();
        int convertedLedgers = 0;
        for (long ledgerId : dbStorage.getActiveLedgersInRange(0L, Long.MAX_VALUE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Converting ledger {}", (Object)this.ledgerIdFormatter.formatLedgerId(ledgerId));
            }
            interleavedStorage.setMasterKey(ledgerId, dbStorage.readMasterKey(ledgerId));
            if (dbStorage.isFenced(ledgerId)) {
                interleavedStorage.setFenced(ledgerId);
            }
            long lastEntryInLedger = dbStorage.getLastEntryInLedger(ledgerId);
            for (long entryId = 0L; entryId <= lastEntryInLedger; ++entryId) {
                try {
                    long location = dbStorage.getLocation(ledgerId, entryId);
                    if (location == 0L) continue;
                    interleavedLedgerCache.putEntryOffset(ledgerId, entryId, location);
                    continue;
                }
                catch (Bookie.NoEntryException noEntryException) {
                    // empty catch block
                }
            }
            if (++convertedLedgers % 1000 != 0) continue;
            LOG.info("Converted {} ledgers", (Object)convertedLedgers);
        }
        dbStorage.shutdown();
        interleavedLedgerCache.flushLedger(true);
        interleavedStorage.flush();
        interleavedStorage.shutdown();
        String baseDir = ledgerDirsManager.getAllLedgerDirs().get(0).toString();
        Files.move(FileSystems.getDefault().getPath(baseDir, "ledgers"), FileSystems.getDefault().getPath(baseDir, "ledgers.backup"), new CopyOption[0]);
        Files.move(FileSystems.getDefault().getPath(baseDir, "locations"), FileSystems.getDefault().getPath(baseDir, "locations.backup"), new CopyOption[0]);
        LOG.info("---- Done Converting {} ledgers ----", (Object)convertedLedgers);
        return true;
    }

    private void initLedgerIdFormatter(ServerConfiguration conf, CTISFlags flags) {
        if (this.ledgerIdFormatter != null) {
            return;
        }
        this.ledgerIdFormatter = flags.ledgerIdFormatter.equals(NOT_INIT) ? LedgerIdFormatter.newLedgerIdFormatter(conf) : LedgerIdFormatter.newLedgerIdFormatter(flags.ledgerIdFormatter, conf);
    }

    public void setLedgerIdFormatter(LedgerIdFormatter ledgerIdFormatter) {
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    public static class CTISFlags
    extends CliFlags {
        @Parameter(names={"-l", "--ledgeridformatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "default formatter";
    }
}

